/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import java.util.HashMap;
import java.util.Map;
import org.piwik.sdk.Tracker;
import org.piwik.sdk.TrackerConfig;
import org.piwik.sdk.dispatcher.DispatcherFactory;
import org.piwik.sdk.tools.BuildInfo;
import org.piwik.sdk.tools.Checksum;
import org.piwik.sdk.tools.DeviceHelper;
import org.piwik.sdk.tools.PropertySource;
import timber.log.Timber;

public class Piwik {
    public static final String LOGGER_PREFIX = "PIWIK:";
    private static final String LOGGER_TAG = "PIWIK";
    private static final String BASE_PREFERENCE_FILE = "org.piwik.sdk";
    private final Map<Tracker, SharedPreferences> mPreferenceMap = new HashMap<Tracker, SharedPreferences>();
    private final Context mContext;
    private static Piwik sInstance;
    private SharedPreferences mBasePreferences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Piwik getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<Piwik> clazz = Piwik.class;
        synchronized (Piwik.class) {
            if (sInstance != null) return sInstance;
            sInstance = new Piwik(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private Piwik(Context context) {
        this.mContext = context.getApplicationContext();
        this.mBasePreferences = context.getSharedPreferences(BASE_PREFERENCE_FILE, 0);
    }

    public Context getContext() {
        return this.mContext;
    }

    public synchronized Tracker newTracker(@NonNull TrackerConfig trackerConfig) {
        return new Tracker(this, trackerConfig);
    }

    public String getApplicationDomain() {
        return this.getContext().getPackageName();
    }

    public SharedPreferences getPiwikPreferences() {
        return this.mBasePreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedPreferences getTrackerPreferences(@NonNull Tracker tracker) {
        Map<Tracker, SharedPreferences> map = this.mPreferenceMap;
        synchronized (map) {
            SharedPreferences newPrefs = this.mPreferenceMap.get(tracker);
            if (newPrefs == null) {
                String prefName;
                try {
                    prefName = "org.piwik.sdk_" + Checksum.getMD5Checksum(tracker.getName());
                }
                catch (Exception e) {
                    Timber.tag((String)LOGGER_TAG).e((Throwable)e, null, new Object[0]);
                    prefName = "org.piwik.sdk_" + tracker.getName();
                }
                newPrefs = this.getContext().getSharedPreferences(prefName, 0);
                this.mPreferenceMap.put(tracker, newPrefs);
            }
            return newPrefs;
        }
    }

    protected DispatcherFactory getDispatcherFactory() {
        return new DispatcherFactory();
    }

    DeviceHelper getDeviceHelper() {
        return new DeviceHelper(this.mContext, new PropertySource(), new BuildInfo());
    }
}

