/*
 * Decompiled with CFR 0.152.
 */
package de.mateware.snacky;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.google.android.material.R;
import com.google.android.material.snackbar.Snackbar;
import de.mateware.snacky.R;
import de.mateware.snacky.SnackyUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Snacky {
    private final Builder builder;
    public static final int LENGTH_INDEFINITE = -2;
    public static final int LENGTH_SHORT = -1;
    public static final int LENGTH_LONG = 0;

    private Snacky(Builder builder) {
        this.builder = builder;
    }

    private Snackbar make() {
        Snackbar snackbar = Snackbar.make((View)this.builder.view, (CharSequence)this.builder.text, (int)this.builder.duration);
        if (this.builder.actionClickListener != null || this.builder.actionText != null) {
            if (this.builder.actionClickListener == null) {
                this.builder.actionClickListener = new View.OnClickListener(){

                    public void onClick(View v) {
                    }
                };
            }
            snackbar.setAction(this.builder.actionText, this.builder.actionClickListener);
            if (this.builder.actionTextColor == null) {
                this.builder.actionTextColor = this.builder.type.getStandardTextColor();
            }
            if (this.builder.actionTextColors != null) {
                snackbar.setActionTextColor(this.builder.actionTextColors);
            } else if (this.builder.actionTextColor != null) {
                snackbar.setActionTextColor(this.builder.actionTextColor.intValue());
            }
        }
        Snackbar.SnackbarLayout snackbarLayout = (Snackbar.SnackbarLayout)snackbar.getView();
        if (this.builder.backgroundColor == null) {
            this.builder.backgroundColor = this.builder.type.getColor();
        }
        if (this.builder.backgroundColor != null) {
            snackbarLayout.setBackgroundColor(this.builder.backgroundColor.intValue());
        }
        TextView actionText = (TextView)snackbarLayout.findViewById(R.id.snackbar_action);
        if (this.builder.actionTextSize != null) {
            if (this.builder.actionTextSizeUnit != null) {
                actionText.setTextSize(this.builder.actionTextSizeUnit.intValue(), this.builder.actionTextSize.floatValue());
            } else {
                actionText.setTextSize(this.builder.actionTextSize.floatValue());
            }
        }
        Typeface actionTextTypeface = actionText.getTypeface();
        if (this.builder.actionTextTypeface != null) {
            actionTextTypeface = this.builder.actionTextTypeface;
        }
        if (this.builder.actionTextTypefaceStyle != null) {
            actionText.setTypeface(actionTextTypeface, this.builder.actionTextTypefaceStyle.intValue());
        } else {
            actionText.setTypeface(actionTextTypeface);
        }
        TextView text = (TextView)snackbarLayout.findViewById(R.id.snackbar_text);
        if (this.builder.textSize != null) {
            if (this.builder.textSizeUnit != null) {
                text.setTextSize(this.builder.textSizeUnit.intValue(), this.builder.textSize.floatValue());
            } else {
                text.setTextSize(this.builder.textSize.floatValue());
            }
        }
        Typeface textTypeface = text.getTypeface();
        if (this.builder.textTypeface != null) {
            textTypeface = this.builder.textTypeface;
        }
        if (this.builder.textTypefaceStyle != null) {
            text.setTypeface(textTypeface, this.builder.textTypefaceStyle.intValue());
        } else {
            text.setTypeface(textTypeface);
        }
        if (this.builder.textColor == null) {
            this.builder.textColor = this.builder.type.getStandardTextColor();
        }
        if (this.builder.textColors != null) {
            text.setTextColor(this.builder.textColors);
        } else if (this.builder.textColor != null) {
            text.setTextColor(this.builder.textColor.intValue());
        }
        text.setMaxLines(this.builder.maxLines);
        text.setGravity(this.builder.centerText ? 17 : 16);
        if (this.builder.centerText && Build.VERSION.SDK_INT > 16) {
            text.setTextAlignment(4);
        }
        if (this.builder.icon == null) {
            this.builder.icon = this.builder.type.getIcon(this.builder.view.getContext());
        }
        if (this.builder.icon != null) {
            Drawable transparentHelperDrawable = null;
            if (this.builder.centerText && TextUtils.isEmpty((CharSequence)this.builder.actionText)) {
                transparentHelperDrawable = SnackyUtils.makeTransparentDrawable(this.builder.view.getContext(), this.builder.icon.getIntrinsicWidth(), this.builder.icon.getIntrinsicHeight());
            }
            text.setCompoundDrawablesWithIntrinsicBounds(this.builder.icon, null, transparentHelperDrawable, null);
            text.setCompoundDrawablePadding(text.getResources().getDimensionPixelOffset(R.dimen.snacky_icon_padding));
        }
        return snackbar;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private View view = null;
        private Type type = Type.DEFAULT;
        private int duration = -1;
        private CharSequence text = "";
        private int textResId = 0;
        private Integer textColor = null;
        private ColorStateList textColors = null;
        private Integer textSizeUnit = null;
        private Float textSize = null;
        private Integer textTypefaceStyle = null;
        private Typeface textTypeface = null;
        private Integer actionTextSizeUnit = null;
        private Float actionTextSize = null;
        private CharSequence actionText = "";
        private int actionTextResId = 0;
        private Integer actionTextTypefaceStyle = null;
        private Typeface actionTextTypeface = null;
        private View.OnClickListener actionClickListener = null;
        private Integer actionTextColor = null;
        private ColorStateList actionTextColors = null;
        private int maxLines = Integer.MAX_VALUE;
        private boolean centerText = false;
        private Drawable icon = null;
        private int iconResId = 0;
        private Integer backgroundColor = null;

        private Builder() {
        }

        public Builder setActivity(Activity activity) {
            return this.setView(((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0));
        }

        public Builder setView(View view) {
            this.view = view;
            return this;
        }

        public Builder setText(@StringRes int resId) {
            this.textResId = resId;
            return this;
        }

        public Builder setText(CharSequence text) {
            this.textResId = 0;
            this.text = text;
            return this;
        }

        public Builder setTextColor(@ColorInt int color) {
            this.textColor = color;
            return this;
        }

        public Builder setTextColor(ColorStateList colorStateList) {
            this.textColor = null;
            this.textColors = colorStateList;
            return this;
        }

        public Builder setTextSize(float textSize) {
            this.textSizeUnit = null;
            this.textSize = Float.valueOf(textSize);
            return this;
        }

        public Builder setTextSize(int unit, float textSize) {
            this.textSizeUnit = unit;
            this.textSize = Float.valueOf(textSize);
            return this;
        }

        public Builder setTextTypeface(Typeface typeface) {
            this.textTypeface = typeface;
            return this;
        }

        public Builder setTextTypefaceStyle(int style) {
            this.textTypefaceStyle = style;
            return this;
        }

        public Builder centerText() {
            this.centerText = true;
            return this;
        }

        public Builder setActionTextColor(ColorStateList colorStateList) {
            this.actionTextColor = null;
            this.actionTextColors = colorStateList;
            return this;
        }

        public Builder setActionTextColor(@ColorInt int color) {
            this.actionTextColor = color;
            return this;
        }

        public Builder setActionText(@StringRes int resId) {
            this.actionTextResId = resId;
            return this;
        }

        public Builder setActionText(CharSequence text) {
            this.textResId = 0;
            this.actionText = text;
            return this;
        }

        public Builder setActionTextSize(float textSize) {
            this.actionTextSizeUnit = null;
            this.actionTextSize = Float.valueOf(textSize);
            return this;
        }

        public Builder setActionTextSize(int unit, float textSize) {
            this.actionTextSizeUnit = unit;
            this.actionTextSize = Float.valueOf(textSize);
            return this;
        }

        public Builder setActionTextTypeface(Typeface typeface) {
            this.actionTextTypeface = typeface;
            return this;
        }

        public Builder setActionTextTypefaceStyle(int style) {
            this.actionTextTypefaceStyle = style;
            return this;
        }

        public Builder setActionClickListener(View.OnClickListener listener) {
            this.actionClickListener = listener;
            return this;
        }

        public Builder setMaxLines(int maxLines) {
            this.maxLines = maxLines;
            return this;
        }

        public Builder setDuration(int duration) {
            this.duration = duration;
            return this;
        }

        public Builder setIcon(@DrawableRes int resId) {
            this.iconResId = resId;
            return this;
        }

        public Builder setIcon(Drawable drawable2) {
            this.icon = drawable2;
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int color) {
            this.backgroundColor = color;
            return this;
        }

        public Snackbar build() {
            return this.make();
        }

        public Snackbar success() {
            this.type = Type.SUCCESS;
            return this.make();
        }

        public Snackbar info() {
            this.type = Type.INFO;
            return this.make();
        }

        public Snackbar warning() {
            this.type = Type.WARNING;
            return this.make();
        }

        public Snackbar error() {
            this.type = Type.ERROR;
            return this.make();
        }

        private Snackbar make() {
            if (this.view == null) {
                throw new IllegalStateException("Snacky Error: You must set an Activity or a View before making a snack");
            }
            if (this.textResId != 0) {
                this.text = this.view.getResources().getText(this.textResId);
            }
            if (this.actionTextResId != 0) {
                this.actionText = this.view.getResources().getText(this.actionTextResId);
            }
            if (this.iconResId != 0) {
                this.icon = ContextCompat.getDrawable((Context)this.view.getContext(), (int)this.iconResId);
            }
            return new Snacky(this).make();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @IntRange(from=1L)
    public static @interface Duration {
    }

    private static enum Type {
        DEFAULT(null, null, null),
        SUCCESS(Color.parseColor((String)"#388E3C"), R.drawable.ic_check_black_24dp, -1),
        ERROR(Color.parseColor((String)"#D50000"), R.drawable.ic_clear_black_24dp, -1),
        INFO(Color.parseColor((String)"#3F51B5"), R.drawable.ic_info_outline_black_24dp, -1),
        WARNING(Color.parseColor((String)"#FFA900"), R.drawable.ic_error_outline_black_24dp, -16777216);

        private Integer color;
        private Integer iconResId;
        private Integer standardTextColor;

        private Type(@ColorInt Integer color, Integer iconResId, Integer standardTextColor) {
            this.color = color;
            this.iconResId = iconResId;
            this.standardTextColor = standardTextColor;
        }

        public Integer getColor() {
            return this.color;
        }

        public Drawable getIcon(Context context) {
            if (this.iconResId == null) {
                return null;
            }
            Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)this.iconResId);
            if (drawable2 != null) {
                drawable2 = SnackyUtils.tintDrawable(drawable2, this.standardTextColor);
            }
            return drawable2;
        }

        public Integer getStandardTextColor() {
            return this.standardTextColor;
        }
    }
}

