/*
 * Decompiled with CFR 0.152.
 */
package com.masoudss.lib;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import com.masoudss.lib.R;
import com.masoudss.lib.SeekBarOnProgressChanged;
import com.masoudss.lib.Utils;
import com.masoudss.lib.WaveGravity;
import com.masoudss.lib.WaveformSeekBar$WhenMappings;
import com.masoudss.lib.exception.SampleDataException;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010C\u001a\u00020\tH\u0002J\b\u0010D\u001a\u00020\tH\u0002J\u0012\u0010E\u001a\u00020F2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020F2\u0006\u0010J\u001a\u00020\u000fH\u0015J(\u0010K\u001a\u00020F2\u0006\u0010L\u001a\u00020\t2\u0006\u0010M\u001a\u00020\t2\u0006\u0010N\u001a\u00020\t2\u0006\u0010O\u001a\u00020\tH\u0014J\u0012\u0010P\u001a\u00020H2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0016J\b\u0010S\u001a\u00020HH\u0016J\u0012\u0010T\u001a\u00020F2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0002R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R(\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\u001d\u001a\u0004\u0018\u00010#@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010)\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010 \"\u0004\b+\u0010\"R$\u0010,\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R$\u00101\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010.\"\u0004\b3\u00100R$\u00105\u001a\u0002042\u0006\u0010\u001d\u001a\u000204@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R$\u0010:\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010.\"\u0004\b<\u00100R$\u0010=\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010 \"\u0004\b?\u0010\"R$\u0010@\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010.\"\u0004\bB\u00100\u00a8\u0006U"}, d2={"Lcom/masoudss/lib/WaveformSeekBar;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mCanvasHeight", "mCanvasWidth", "mMaxValue", "mProgressCanvas", "Landroid/graphics/Canvas;", "mScaledTouchSlop", "mTouchDownX", "", "mWavePaint", "Landroid/graphics/Paint;", "mWaveRect", "Landroid/graphics/RectF;", "onProgressChanged", "Lcom/masoudss/lib/SeekBarOnProgressChanged;", "getOnProgressChanged", "()Lcom/masoudss/lib/SeekBarOnProgressChanged;", "setOnProgressChanged", "(Lcom/masoudss/lib/SeekBarOnProgressChanged;)V", "value", "progress", "getProgress", "()I", "setProgress", "(I)V", "", "sample", "getSample", "()[I", "setSample", "([I)V", "waveBackgroundColor", "getWaveBackgroundColor", "setWaveBackgroundColor", "waveCornerRadius", "getWaveCornerRadius", "()F", "setWaveCornerRadius", "(F)V", "waveGap", "getWaveGap", "setWaveGap", "Lcom/masoudss/lib/WaveGravity;", "waveGravity", "getWaveGravity", "()Lcom/masoudss/lib/WaveGravity;", "setWaveGravity", "(Lcom/masoudss/lib/WaveGravity;)V", "waveMinHeight", "getWaveMinHeight", "setWaveMinHeight", "waveProgressColor", "getWaveProgressColor", "setWaveProgressColor", "waveWidth", "getWaveWidth", "setWaveWidth", "getAvailableHeight", "getAvailableWith", "init", "", "isParentScrolling", "", "onDraw", "canvas", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "performClick", "updateProgress", "lib_release"})
public final class WaveformSeekBar
extends View {
    private int mCanvasWidth;
    private int mCanvasHeight;
    private final Paint mWavePaint = new Paint(1);
    private final RectF mWaveRect = new RectF();
    private final Canvas mProgressCanvas = new Canvas();
    private int mMaxValue = (int)Utils.INSTANCE.dp(this.getContext(), 2);
    private float mTouchDownX;
    private int mScaledTouchSlop;
    @Nullable
    private SeekBarOnProgressChanged onProgressChanged;
    @Nullable
    private int[] sample;
    private int progress;
    private int waveBackgroundColor;
    private int waveProgressColor;
    private float waveGap;
    private float waveWidth;
    private float waveMinHeight;
    private float waveCornerRadius;
    @NotNull
    private WaveGravity waveGravity;
    private HashMap _$_findViewCache;

    /*
     * Unable to fully structure code
     */
    private final void init(AttributeSet attrs) {
        ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.WaveformSeekBar);
        this.setWaveWidth(ta.getDimension(R.styleable.WaveformSeekBar_wave_width, this.waveWidth));
        this.setWaveGap(ta.getDimension(R.styleable.WaveformSeekBar_wave_gap, this.waveGap));
        this.setWaveCornerRadius(ta.getDimension(R.styleable.WaveformSeekBar_wave_corner_radius, this.waveCornerRadius));
        this.setWaveMinHeight(ta.getDimension(R.styleable.WaveformSeekBar_wave_min_height, this.waveMinHeight));
        this.setWaveBackgroundColor(ta.getColor(R.styleable.WaveformSeekBar_wave_background_color, this.waveBackgroundColor));
        this.setWaveProgressColor(ta.getColor(R.styleable.WaveformSeekBar_wave_progress_color, this.waveProgressColor));
        this.setProgress(ta.getInteger(R.styleable.WaveformSeekBar_wave_progress, this.progress));
        v0 = gravity = ta.getString(R.styleable.WaveformSeekBar_wave_gravity);
        if (v0 == null) ** GOTO lbl-1000
        var4_4 = v0;
        tmp = -1;
        switch (var4_4.hashCode()) {
            case 49: {
                if (!var4_4.equals("1")) break;
                tmp = 1;
                break;
            }
            case 50: {
                if (!var4_4.equals("2")) break;
                tmp = 2;
                break;
            }
        }
        switch (tmp) {
            case 1: {
                v1 = WaveGravity.TOP;
                break;
            }
            case 2: {
                v1 = WaveGravity.CENTER;
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = WaveGravity.BOTTOM;
            }
        }
        this.setWaveGravity(v1);
        ta.recycle();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mCanvasWidth = w;
        this.mCanvasHeight = h;
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(@NotNull Canvas canvas) {
        block22: {
            block21: {
                int[] nArray;
                Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
                super.onDraw(canvas);
                if (this.sample == null) break block21;
                if (this.sample == null) {
                    Intrinsics.throwNpe();
                }
                if (!((nArray = this.sample).length == 0)) break block22;
            }
            throw (Throwable)new SampleDataException();
        }
        if (this.sample == null) {
            Intrinsics.throwNpe();
        }
        Integer n = ArraysKt.max((int[])this.sample);
        if (n == null) {
            Intrinsics.throwNpe();
        }
        this.mMaxValue = n;
        float f = (float)this.getAvailableWith() / (this.waveGap + this.waveWidth);
        if (this.sample == null) {
            Intrinsics.throwNpe();
        }
        float step = f / (float)this.sample.length;
        float i = 0.0f;
        float lastWaveRight = this.getPaddingLeft();
        while (true) {
            float f2;
            float waveHeight;
            if (this.sample == null) {
                Intrinsics.throwNpe();
            }
            if (!(i < (float)this.sample.length)) break;
            float f3 = this.getAvailableHeight();
            if (this.sample == null) {
                Intrinsics.throwNpe();
            }
            if ((waveHeight = f3 * ((float)this.sample[(int)i] / (float)this.mMaxValue)) < this.waveMinHeight) {
                waveHeight = this.waveMinHeight;
            }
            switch (WaveformSeekBar$WhenMappings.$EnumSwitchMapping$0[this.waveGravity.ordinal()]) {
                case 1: {
                    f2 = this.getPaddingTop();
                    break;
                }
                case 2: {
                    f2 = (float)this.getPaddingTop() + (float)this.getAvailableHeight() / 2.0f - waveHeight / 2.0f;
                    break;
                }
                case 3: {
                    f2 = (float)(this.mCanvasHeight - this.getPaddingBottom()) - waveHeight;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            float top = f2;
            this.mWaveRect.set(lastWaveRight, top, lastWaveRight + this.waveWidth, top + waveHeight);
            if (this.mWaveRect.contains((float)(this.getAvailableWith() * this.progress) / 100.0f, this.mWaveRect.centerY())) {
                int bitHeight = (int)this.mWaveRect.height();
                if (bitHeight <= 0) {
                    bitHeight = (int)this.waveWidth;
                }
                Bitmap bitmap = Bitmap.createBitmap((int)this.getAvailableWith(), (int)bitHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mProgressCanvas.setBitmap(bitmap);
                float fillWidth = (float)(this.getAvailableWith() * this.progress) / 100.0f;
                this.mWavePaint.setColor(this.waveProgressColor);
                this.mProgressCanvas.drawRect(0.0f, 0.0f, fillWidth, this.mWaveRect.bottom, this.mWavePaint);
                this.mWavePaint.setColor(this.waveBackgroundColor);
                this.mProgressCanvas.drawRect(fillWidth, 0.0f, (float)this.getAvailableWith(), this.mWaveRect.bottom, this.mWavePaint);
                BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                this.mWavePaint.setShader((Shader)shader);
            } else if (this.mWaveRect.right <= (float)(this.getAvailableWith() * this.progress) / 100.0f) {
                this.mWavePaint.setColor(this.waveProgressColor);
                this.mWavePaint.setShader((Shader)null);
            } else {
                this.mWavePaint.setColor(this.waveBackgroundColor);
                this.mWavePaint.setShader((Shader)null);
            }
            canvas.drawRoundRect(this.mWaveRect, this.waveCornerRadius, this.waveCornerRadius, this.mWavePaint);
            lastWaveRight = this.mWaveRect.right + this.waveGap;
            if (lastWaveRight + this.waveWidth > (float)(this.getAvailableWith() + this.getPaddingLeft())) break;
            i += 1.0f / step;
        }
    }

    public boolean onTouchEvent(@Nullable MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        MotionEvent motionEvent = event;
        if (motionEvent == null) {
            Intrinsics.throwNpe();
        }
        switch (motionEvent.getAction()) {
            case 0: {
                if (this.isParentScrolling()) {
                    this.mTouchDownX = event.getX();
                    break;
                }
                this.updateProgress(event);
                break;
            }
            case 2: {
                this.updateProgress(event);
                break;
            }
            case 1: {
                float f = event.getX() - this.mTouchDownX;
                if (Math.abs(f) > (float)this.mScaledTouchSlop) {
                    this.updateProgress(event);
                }
                this.performClick();
            }
        }
        return true;
    }

    private final boolean isParentScrolling() {
        ViewParent viewParent = this.getParent();
        if (viewParent == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.View");
        }
        View parent = (View)viewParent;
        View root = this.getRootView();
        while (!parent.canScrollHorizontally(1)) {
            if (parent.canScrollHorizontally(-1)) {
                return true;
            }
            if (parent.canScrollVertically(1)) {
                return true;
            }
            if (parent.canScrollVertically(-1)) {
                return true;
            }
            if (Intrinsics.areEqual((Object)parent, (Object)root)) {
                return false;
            }
            ViewParent viewParent2 = parent.getParent();
            if (viewParent2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.View");
            }
            parent = (View)viewParent2;
        }
        return true;
    }

    private final void updateProgress(MotionEvent event) {
        float f = 100;
        MotionEvent motionEvent = event;
        if (motionEvent == null) {
            Intrinsics.throwNpe();
        }
        this.setProgress((int)(f * motionEvent.getX() / (float)this.getAvailableWith()));
        this.invalidate();
        if (this.onProgressChanged != null) {
            SeekBarOnProgressChanged seekBarOnProgressChanged = this.onProgressChanged;
            if (seekBarOnProgressChanged == null) {
                Intrinsics.throwNpe();
            }
            seekBarOnProgressChanged.onProgressChanged(this, this.progress, true);
        }
    }

    public boolean performClick() {
        super.performClick();
        return true;
    }

    private final int getAvailableWith() {
        return this.mCanvasWidth - this.getPaddingLeft() - this.getPaddingRight();
    }

    private final int getAvailableHeight() {
        return this.mCanvasHeight - this.getPaddingTop() - this.getPaddingBottom();
    }

    @Nullable
    public final SeekBarOnProgressChanged getOnProgressChanged() {
        return this.onProgressChanged;
    }

    public final void setOnProgressChanged(@Nullable SeekBarOnProgressChanged seekBarOnProgressChanged) {
        this.onProgressChanged = seekBarOnProgressChanged;
    }

    @Nullable
    public final int[] getSample() {
        return this.sample;
    }

    public final void setSample(@Nullable int[] value) {
        this.sample = value;
        this.invalidate();
    }

    public final int getProgress() {
        return this.progress;
    }

    public final void setProgress(int value) {
        this.progress = value;
        this.invalidate();
        if (this.onProgressChanged != null) {
            SeekBarOnProgressChanged seekBarOnProgressChanged = this.onProgressChanged;
            if (seekBarOnProgressChanged == null) {
                Intrinsics.throwNpe();
            }
            seekBarOnProgressChanged.onProgressChanged(this, this.progress, false);
        }
    }

    public final int getWaveBackgroundColor() {
        return this.waveBackgroundColor;
    }

    public final void setWaveBackgroundColor(int value) {
        this.waveBackgroundColor = value;
        this.invalidate();
    }

    public final int getWaveProgressColor() {
        return this.waveProgressColor;
    }

    public final void setWaveProgressColor(int value) {
        this.waveProgressColor = value;
        this.invalidate();
    }

    public final float getWaveGap() {
        return this.waveGap;
    }

    public final void setWaveGap(float value) {
        this.waveGap = value;
        this.invalidate();
    }

    public final float getWaveWidth() {
        return this.waveWidth;
    }

    public final void setWaveWidth(float value) {
        this.waveWidth = value;
        this.invalidate();
    }

    public final float getWaveMinHeight() {
        return this.waveMinHeight;
    }

    public final void setWaveMinHeight(float value) {
        this.waveMinHeight = value;
        this.invalidate();
    }

    public final float getWaveCornerRadius() {
        return this.waveCornerRadius;
    }

    public final void setWaveCornerRadius(float value) {
        this.waveCornerRadius = value;
        this.invalidate();
    }

    @NotNull
    public final WaveGravity getWaveGravity() {
        return this.waveGravity;
    }

    public final void setWaveGravity(@NotNull WaveGravity value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.waveGravity = value;
        this.invalidate();
    }

    public WaveformSeekBar(@Nullable Context context) {
        super(context);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
        Intrinsics.checkExpressionValueIsNotNull((Object)viewConfiguration, (String)"ViewConfiguration.get(context)");
        this.mScaledTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.waveBackgroundColor = -3355444;
        this.waveProgressColor = -1;
        this.waveGap = Utils.INSTANCE.dp(this.getContext(), 2);
        this.waveMinHeight = this.waveWidth = Utils.INSTANCE.dp(this.getContext(), 5);
        this.waveCornerRadius = Utils.INSTANCE.dp(this.getContext(), 2);
        this.waveGravity = WaveGravity.CENTER;
        this.init(null);
    }

    public WaveformSeekBar(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
        Intrinsics.checkExpressionValueIsNotNull((Object)viewConfiguration, (String)"ViewConfiguration.get(context)");
        this.mScaledTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.waveBackgroundColor = -3355444;
        this.waveProgressColor = -1;
        this.waveGap = Utils.INSTANCE.dp(this.getContext(), 2);
        this.waveMinHeight = this.waveWidth = Utils.INSTANCE.dp(this.getContext(), 5);
        this.waveCornerRadius = Utils.INSTANCE.dp(this.getContext(), 2);
        this.waveGravity = WaveGravity.CENTER;
        this.init(attrs);
    }

    public WaveformSeekBar(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
        Intrinsics.checkExpressionValueIsNotNull((Object)viewConfiguration, (String)"ViewConfiguration.get(context)");
        this.mScaledTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.waveBackgroundColor = -3355444;
        this.waveProgressColor = -1;
        this.waveGap = Utils.INSTANCE.dp(this.getContext(), 2);
        this.waveMinHeight = this.waveWidth = Utils.INSTANCE.dp(this.getContext(), 5);
        this.waveCornerRadius = Utils.INSTANCE.dp(this.getContext(), 2);
        this.waveGravity = WaveGravity.CENTER;
        this.init(attrs);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

