/*
 * Decompiled with CFR 0.152.
 */
package com.arindicatorview;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.arindicatorview.R;
import java.util.ArrayList;
import java.util.List;

public class IndicatorView
extends LinearLayout {
    protected int indicatorColor;
    protected int selectionColor;
    protected int numberOfIndicators;
    protected int indicatorSize;
    protected int indicatorAnimation;
    protected int indicatorShape;
    protected boolean shouldAnimateOnScrubbing;
    protected boolean isScrubbingEnabled;
    protected List<ImageView> indicators = new ArrayList<ImageView>();

    public IndicatorView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public IndicatorView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public IndicatorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyle) {
        TypedArray styledAttributes = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.ARIndicatorView, defStyle, 0);
        this.indicatorColor = styledAttributes.getColor(R.styleable.ARIndicatorView_indicator_color, -3355444);
        this.selectionColor = styledAttributes.getColor(R.styleable.ARIndicatorView_selected_color, -16777216);
        this.numberOfIndicators = styledAttributes.getInteger(R.styleable.ARIndicatorView_number_of_indicators, 0);
        this.indicatorSize = styledAttributes.getInteger(R.styleable.ARIndicatorView_indicator_size, 10);
        this.indicatorAnimation = styledAttributes.getResourceId(R.styleable.ARIndicatorView_indicator_animation, 0);
        this.indicatorShape = styledAttributes.getResourceId(R.styleable.ARIndicatorView_indicator_shape, R.drawable.circle);
        this.isScrubbingEnabled = styledAttributes.getBoolean(R.styleable.ARIndicatorView_indicator_scrubbing, false);
        this.shouldAnimateOnScrubbing = styledAttributes.getBoolean(R.styleable.ARIndicatorView_animate_indicator_scrubbing, false);
        styledAttributes.recycle();
        if (this.isInEditMode()) {
            for (int i = 0; i < this.numberOfIndicators; ++i) {
                this.drawCircle(i);
            }
        }
    }

    protected void drawCircle(int position) {
        ImageView imageView = new ImageView(this.getContext());
        imageView.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.circle));
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        if (this.indicatorShape == 0) {
            imageView.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.circle));
        } else {
            imageView.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)this.indicatorShape));
        }
        this.setupColors(imageView, position);
        layoutParams.setMargins(10, 10, 10, 10);
        layoutParams.width = this.indicatorSize;
        layoutParams.height = this.indicatorSize;
        this.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
        this.indicators.add(imageView);
    }

    private void setupColors(ImageView imageView, int position) {
        if (position == 0) {
            this.setActiveColorTo(imageView);
        } else {
            this.setUnActiveColorTo(imageView);
        }
    }

    protected void setActiveColorTo(ImageView imageView) {
        imageView.setColorFilter(this.selectionColor);
        imageView.requestLayout();
    }

    protected void setUnActiveColorTo(ImageView imageView) {
        imageView.setColorFilter(this.indicatorColor);
        imageView.invalidate();
    }

    public boolean isShouldAnimateOnScrubbing() {
        return this.shouldAnimateOnScrubbing;
    }

    public void setShouldAnimateOnScrubbing(boolean shouldAnimateOnScrubbing) {
        this.shouldAnimateOnScrubbing = shouldAnimateOnScrubbing;
    }

    public boolean isScrubbingEnabled() {
        return this.isScrubbingEnabled;
    }

    public void setScrubbingEnabled(boolean scrubbingEnabled) {
        this.isScrubbingEnabled = scrubbingEnabled;
    }
}

