/*
 * Decompiled with CFR 0.152.
 */
package com.arindicatorview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.arindicatorview.IndicatorView;

public class ARIndicatorView
extends IndicatorView {
    private RecyclerView recyclerView;
    private ViewPager viewPager;
    private int selectedPosition = 0;
    private boolean isScrubbing = false;

    public ARIndicatorView(Context context) {
        super(context);
    }

    public ARIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ARIndicatorView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void attachTo(RecyclerView recyclerView, boolean shouldPage) {
        this.recyclerView = recyclerView;
        this.addIndicators(recyclerView);
        if (shouldPage) {
            new PagerSnapHelper().attachToRecyclerView(recyclerView);
        }
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                int position;
                super.onScrolled(recyclerView, dx, dy);
                if (recyclerView.getScrollState() == 2 && recyclerView.getLayoutManager() instanceof LinearLayoutManager && (position = dx > 0 ? ((LinearLayoutManager)recyclerView.getLayoutManager()).findLastVisibleItemPosition() : ((LinearLayoutManager)recyclerView.getLayoutManager()).findFirstVisibleItemPosition()) <= ARIndicatorView.this.indicators.size() - 1 && ARIndicatorView.this.selectedPosition != position) {
                    ARIndicatorView.this.selectIndicatorAt(position);
                    if (ARIndicatorView.this.indicatorAnimation != 0) {
                        ARIndicatorView.this.animateIndicator(position);
                    }
                }
            }
        });
    }

    public void attachTo(ViewPager viewPager) {
        this.viewPager = viewPager;
        this.addIndicators(viewPager);
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int i, float v, int i1) {
            }

            public void onPageSelected(int i) {
                ARIndicatorView.this.selectIndicatorAt(i);
                if (ARIndicatorView.this.indicatorAnimation != 0) {
                    ARIndicatorView.this.animateIndicator(i);
                }
            }

            public void onPageScrollStateChanged(int i) {
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addIndicators(RecyclerView recyclerView) {
        if (recyclerView == null) throw new NullPointerException("RecyclerView is null --> ARIndicatorView");
        RecyclerView.Adapter adapter = recyclerView.getAdapter();
        if (adapter == null) throw new NullPointerException("RecyclerView Adapter not found or null --> ARIndicatorView");
        for (int i = 0; i < adapter.getItemCount(); ++i) {
            this.drawCircle(i);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addIndicators(ViewPager viewPager) {
        if (viewPager == null) throw new NullPointerException("ViewPager is null --> ARIndicatorView");
        PagerAdapter pagerAdapter = viewPager.getAdapter();
        if (pagerAdapter == null) throw new NullPointerException("ViewPager Adapter is null --> ARIndicatorView");
        for (int i = 0; i < pagerAdapter.getCount(); ++i) {
            this.drawCircle(i);
        }
    }

    private void unSelectIndicators() {
        for (int i = 0; i < this.indicators.size(); ++i) {
            this.setUnActiveColorTo((ImageView)this.indicators.get(i));
        }
    }

    private void invalidateIndicators() {
        this.removeIndicators();
        if (this.recyclerView != null) {
            this.addIndicators(this.recyclerView);
        } else if (this.viewPager != null) {
            this.addIndicators(this.viewPager);
        }
        this.selectIndicatorAt(this.selectedPosition);
    }

    private void selectIndicatorAt(int position) {
        this.selectedPosition = position;
        this.unSelectIndicators();
        this.setActiveColorTo((ImageView)this.indicators.get(this.selectedPosition));
    }

    public void setSelectionColor(int selectionColor) {
        this.selectionColor = selectionColor;
        this.invalidateIndicators();
    }

    public int getSelectionColor() {
        return this.selectionColor;
    }

    public void setIndicatorSize(int indicatorSize) {
        this.indicatorSize = indicatorSize;
        this.invalidateIndicators();
    }

    public int getIndicatorSize() {
        return this.indicatorSize;
    }

    public void setIndicatorAnimation(int indicatorAnimation) {
        this.indicatorAnimation = indicatorAnimation;
    }

    public int getIndicatorAnimation() {
        return this.indicatorAnimation;
    }

    public void setIndicatorShape(int indicatorShape) {
        this.indicatorShape = indicatorShape;
        this.invalidateIndicators();
    }

    public int getIndicatorShape() {
        return this.indicatorShape;
    }

    public void setIndicatorColor(int indicatorColor) {
        this.indicatorColor = indicatorColor;
        this.invalidateIndicators();
    }

    public int getIndicatorColor() {
        return this.indicatorColor;
    }

    public void setSelectedPosition(int position) {
        this.selectedPosition = position;
        this.unSelectIndicators();
        this.setActiveColorTo((ImageView)this.indicators.get(this.selectedPosition));
        this.scrollToPosition(this.selectedPosition);
    }

    public int getSelectedPosition() {
        return this.selectedPosition;
    }

    public int getNumberOfIndicators() {
        return this.numberOfIndicators;
    }

    public void setNumberOfIndicators(int numberOfIndicators) {
        this.numberOfIndicators = numberOfIndicators;
        if (!this.indicators.isEmpty()) {
            this.removeIndicators();
        }
        for (int i = 0; i < this.numberOfIndicators; ++i) {
            this.drawCircle(i);
        }
    }

    public void removeIndicators() {
        for (ImageView imageView : this.indicators) {
            this.removeView((View)imageView);
        }
        this.indicators.clear();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            return this.isScrubbingEnabled;
        }
        this.selectIndicatorWhenScrubbing(ev);
        return this.isScrubbingEnabled;
    }

    private void selectIndicatorWhenScrubbing(MotionEvent ev) {
        int x = Math.round(ev.getX());
        int y = Math.round(ev.getY());
        for (int i = 0; i < this.getChildCount(); ++i) {
            ImageView child = (ImageView)this.getChildAt(i);
            if (x <= child.getLeft() || x >= child.getRight() || y <= child.getTop() || y >= child.getBottom()) continue;
            this.isScrubbing = true;
            this.selectIndicatorAt(i);
            this.scrollToPosition(i);
        }
    }

    private void scrollToPosition(int position) {
        if (this.recyclerView != null) {
            this.selectedPosition = position;
            this.recyclerView.smoothScrollToPosition(position);
        } else if (this.viewPager != null) {
            this.selectedPosition = position;
            this.viewPager.setCurrentItem(position, true);
        }
    }

    private void animateIndicator(int position) {
        if (this.isScrubbingEnabled && this.isScrubbing) {
            if (this.shouldAnimateOnScrubbing) {
                ((ImageView)this.indicators.get(position)).startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)this.indicatorAnimation));
            }
        } else {
            ((ImageView)this.indicators.get(position)).startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)this.indicatorAnimation));
        }
    }
}

