/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import com.google.auto.service.AutoService;
import java.util.Optional;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.PlaintextKeys;
import pro.javacard.gp.i.CardKeysProvider;

@AutoService(value={CardKeysProvider.class})
public class PlaintextKeysProvider
implements CardKeysProvider {
    public Optional<GPCardKeys> getCardKeys(String spec) {
        if (spec == null) {
            return Optional.empty();
        }
        if ("default".startsWith(spec.toLowerCase())) {
            return Optional.of(PlaintextKeys.defaultKey());
        }
        try {
            for (PlaintextKeys.Diversification d : PlaintextKeys.Diversification.values()) {
                if (!spec.toLowerCase().startsWith(d.name().toLowerCase())) continue;
                byte[] k = HexUtils.stringToBin((String)spec.substring(d.name().length() + 1));
                return Optional.of(PlaintextKeys.derivedFromMasterKey((byte[])k, null, (PlaintextKeys.Diversification)d));
            }
            byte[] k = HexUtils.stringToBin((String)spec);
            return Optional.of(PlaintextKeys.fromMasterKey((byte[])k));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }
}

