/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvBuilder;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import pro.javacard.AID;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GlobalPlatform;
import pro.javacard.gp.SEAccessControl;

public final class SEAccessControlUtility {
    private static ResponseAPDU sendAcrGetData(Card card, byte P1) throws CardException, GPException {
        CommandAPDU list = new CommandAPDU(-128, -54, 255, (int)P1, 256);
        ResponseAPDU response = card.getBasicChannel().transmit(list);
        try {
            GPException.check(response, "ACR GET DATA failed", new int[0]);
        }
        catch (GPException e) {
            if (SEAccessControl.ACR_GET_DATA_ERROR.containsKey(e.sw)) {
                System.out.println("[SW] " + SEAccessControl.ACR_GET_DATA_ERROR.get(e.sw));
            }
            throw e;
        }
        return response;
    }

    public static void acrList(GlobalPlatform gp, Card card) throws CardException, GPException {
        try {
            gp.select(SEAccessControl.ACR_AID);
            ResponseAPDU response = SEAccessControlUtility.sendAcrGetData(card, (byte)64);
            SEAccessControl.BerTlvData temp = SEAccessControl.AcrListResponse.getAcrListData(null, response.getData());
            while (temp.getCurrentIndex() < temp.getLength()) {
                response = SEAccessControlUtility.sendAcrGetData(card, (byte)96);
                temp = SEAccessControl.AcrListResponse.getAcrListData(temp, response.getData());
            }
            SEAccessControl.AcrListResponse resp = SEAccessControl.AcrListResponse.fromBytes(temp.getLength(), temp.getData());
            SEAccessControl.printList(resp.acrList);
        }
        catch (GPException e) {
            throw new GPException("Could not read " + SEAccessControl.ACR_AID);
        }
    }

    public static void acrAdd(GlobalPlatform gp, AID aid, byte[] hash, byte[] rules) throws CardException, GPException {
        SEAccessControl.RefArDo refArDo = new SEAccessControl.RefArDo(aid, hash, rules);
        SEAccessControl.StoreArDo storeArDo = new SEAccessControl.StoreArDo(refArDo);
        SEAccessControlUtility.acrStore(gp, storeArDo.toTlv());
    }

    public static void acrStore(GlobalPlatform gp, BerTlv data) throws CardException, GPException {
        try {
            gp.personalize(SEAccessControl.ACR_AID, new BerTlvBuilder().addBerTlv(data).buildArray(), -112);
        }
        catch (GPException e) {
            if (SEAccessControl.ACR_STORE_DATA_ERROR.containsKey(e.sw)) {
                System.out.println("[SW] " + SEAccessControl.ACR_STORE_DATA_ERROR.get(e.sw));
            }
            System.out.println(e.getMessage());
        }
    }

    public static void acrDelete(GlobalPlatform gp, AID aid, byte[] hash) throws CardException, GPException {
        BerTlv request;
        if (hash != null) {
            SEAccessControl.RefArDo refArDo = new SEAccessControl.RefArDo(aid, hash, null);
            request = new SEAccessControl.DeleteArDo(refArDo).toTlv();
        } else {
            SEAccessControl.AidRefDo aidRefDo = new SEAccessControl.AidRefDo(aid.getBytes());
            request = new SEAccessControl.DeleteAidDo(aidRefDo).toTlv();
        }
        SEAccessControlUtility.acrStore(gp, request);
    }
}

