/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import com.payneteasy.tlv.BerTag;
import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvBuilder;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.util.Arrays;
import pro.javacard.AID;
import pro.javacard.gp.GPDataException;

public class SEAccessControl {
    public static final AID ACR_AID = new AID("A00000015141434C00");
    public static final byte ACR_GET_DATA_ALL = 64;
    public static final byte ACR_GET_DATA_NEXT = 96;
    public static final Map<Integer, String> ACR_STORE_DATA_ERROR;
    public static final Map<Integer, String> ACR_GET_DATA_ERROR;
    private static final byte[] ACR_GET_DATA_RESP;
    private static final byte REF_AR_DO = -30;
    private static final byte REF_DO = -31;
    private static final byte AID_REF_DO = 79;
    private static final byte HASH_REF_DO = -63;
    private static final byte AR_DO = -29;
    private static final byte APDU_AR_DO = -48;
    private static final byte NFC_AR_DO = -47;
    private static final byte GOOGLE_PKG_DO = -54;
    private static final byte STORE_AR_DO = -16;
    private static final byte DELETE_AR_DO = -15;

    private static BerTlv buildArDoData(ApduArDo apduArDo, NfcArDo nfcArDo) {
        if (apduArDo != null && nfcArDo == null) {
            return apduArDo.toTlv();
        }
        if (apduArDo == null && nfcArDo != null) {
            return nfcArDo.toTlv();
        }
        if (apduArDo != null && nfcArDo != null) {
            return new BerTlvBuilder().addBerTlv(apduArDo.toTlv()).addBerTlv(nfcArDo.toTlv()).buildTlv();
        }
        return null;
    }

    private static byte[] buildApduArDoData(EventAccessRules rule, byte[] filter) {
        if (rule == EventAccessRules.CUSTOM) {
            return filter;
        }
        if (rule == EventAccessRules.NONE) {
            return new byte[0];
        }
        return new byte[]{rule.getValue()};
    }

    public static RefArDo parseRefArDo(BerTlv refArDo) throws GPDataException {
        RefDo refDo = SEAccessControl.parseRefDo(refArDo.find(new BerTag(-31)));
        ArDo arDo = SEAccessControl.parseArDo(refArDo.find(new BerTag(-29)));
        return new RefArDo(refDo, arDo);
    }

    public static RefDo parseRefDo(BerTlv refDo) throws GPDataException {
        AidRefDo aidRefDo = SEAccessControl.parseAidRefDo(refDo.find(new BerTag(79)));
        HashRefDo hashRefDo = SEAccessControl.parseHashRefDo(refDo.find(new BerTag(-63)));
        return new RefDo(aidRefDo, hashRefDo);
    }

    public static AidRefDo parseAidRefDo(BerTlv aidRefDo) throws GPDataException {
        return new AidRefDo(aidRefDo != null ? aidRefDo.getBytesValue() : new byte[]{});
    }

    public static HashRefDo parseHashRefDo(BerTlv hashRefDo) throws GPDataException {
        return new HashRefDo(hashRefDo != null ? hashRefDo.getBytesValue() : new byte[]{});
    }

    public static ArDo parseArDo(BerTlv arDo) throws GPDataException {
        if (arDo != null) {
            ApduArDo apduArDo = SEAccessControl.parseApduArDo(arDo.find(new BerTag(-48)));
            NfcArDo nfcArDo = SEAccessControl.parseNfcArDo(arDo.find(new BerTag(-47)));
            return new ArDo(apduArDo, nfcArDo);
        }
        return null;
    }

    public static ApduArDo parseApduArDo(BerTlv apduArDo) throws GPDataException {
        if (apduArDo != null) {
            byte[] data = apduArDo.getBytesValue();
            if (data.length == 1) {
                switch (data[0] & 0xFF) {
                    case 1: {
                        return new ApduArDo(EventAccessRules.ALWAYS, new byte[0]);
                    }
                    case 0: {
                        return new ApduArDo(EventAccessRules.NEVER, new byte[0]);
                    }
                }
            } else {
                return new ApduArDo(EventAccessRules.CUSTOM, data);
            }
        }
        return null;
    }

    public static NfcArDo parseNfcArDo(BerTlv nfcArDo) throws GPDataException {
        if (nfcArDo != null) {
            switch (nfcArDo.getBytesValue()[0]) {
                case 1: {
                    return new NfcArDo(EventAccessRules.ALWAYS);
                }
                case 0: {
                    return new NfcArDo(EventAccessRules.NEVER);
                }
            }
        }
        return null;
    }

    public static void printList(List<RefArDo> acrList) {
        if (acrList.size() == 0) {
            System.out.println("No Rule found");
            return;
        }
        for (int i = 0; i < acrList.size(); ++i) {
            RefArDo r = acrList.get(i);
            System.out.println("RULE #" + i + " :");
            if (r.refDo.aidRefDo.aid.length != 0) {
                System.out.println("       AID  : " + r.refDo.aidRefDo);
            }
            System.out.println("       HASH : " + r.refDo.hashRefDo);
            if (r.arDo == null) continue;
            if (r.arDo.apduArDo != null) {
                System.out.println("       APDU rule   : " + (Object)((Object)r.arDo.apduArDo.rule) + "(" + String.format("0x%02X", r.arDo.apduArDo.rule.getValue()) + ")");
                System.out.println("       APDU filter : " + HexUtils.bin2hex((byte[])r.arDo.apduArDo.filter));
            }
            if (r.arDo.nfcArDo == null) continue;
            System.out.println("       NFC  rule   : " + (Object)((Object)r.arDo.nfcArDo.rule) + "(" + String.format("0x%02X", r.arDo.nfcArDo.rule.getValue()) + ")");
        }
    }

    static {
        ACR_GET_DATA_RESP = new byte[]{-1, 64};
        HashMap<Integer, String> tmp = new HashMap<Integer, String>();
        tmp.put(25473, "Rule successfully stored but an access rule already exists for this target");
        tmp.put(25985, "Memory problem");
        tmp.put(26368, "Wrong length in Lc");
        tmp.put(27010, "Security status not satisfied");
        tmp.put(27013, "Conditions not satisfied");
        tmp.put(27264, "Incorrect values in the command data");
        tmp.put(27268, "Not enough memory space");
        tmp.put(27270, "Incorrect P1 P2");
        tmp.put(27272, "Referenced data not found");
        tmp.put(27273, "Conflicting access rule already exists in the Secure Element");
        tmp.put(27904, "Invalid instruction");
        tmp.put(28160, "Invalid class");
        ACR_STORE_DATA_ERROR = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put(25985, "Memory problem");
        tmp.put(26368, "Wrong length in Lc");
        tmp.put(27013, "Conditions not satisfied");
        tmp.put(27264, "Incorrect values in the command data");
        tmp.put(27270, "Incorrect P1 P2");
        tmp.put(27272, "Referenced data not found");
        tmp.put(27904, "Invalid instruction");
        tmp.put(28160, "Invalid class");
        ACR_GET_DATA_ERROR = Collections.unmodifiableMap(tmp);
    }

    public static class AcrListResponse {
        public final List<RefArDo> acrList;

        public AcrListResponse(List<RefArDo> acrList) {
            this.acrList = acrList;
        }

        public static BerTlvData getAcrListData(BerTlvData previousData, byte[] data) throws GPDataException {
            if (previousData == null && data.length > 2 && data[0] == ACR_GET_DATA_RESP[0] && data[1] == ACR_GET_DATA_RESP[1]) {
                int first = data[2] & 0xFF;
                int length = 0;
                int offset = 3;
                if (first < 128) {
                    length = first & 0xFF;
                } else {
                    switch (first) {
                        case 129: {
                            length = data[3] & 0xFF;
                            ++offset;
                            break;
                        }
                        case 130: {
                            length = (data[3] & 0xFF) << 8 | data[4] & 0xFF;
                            offset += 2;
                            break;
                        }
                        case 131: {
                            length = (data[3] & 0xFF) << 16 | (data[4] & 0xFF) << 8 | data[5] & 0xFF;
                            offset += 3;
                            break;
                        }
                        default: {
                            throw new GPDataException("ACR get data : bad BER TLV response format (GET_DATA)");
                        }
                    }
                }
                byte[] berData = new byte[length];
                System.arraycopy(data, offset, berData, 0, data.length - offset);
                return new BerTlvData(berData, length, data.length - offset);
            }
            if (previousData != null) {
                System.arraycopy(data, 0, previousData.getData(), previousData.currentIndex, data.length);
                previousData.setCurrentIndex(data.length + previousData.currentIndex);
                return previousData;
            }
            throw new GPDataException("ACR get data : bad response format (GET_DATA)");
        }

        public static AcrListResponse fromBytes(int length, byte[] data) throws GPDataException {
            BerTlvParser parser = new BerTlvParser();
            ArrayList<RefArDo> acrList = new ArrayList<RefArDo>();
            for (int offset = 0; length > offset; offset += (data[1 + offset] & 0xFF) + 2) {
                BerTlvs tlvs = parser.parse(Arrays.copyOfRange((byte[])data, (int)offset, (int)data.length));
                BerTlv refArDoTag = tlvs.find(new BerTag(-30));
                acrList.add(SEAccessControl.parseRefArDo(refArDoTag));
            }
            return new AcrListResponse(acrList);
        }
    }

    public static class BerTlvData {
        private final byte[] data;
        private final int length;
        private int currentIndex;

        public BerTlvData(byte[] data, int length, int index) {
            this.data = Arrays.copyOf((byte[])data, (int)data.length);
            this.length = length;
            this.currentIndex = index;
        }

        public byte[] getData() {
            return Arrays.copyOf((byte[])this.data, (int)this.data.length);
        }

        public int getLength() {
            return this.length;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public void setCurrentIndex(int index) {
            this.currentIndex = index;
        }
    }

    public static class NfcArDo
    implements ITLV {
        final EventAccessRules rule;

        public NfcArDo(EventAccessRules rule) {
            this.rule = rule;
        }

        @Override
        public BerTlv toTlv() {
            return new BerTlvBuilder().addBytes(new BerTag(-47), new byte[]{this.rule.getValue()}).buildTlv();
        }

        public String toString() {
            return "rule : " + (Object)((Object)this.rule);
        }
    }

    public static class ApduArDo
    implements ITLV {
        final EventAccessRules rule;
        final byte[] filter;

        public ApduArDo(EventAccessRules rule, byte[] filter) {
            this.rule = rule;
            this.filter = Arrays.copyOf((byte[])filter, (int)filter.length);
        }

        public ApduArDo(byte[] data) {
            if (data != null && data.length == 1) {
                switch (data[0]) {
                    case 0: {
                        this.rule = EventAccessRules.NEVER;
                        break;
                    }
                    case 1: {
                        this.rule = EventAccessRules.ALWAYS;
                        break;
                    }
                    default: {
                        this.rule = EventAccessRules.CUSTOM;
                    }
                }
                this.filter = new byte[data.length];
            } else if (data != null) {
                this.rule = EventAccessRules.CUSTOM;
                this.filter = new byte[data.length];
            } else {
                this.rule = EventAccessRules.NONE;
                this.filter = new byte[0];
            }
        }

        @Override
        public BerTlv toTlv() {
            return new BerTlvBuilder().addBytes(new BerTag(-48), SEAccessControl.buildApduArDoData(this.rule, this.filter)).buildTlv();
        }

        public String toString() {
            return "rule : " + (Object)((Object)this.rule) + " | filter : " + HexUtils.bin2hex((byte[])this.filter);
        }
    }

    public static class ArDo
    implements ITLV {
        final ApduArDo apduArDo;
        final NfcArDo nfcArDo;

        public ArDo(ApduArDo apduArDo, NfcArDo nfcArDo) {
            this.apduArDo = apduArDo;
            this.nfcArDo = nfcArDo;
        }

        public String toString() {
            return "apdu : " + this.apduArDo + " | nfc : " + this.nfcArDo;
        }

        @Override
        public BerTlv toTlv() {
            return new BerTlvBuilder(new BerTag(-29)).addBerTlv(SEAccessControl.buildArDoData(this.apduArDo, this.nfcArDo)).buildTlv();
        }
    }

    public static class PkgRefDo
    implements ITLV {
        final String pkg;

        public PkgRefDo(byte[] data) {
            this.pkg = new String(data, StandardCharsets.US_ASCII);
        }

        public String toString() {
            return this.pkg;
        }

        @Override
        public BerTlv toTlv() {
            return new BerTlvBuilder().addBytes(new BerTag(-54), this.pkg.getBytes(StandardCharsets.US_ASCII)).buildTlv();
        }
    }

    public static class HashRefDo
    implements ITLV {
        final byte[] hash;

        public HashRefDo(byte[] data) {
            this.hash = Arrays.copyOf((byte[])data, (int)data.length);
        }

        public String toString() {
            return HexUtils.bin2hex((byte[])this.hash);
        }

        @Override
        public BerTlv toTlv() {
            return new BerTlvBuilder().addBytes(new BerTag(-63), this.hash).buildTlv();
        }
    }

    public static class AidRefDo
    implements ITLV {
        final byte[] aid;

        public AidRefDo(byte[] data) {
            this.aid = Arrays.copyOf((byte[])data, (int)data.length);
        }

        public String toString() {
            return HexUtils.bin2hex((byte[])this.aid);
        }

        @Override
        public BerTlv toTlv() {
            return new BerTlvBuilder().addBytes(new BerTag(79), this.aid).buildTlv();
        }
    }

    public static class RefDo
    implements ITLV {
        final AidRefDo aidRefDo;
        final HashRefDo hashRefDo;

        public RefDo(AidRefDo aidRefDo, HashRefDo hashRefDo) {
            this.aidRefDo = aidRefDo;
            this.hashRefDo = hashRefDo;
        }

        public String toString() {
            return this.aidRefDo + " | " + this.hashRefDo;
        }

        @Override
        public BerTlv toTlv() {
            BerTlvBuilder aggregate = new BerTlvBuilder().addBerTlv(this.aidRefDo.toTlv()).addBerTlv(this.hashRefDo.toTlv());
            return new BerTlvBuilder(new BerTag(-31)).add(aggregate).buildTlv();
        }
    }

    public static class RefArDo
    implements ITLV {
        final RefDo refDo;
        final ArDo arDo;

        public RefArDo(RefDo refDo, ArDo arDo) {
            this.refDo = refDo;
            this.arDo = arDo;
        }

        public RefArDo(AID aid, byte[] hash) {
            this.refDo = new RefDo(new AidRefDo(aid.getBytes()), new HashRefDo(hash));
            this.arDo = new ArDo(new ApduArDo(EventAccessRules.ALWAYS, new byte[0]), null);
        }

        public RefArDo(AID aid, byte[] hash, byte[] rules) {
            this.refDo = new RefDo(new AidRefDo(aid.getBytes()), new HashRefDo(hash));
            this.arDo = new ArDo(new ApduArDo(rules), null);
        }

        @Override
        public BerTlv toTlv() {
            BerTlvBuilder aggregate = new BerTlvBuilder().addBerTlv(this.refDo.toTlv()).addBerTlv(this.arDo.toTlv());
            return new BerTlvBuilder(new BerTag(-30)).add(aggregate).buildTlv();
        }

        public String toString() {
            return this.refDo + " | " + this.arDo;
        }
    }

    public static class StoreArDo
    implements ITLV {
        final RefArDo refArDo;

        public StoreArDo(RefArDo refArDo) {
            this.refArDo = refArDo;
        }

        @Override
        public BerTlv toTlv() {
            return new BerTlvBuilder(new BerTag(-16)).addBerTlv(this.refArDo.toTlv()).buildTlv();
        }
    }

    public static class DeleteArDo
    implements ITLV {
        final RefArDo refArDo;

        public DeleteArDo(RefArDo refArDo) {
            this.refArDo = refArDo;
        }

        @Override
        public BerTlv toTlv() {
            return new BerTlvBuilder(new BerTag(-15)).addBerTlv(this.refArDo.toTlv()).buildTlv();
        }
    }

    public static class DeleteAidDo
    implements ITLV {
        final AidRefDo aidRefDo;

        public DeleteAidDo(AidRefDo aidRefDo) {
            this.aidRefDo = aidRefDo;
        }

        @Override
        public BerTlv toTlv() {
            return new BerTlvBuilder(new BerTag(-15)).addBerTlv(this.aidRefDo.toTlv()).buildTlv();
        }
    }

    static interface ITLV {
        public BerTlv toTlv();
    }

    static enum EventAccessRules {
        NEVER(0),
        ALWAYS(1),
        CUSTOM(2),
        NONE(3);

        private byte value;

        private EventAccessRules(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

