/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.EnumSet;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKey;
import pro.javacard.gp.GPSessionKeyProvider;
import pro.javacard.gp.GlobalPlatform;
import pro.javacard.gp.SecureChannelWrapper;

class SCP03Wrapper
extends SecureChannelWrapper {
    byte[] chaining_value = new byte[16];
    byte[] encryption_counter = new byte[16];

    SCP03Wrapper(GPSessionKeyProvider sessionKeys, int scp, EnumSet<GlobalPlatform.APDUMode> securityLevel, byte[] icv, byte[] ricv, int bs) {
        this.sessionKeys = sessionKeys;
        this.blockSize = bs;
        System.arraycopy(GPCrypto.null_bytes_16, 0, this.chaining_value, 0, GPCrypto.null_bytes_16.length);
        System.arraycopy(GPCrypto.null_bytes_16, 0, this.encryption_counter, 0, GPCrypto.null_bytes_16.length);
        this.setSecurityLevel(securityLevel);
    }

    @Override
    protected CommandAPDU wrap(CommandAPDU command) throws GPException {
        byte[] cmd_mac = null;
        try {
            int cla = command.getCLA();
            int lc = command.getNc();
            byte[] data = command.getData();
            if (this.enc) {
                cla = 132;
                GPCrypto.buffer_increment(this.encryption_counter);
                if (command.getData().length > 0) {
                    byte[] d = GPCrypto.pad80(command.getData(), 16);
                    Cipher c = Cipher.getInstance("AES/CBC/NoPadding");
                    c.init(1, this.sessionKeys.getKeyFor(GPSessionKeyProvider.KeyPurpose.ENC).getKeyAs(GPKey.Type.AES), GPCrypto.iv_null_16);
                    byte[] iv = c.doFinal(this.encryption_counter);
                    c.init(1, this.sessionKeys.getKeyFor(GPSessionKeyProvider.KeyPurpose.ENC).getKeyAs(GPKey.Type.AES), new IvParameterSpec(iv));
                    data = c.doFinal(d);
                    lc = data.length;
                }
            }
            if (this.mac) {
                cla = 132;
                lc += 8;
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                bo.write(this.chaining_value);
                bo.write(cla);
                bo.write(command.getINS());
                bo.write(command.getP1());
                bo.write(command.getP2());
                bo.write(lc);
                bo.write(data);
                byte[] cmac_input = bo.toByteArray();
                byte[] cmac = GPCrypto.scp03_mac(this.sessionKeys.getKeyFor(GPSessionKeyProvider.KeyPurpose.MAC), cmac_input, 128);
                System.arraycopy(cmac, 0, this.chaining_value, 0, this.chaining_value.length);
                cmd_mac = Arrays.copyOf(cmac, 8);
            }
            ByteArrayOutputStream na = new ByteArrayOutputStream();
            na.write(cla);
            na.write(command.getINS());
            na.write(command.getP1());
            na.write(command.getP2());
            na.write(lc);
            na.write(data);
            if (this.mac) {
                na.write(cmd_mac);
            }
            if (command.getNe() > 0) {
                na.write(command.getNe());
            }
            byte[] new_apdu = na.toByteArray();
            return new CommandAPDU(new_apdu);
        }
        catch (IOException e) {
            throw new RuntimeException("APDU wrapping failed", e);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("APDU wrapping failed", e);
        }
        catch (GeneralSecurityException e) {
            throw new GPException("APDU wrapping failed", e);
        }
    }

    @Override
    protected ResponseAPDU unwrap(ResponseAPDU response) throws GPException {
        try {
            if (this.rmac) {
                if (response.getData().length < 8) {
                    throw new RuntimeException("Wrong response length (too short).");
                }
                int respLen = response.getData().length - 8;
                byte[] actualMac = new byte[8];
                System.arraycopy(response.getData(), respLen, actualMac, 0, 8);
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                bo.write(this.chaining_value);
                bo.write(response.getData(), 0, respLen);
                bo.write(response.getSW1());
                bo.write(response.getSW2());
                byte[] cmac_input = bo.toByteArray();
                byte[] cmac = GPCrypto.scp03_mac(this.sessionKeys.getKeyFor(GPSessionKeyProvider.KeyPurpose.RMAC), cmac_input, 128);
                byte[] resp_mac = Arrays.copyOf(cmac, 8);
                if (!Arrays.equals(resp_mac, actualMac)) {
                    throw new GPException("RMAC invalid: " + HexUtils.bin2hex((byte[])actualMac) + " vs " + HexUtils.bin2hex((byte[])resp_mac));
                }
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                o.write(response.getBytes(), 0, respLen);
                o.write(response.getSW1());
                o.write(response.getSW2());
                response = new ResponseAPDU(o.toByteArray());
            }
            if (this.renc) {
                byte[] response_encryption_counter = Arrays.copyOf(this.encryption_counter, this.encryption_counter.length);
                response_encryption_counter[0] = -128;
                Cipher c = Cipher.getInstance("AES/CBC/NoPadding");
                c.init(1, this.sessionKeys.getKeyFor(GPSessionKeyProvider.KeyPurpose.ENC).getKeyAs(GPKey.Type.AES), GPCrypto.iv_null_16);
                byte[] iv = c.doFinal(response_encryption_counter);
                c.init(2, this.sessionKeys.getKeyFor(GPSessionKeyProvider.KeyPurpose.ENC).getKeyAs(GPKey.Type.AES), new IvParameterSpec(iv));
                byte[] data = c.doFinal(response.getData());
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                o.write(GPCrypto.unpad80(data));
                o.write(response.getSW1());
                o.write(response.getSW2());
                response = new ResponseAPDU(o.toByteArray());
            }
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException("APDU unwrapping failed", e);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("APDU unwrapping failed", e);
        }
        catch (GeneralSecurityException e) {
            throw new GPException("APDU unwrapping failed", e);
        }
    }
}

