/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.EnumSet;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKey;
import pro.javacard.gp.GPSessionKeyProvider;
import pro.javacard.gp.GlobalPlatform;
import pro.javacard.gp.SecureChannelWrapper;

class SCP0102Wrapper
extends SecureChannelWrapper {
    private final ByteArrayOutputStream rMac = new ByteArrayOutputStream();
    private byte[] icv = null;
    private byte[] ricv = null;
    private int scp = 0;
    private boolean icvEnc = false;
    private boolean preAPDU = false;
    private boolean postAPDU = false;

    SCP0102Wrapper(GPSessionKeyProvider sessionKeys, int scp, EnumSet<GlobalPlatform.APDUMode> securityLevel, byte[] icv, byte[] ricv, int bs) {
        this.blockSize = bs;
        this.sessionKeys = sessionKeys;
        this.icv = icv;
        this.ricv = ricv;
        this.setSCPVersion(scp);
        this.setSecurityLevel(securityLevel);
    }

    private static byte clearBits(byte b, byte mask) {
        return (byte)(b & ~mask & 0xFF);
    }

    private static byte setBits(byte b, byte mask) {
        return (byte)((b | mask) & 0xFF);
    }

    public void setSCPVersion(int scp) {
        this.scp = 2;
        if (scp < 3) {
            this.scp = 1;
        }
        this.icvEnc = scp == 2 || scp == 7 || scp == 8 || scp == 9 || scp == 10;
        this.preAPDU = scp == 1 || scp == 2 || scp == 3 || scp == 4 || scp == 7 || scp == 8;
        this.postAPDU = scp == 5 || scp == 6 || scp == 9 || scp == 10;
    }

    public byte[] getIV() {
        return this.icv;
    }

    public void setRMACIV(byte[] iv) {
        this.ricv = iv;
    }

    @Override
    public CommandAPDU wrap(CommandAPDU command) throws GPException {
        try {
            Cipher c;
            int origLc;
            int origCLA;
            if (this.rmac) {
                this.rMac.reset();
                this.rMac.write(SCP0102Wrapper.clearBits((byte)command.getCLA(), (byte)7));
                this.rMac.write(command.getINS());
                this.rMac.write(command.getP1());
                this.rMac.write(command.getP2());
                if (command.getNc() >= 0) {
                    this.rMac.write(command.getNc());
                    this.rMac.write(command.getData());
                }
            }
            if (!this.mac && !this.enc) {
                return command;
            }
            int newCLA = origCLA = command.getCLA();
            int origINS = command.getINS();
            int origP1 = command.getP1();
            int origP2 = command.getP2();
            byte[] origData = command.getData();
            int newLc = origLc = command.getNc();
            byte[] newData = null;
            int le = command.getNe();
            ByteArrayOutputStream t = new ByteArrayOutputStream();
            if (origLc > this.getBlockSize()) {
                throw new IllegalArgumentException("APDU too long for wrapping.");
            }
            if (this.mac) {
                if (this.icv == null) {
                    this.icv = new byte[8];
                } else if (this.icvEnc) {
                    c = null;
                    if (this.scp == 1) {
                        c = Cipher.getInstance("DESede/ECB/NoPadding");
                        c.init(1, this.sessionKeys.getKeyFor(GPSessionKeyProvider.KeyPurpose.MAC).getKeyAs(GPKey.Type.DES3));
                    } else {
                        c = Cipher.getInstance("DES/ECB/NoPadding");
                        c.init(1, this.sessionKeys.getKeyFor(GPSessionKeyProvider.KeyPurpose.MAC).getKeyAs(GPKey.Type.DES));
                    }
                    this.icv = c.doFinal(this.icv);
                }
                if (this.preAPDU) {
                    newCLA = SCP0102Wrapper.setBits((byte)newCLA, (byte)4);
                    newLc += 8;
                }
                t.write(newCLA);
                t.write(origINS);
                t.write(origP1);
                t.write(origP2);
                t.write(newLc);
                t.write(origData);
                if (this.scp == 1) {
                    this.icv = GPCrypto.mac_3des(this.sessionKeys.getKeyFor(GPSessionKeyProvider.KeyPurpose.MAC), t.toByteArray(), this.icv);
                } else if (this.scp == 2) {
                    this.icv = GPCrypto.mac_des_3des(this.sessionKeys.getKeyFor(GPSessionKeyProvider.KeyPurpose.MAC), t.toByteArray(), this.icv);
                }
                if (this.postAPDU) {
                    newCLA = SCP0102Wrapper.setBits((byte)newCLA, (byte)4);
                    newLc += 8;
                }
                t.reset();
                newData = origData;
            }
            if (this.enc && origLc > 0) {
                if (this.scp == 1) {
                    t.write(origLc);
                    t.write(origData);
                    if (t.size() % 8 != 0) {
                        byte[] x = GPCrypto.pad80(t.toByteArray(), 8);
                        t.reset();
                        t.write(x);
                    }
                } else {
                    t.write(GPCrypto.pad80(origData, 8));
                }
                newLc += t.size() - origData.length;
                c = Cipher.getInstance("DESede/CBC/NoPadding");
                c.init(1, this.sessionKeys.getKeyFor(GPSessionKeyProvider.KeyPurpose.ENC).getKeyAs(GPKey.Type.DES3), GPCrypto.iv_null_8);
                newData = c.doFinal(t.toByteArray());
                t.reset();
            }
            t.write(newCLA);
            t.write(origINS);
            t.write(origP1);
            t.write(origP2);
            if (newLc > 0) {
                t.write(newLc);
                t.write(newData);
            }
            if (this.mac) {
                t.write(this.icv);
            }
            if (le > 0) {
                t.write(le);
            }
            CommandAPDU wrapped = new CommandAPDU(t.toByteArray());
            return wrapped;
        }
        catch (IOException e) {
            throw new RuntimeException("APDU wrapping failed", e);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("APDU wrapping failed", e);
        }
        catch (GeneralSecurityException e) {
            throw new GPException("APDU wrapping failed", e);
        }
    }

    @Override
    public ResponseAPDU unwrap(ResponseAPDU response) throws GPException {
        if (this.rmac) {
            if (response.getData().length < 8) {
                throw new RuntimeException("Wrong response length (too short).");
            }
            int respLen = response.getData().length - 8;
            this.rMac.write(respLen);
            this.rMac.write(response.getData(), 0, respLen);
            this.rMac.write(response.getSW1());
            this.rMac.write(response.getSW2());
            this.ricv = GPCrypto.mac_des_3des(this.sessionKeys.getKeyFor(GPSessionKeyProvider.KeyPurpose.RMAC), GPCrypto.pad80(this.rMac.toByteArray(), 8), this.ricv);
            byte[] actualMac = new byte[8];
            System.arraycopy(response.getData(), respLen, actualMac, 0, 8);
            if (!Arrays.equals(this.ricv, actualMac)) {
                throw new GPException("RMAC invalid.");
            }
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            o.write(response.getBytes(), 0, respLen);
            o.write(response.getSW1());
            o.write(response.getSW2());
            response = new ResponseAPDU(o.toByteArray());
        }
        return response;
    }
}

