/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import pro.javacard.gp.GPData;
import pro.javacard.gp.GPDataException;
import pro.javacard.gp.GPKey;
import pro.javacard.gp.GlobalPlatform;
import pro.javacard.gp.PlaintextKeys;

public class PythiaKeys {
    public static final String PYTHIA_URL = "https://javacard.pro/pythia";
    public static final OracleHint DEFAULT = PythiaKeys.makeDefault();

    private static PlaintextKeys fromHint(OracleHint hint) throws GPDataException {
        try {
            PlaintextKeys r;
            if (hint.key != null && hint.algo != null) {
                r = PlaintextKeys.fromMasterKey(new GPKey(HexUtils.hex2bin((String)hint.key), GPKey.Type.valueOf(hint.algo)));
            } else if (hint.mac != null && hint.enc != null && hint.kek != null && hint.algo != null) {
                GPKey enc = new GPKey(HexUtils.hex2bin((String)hint.enc), GPKey.Type.valueOf(hint.algo));
                GPKey mac = new GPKey(HexUtils.hex2bin((String)hint.mac), GPKey.Type.valueOf(hint.algo));
                GPKey dek = new GPKey(HexUtils.hex2bin((String)hint.kek), GPKey.Type.valueOf(hint.algo));
                r = PlaintextKeys.fromKeys(enc, mac, dek);
            } else {
                throw new GPDataException("Oracle does not know the keys :(");
            }
            if (hint.div != null) {
                r.setDiversifier(PlaintextKeys.Diversification.valueOf(hint.div));
            }
            System.out.println("Using aid=" + hint.aid + " div=" + hint.div + " algo=" + hint.algo + " key=" + hint.key);
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GPDataException("Failed: " + e.getMessage());
        }
    }

    public static PlaintextKeys ask(byte[] atr, byte[] cplc, byte[] kinfo) throws GPDataException {
        try {
            OracleHint[] hints;
            String urlstring = PYTHIA_URL;
            urlstring = urlstring + "?atr=" + HexUtils.bin2hex((byte[])atr);
            if (cplc != null && cplc.length > 0) {
                urlstring = urlstring + "&cplc=" + HexUtils.bin2hex((byte[])cplc);
            }
            if (kinfo != null && kinfo.length > 0) {
                urlstring = urlstring + "&keys=" + HexUtils.bin2hex((byte[])kinfo);
            }
            URL url = new URL(urlstring);
            SSLContext ssl = SSLContext.getInstance("TLSv1.2");
            ssl.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    throw new CertificateException("No client authentication required");
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    if (x509Certificates.length < 1) {
                        throw new CertificateException("No certificate");
                    }
                    try (InputStream cert = PythiaKeys.class.getResourceAsStream("javacard.pro.pem");){
                        if (cert == null) {
                            throw new CertificateException("No certificate bundled");
                        }
                        CertificateFactory cf = CertificateFactory.getInstance("X509");
                        X509Certificate c = (X509Certificate)cf.generateCertificate(cert);
                        if (x509Certificates[0].equals(c)) {
                            return;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new CertificateException("javacard.pro certificate not in server chain");
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    try (InputStream cert = PythiaKeys.class.getResourceAsStream("letsencrypt.pem");){
                        if (cert == null) return new X509Certificate[0];
                        CertificateFactory cf = CertificateFactory.getInstance("X509");
                        X509Certificate c = (X509Certificate)cf.generateCertificate(cert);
                        X509Certificate[] x509CertificateArray = new X509Certificate[]{c};
                        return x509CertificateArray;
                    }
                    catch (IOException | CertificateException exception) {
                        // empty catch block
                    }
                    return new X509Certificate[0];
                }
            }}, null);
            SSLSocketFactory factory = ssl.getSocketFactory();
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setSSLSocketFactory(factory);
            con.setRequestProperty("User-Agent", "GlobalPlatformPro/" + GlobalPlatform.getVersion());
            try (InputStreamReader in = new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8);){
                hints = (OracleHint[])new Gson().fromJson((Reader)in, OracleHint[].class);
                if (hints == null) {
                    throw new GPDataException("Pythia is confused, there are no hints");
                }
            }
            catch (SSLHandshakeException e) {
                throw new GPDataException("Can not establish a connection to Pythia");
            }
            if (hints.length > 1) {
                Console c = System.console();
                if (c != null) {
                    int idx;
                    System.out.println("Pythia, the oracle, knows " + hints.length + " configurations for this card. Choose one");
                    int i = 0;
                    for (OracleHint h : hints) {
                        System.out.println(i + ": " + h.name);
                        ++i;
                    }
                    while (true) {
                        String res;
                        if ((res = c.readLine("Make choice (0.." + (i - 1) + " or ctrl-c): ", new Object[0])) == null) {
                            c.writer().println("Closing up");
                            System.exit(1);
                            continue;
                        }
                        idx = Integer.parseInt(res);
                        if (idx >= 0 && idx < i) break;
                        System.out.println("Wrong value, try again");
                    }
                    System.out.println("Chose " + hints[idx].name);
                    return PythiaKeys.fromHint(hints[idx]);
                }
                System.err.println("Console not available but Pythia knows more than one card");
                System.err.println("Returning first configuration");
                return PythiaKeys.fromHint(hints[0]);
            }
            if (hints.length == 1) {
                return PythiaKeys.fromHint(hints[1]);
            }
            return PythiaKeys.fromHint(DEFAULT);
        }
        catch (IOException | GeneralSecurityException e) {
            e.printStackTrace();
            throw new GPDataException("Pythia is broken :( Use your own Wisdom!");
        }
    }

    private static final OracleHint makeDefault() {
        OracleHint DEFAULT = new OracleHint();
        DEFAULT.aid = HexUtils.bin2hex((byte[])GPData.defaultISDBytes);
        DEFAULT.key = HexUtils.bin2hex((byte[])GPData.defaultKeyBytes);
        DEFAULT.algo = GPKey.Type.DES3.name();
        return DEFAULT;
    }

    static class OracleHint {
        @SerializedName(value="name")
        String name;
        @SerializedName(value="aid")
        String aid;
        @SerializedName(value="key")
        String key;
        @SerializedName(value="enc")
        String enc;
        @SerializedName(value="mac")
        String mac;
        @SerializedName(value="kek")
        String kek;
        @SerializedName(value="div")
        String div;
        @SerializedName(value="algo")
        String algo;
        @SerializedName(value="id")
        String id;
        @SerializedName(value="ver")
        String ver;

        OracleHint() {
        }
    }
}

