/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.APDUReplayProvider;
import apdu4j.HexUtils;
import apdu4j.LoggingCardTerminal;
import apdu4j.TerminalManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.TerminalFactory;
import joptsimple.OptionSet;
import pro.javacard.AID;
import pro.javacard.CAPFile;
import pro.javacard.gp.GPCommandLineInterface;
import pro.javacard.gp.GPCommands;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPData;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKey;
import pro.javacard.gp.GPRegistry;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPRegistryEntryApp;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.GlobalPlatform;
import pro.javacard.gp.PlaintextKeys;
import pro.javacard.gp.PythiaKeys;
import pro.javacard.gp.SEAccessControlUtility;

public final class GPTool
extends GPCommandLineInterface {
    private static boolean isVerbose = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] argv) throws Exception {
        OptionSet args = GPTool.parseArguments(argv);
        System.setProperty("org.slf4j.simpleLogger.showThreadName", "false");
        System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        System.setProperty("org.slf4j.simpleLogger.showShortLogName", "true");
        if (args.has("verbose")) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "debug");
            isVerbose = true;
        } else if (args.has("debug")) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "trace");
        } else {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "warn");
        }
        if (args.has("version") || args.has("verbose") || args.has("debug") || args.has("info")) {
            String version = GlobalPlatform.getVersion();
            version = version + "\nRunning on " + System.getProperty("os.name");
            version = version + " " + System.getProperty("os.version");
            version = version + " " + System.getProperty("os.arch");
            version = version + ", Java " + System.getProperty("java.version");
            version = version + " by " + System.getProperty("java.vendor");
            System.out.println("GlobalPlatformPro " + version);
            if (Cipher.getMaxAllowedKeyLength("AES") == 128) {
                System.out.println("Unlimited crypto policy is NOT installed!");
            }
        }
        CAPFile cap = null;
        if (args.has("cap")) {
            File capfile = (File)args.valueOf("cap");
            cap = CAPFile.fromStream((InputStream)new FileInputStream(capfile));
            if (args.has("info")) {
                System.out.println("**** CAP info of " + capfile.getName());
                cap.dump(System.out);
                if (args.specs().size() == 2) {
                    System.exit(0);
                }
            }
        }
        if (args.has("list-privs")) {
            System.out.println("# Known privileges:");
            System.out.println(Arrays.asList(GPRegistryEntry.Privilege.values()).stream().map(i -> i.toString()).collect(Collectors.joining("\n")));
        }
        try {
            List<Object> do_readers;
            TerminalFactory tf;
            if (args.has("replay")) {
                File f = (File)args.valueOf("replay");
                tf = TerminalFactory.getInstance("PC/SC", (Object)new FileInputStream(f), (Provider)new APDUReplayProvider());
            } else {
                tf = TerminalManager.getTerminalFactory((String)((String)args.valueOf("terminals")));
            }
            CardTerminals terminals = tf.terminals();
            if (args.has("debug")) {
                System.out.println("# Detected readers from " + tf.getProvider().getName());
                for (CardTerminal term : terminals.list()) {
                    void var7_8;
                    String string = " ";
                    if (term.isCardPresent()) {
                        String string2 = "*";
                        if (GPTool.ignoreReader(term.getName())) {
                            String string3 = "I";
                        }
                    }
                    System.out.println("[" + (String)var7_8 + "] " + term.getName());
                }
            }
            if (args.has("reader") || System.getenv().containsKey("GP_READER")) {
                CardTerminal cardTerminal;
                String reader = System.getenv("GP_READER");
                if (args.has("reader")) {
                    reader = (String)args.valueOf("reader");
                }
                if ((cardTerminal = terminals.getTerminal(reader)) == null) {
                    GPTool.fail("Reader \"" + reader + "\" not found.");
                }
                do_readers = Arrays.asList(cardTerminal);
            } else {
                List<CardTerminal> tmp = terminals.list(CardTerminals.State.CARD_PRESENT);
                do_readers = new ArrayList();
                for (CardTerminal t : tmp) {
                    if (!GPTool.ignoreReader(t.getName())) {
                        do_readers.add(t);
                        continue;
                    }
                    if (!args.has("verbose")) continue;
                    System.out.println("# Ignoring " + t.getName());
                }
            }
            if (do_readers.size() == 0) {
                GPTool.fail("No smart card readers with a card found");
            }
            for (CardTerminal cardTerminal : do_readers) {
                void var7_18;
                if (do_readers.size() > 1) {
                    System.out.println("# " + cardTerminal.getName());
                }
                if (args.has("debug")) {
                    FileOutputStream o = null;
                    if (args.has("dump")) {
                        File f = (File)args.valueOf("dump");
                        o = new FileOutputStream(f);
                    }
                    LoggingCardTerminal loggingCardTerminal = LoggingCardTerminal.getInstance((CardTerminal)cardTerminal, o);
                }
                Card card = null;
                CardChannel channel = null;
                try {
                    AID instanceAID;
                    AID appletAID;
                    CAPFile instcap;
                    File capfile;
                    PlaintextKeys keys;
                    try {
                        card = var7_18.connect("*");
                        card.beginExclusive();
                        channel = card.getBasicChannel();
                    }
                    catch (CardException e) {
                        System.err.println("Could not connect to " + var7_18.getName() + ": " + TerminalManager.getExceptionMessage((Exception)e));
                        if (card == null) continue;
                        card.endExclusive();
                        card.disconnect(true);
                        card = null;
                        continue;
                    }
                    if (args.has("info") || args.has("verbose")) {
                        System.out.println("Reader: " + var7_18.getName());
                        System.out.println("ATR: " + HexUtils.bin2hex((byte[])card.getATR().getBytes()));
                        System.out.println("More information about your card:");
                        System.out.println("    http://smartcard-atr.appspot.com/parse?ATR=" + HexUtils.bin2hex((byte[])card.getATR().getBytes()));
                        System.out.println();
                    }
                    if (args.has("apdu")) {
                        AID target = null;
                        if (args.has("applet")) {
                            target = AID.fromString((Object)args.valueOf("applet"));
                        } else if (cap != null) {
                            target = (AID)cap.getAppletAIDs().get(0);
                        }
                        if (target != null) {
                            GPTool.verbose("Selecting " + target);
                            channel.transmit(new CommandAPDU(0, 164, 4, 0, target.getBytes()));
                        }
                        for (Object s : args.valuesOf("apdu")) {
                            CommandAPDU c = new CommandAPDU(HexUtils.stringToBin((String)((String)s)));
                            channel.transmit(c);
                        }
                    }
                    GlobalPlatform gp = args.has("sdaid") ? GlobalPlatform.connect(channel, AID.fromString((Object)args.valueOf("sdaid"))) : GlobalPlatform.discover(channel);
                    if (args.has("info")) {
                        GPData.dump(channel);
                    }
                    if (args.has("keys")) {
                        GPTool.fail("Not yet implemented");
                        keys = PlaintextKeys.fromMasterKey(GPData.getDefaultKey());
                    } else if (args.has("oracle")) {
                        keys = PythiaKeys.ask(card.getATR().getBytes(), GPData.fetchCPLC(channel), GPData.fetchKeyInfoTemplate(channel));
                    } else {
                        PlaintextKeys keyz;
                        if (args.has("key")) {
                            GPKey k = new GPKey(HexUtils.stringToBin((String)((String)args.valueOf("key"))));
                            if (args.has("kcv")) {
                                byte[] given = HexUtils.stringToBin((String)((String)args.valueOf("kcv")));
                                byte[] expected = k.getKCV();
                                if (expected.length == 0) {
                                    GPTool.fail("Don't know how to calculate KCV for the key");
                                }
                                if (!Arrays.equals(given, expected)) {
                                    GPTool.fail("KCV does not match, expected " + HexUtils.bin2hex((byte[])expected) + " but given " + HexUtils.bin2hex((byte[])given));
                                }
                            }
                            keyz = PlaintextKeys.fromMasterKey(k);
                        } else {
                            Iterator env = System.getenv();
                            if (args.has("key-mac") && args.has("key-enc") && args.has("key-dek")) {
                                GPKey enc = new GPKey(HexUtils.stringToBin((String)((String)args.valueOf("key-enc"))));
                                GPKey mac = new GPKey(HexUtils.stringToBin((String)((String)args.valueOf("key-mac"))));
                                GPKey dek = new GPKey(HexUtils.stringToBin((String)((String)args.valueOf("key-dek"))));
                                keyz = PlaintextKeys.fromKeys(enc, mac, dek);
                            } else if (env.containsKey("GP_KEY_ENC") && env.containsKey("GP_KEY_MAC") && env.containsKey("GP_KEY_DEK")) {
                                GPKey enc = new GPKey(HexUtils.stringToBin((String)env.get("GP_KEY_ENC")));
                                GPKey mac = new GPKey(HexUtils.stringToBin((String)((String)env.get("GP_KEY_MAC"))));
                                GPKey dek = new GPKey(HexUtils.stringToBin((String)((String)env.get("GP_KEY_DEK"))));
                                keyz = PlaintextKeys.fromKeys(enc, mac, dek);
                                if (env.containsKey("GP_KEY_VERSION")) {
                                    keyz.setVersion(GPUtils.intValue((String)env.get("GP_KEY_VERSION")));
                                }
                            } else {
                                if (GPTool.needsAuthentication(args)) {
                                    System.out.println("Warning: no keys given, using default test key " + HexUtils.bin2hex((byte[])GPData.defaultKeyBytes));
                                }
                                keyz = PlaintextKeys.fromMasterKey(GPData.getDefaultKey());
                            }
                        }
                        if (args.has("visa2")) {
                            keyz.setDiversifier(PlaintextKeys.Diversification.VISA2);
                        } else if (args.has("emv")) {
                            keyz.setDiversifier(PlaintextKeys.Diversification.EMV);
                        } else if (args.has("kdf3")) {
                            keyz.setDiversifier(PlaintextKeys.Diversification.KDF3);
                        }
                        if (args.has("key-ver")) {
                            keyz.setVersion(GPUtils.intValue((String)args.valueOf("key-ver")));
                        }
                        keys = keyz;
                    }
                    if (args.has("op201")) {
                        gp.setSpec(GlobalPlatform.GPSpec.OP201);
                    }
                    if (args.has("bs")) {
                        gp.setBlockSize((Integer)args.valueOf("bs"));
                    }
                    if (args.has("acr-list")) {
                        SEAccessControlUtility.acrList(gp, card);
                    }
                    if (!GPTool.needsAuthentication(args)) continue;
                    Object mode = GlobalPlatform.defaultMode.clone();
                    if (args.has("mode")) {
                        ((AbstractCollection)mode).clear();
                        for (Object s : args.valuesOf("mode")) {
                            ((AbstractCollection)mode).add(GlobalPlatform.APDUMode.fromString((String)s));
                        }
                    }
                    gp.openSecureChannel(keys, null, 0, (EnumSet<GlobalPlatform.APDUMode>)mode);
                    if (args.has("secure-apdu")) {
                        for (Object s : args.valuesOf("secure-apdu")) {
                            CommandAPDU c = new CommandAPDU(HexUtils.stringToBin((String)((String)s)));
                            gp.transmit(c);
                        }
                    }
                    if (args.has("delete")) {
                        GPRegistry reg = gp.getRegistry();
                        if (args.has("default") && reg.getDefaultSelectedAID() != null) {
                            if (reg.getDefaultSelectedPackageAID() != null) {
                                gp.deleteAID(reg.getDefaultSelectedPackageAID(), true);
                            } else {
                                System.err.println("Could not identify default selected application!");
                            }
                        }
                        List aids = args.valuesOf("delete");
                        for (String s : aids) {
                            AID aid = AID.fromString((Object)s);
                            try {
                                gp.deleteAID(aid, reg.allPackageAIDs().contains(aid) || args.has("force"));
                            }
                            catch (GPException e) {
                                if (!gp.getRegistry().allAIDs().contains(aid)) {
                                    System.err.println("Could not delete AID (not present on card): " + aid);
                                    continue;
                                }
                                System.err.println("Could not delete AID: " + aid);
                                if (e.sw != 27013) throw e;
                                System.err.println("Deletion not allowed. Some app still active?");
                            }
                        }
                    }
                    if (args.has("uninstall")) {
                        capfile = (File)args.valueOf("uninstall");
                        instcap = CAPFile.fromStream((InputStream)new FileInputStream(capfile));
                        AID aid = instcap.getPackageAID();
                        if (!gp.getRegistry().allAIDs().contains(aid)) {
                            System.out.println(aid + " is not present on card!");
                        } else {
                            gp.deleteAID(aid, true);
                            System.out.println(aid + " deleted.");
                        }
                    }
                    if (args.has("load")) {
                        capfile = (File)args.valueOf("load");
                        CAPFile loadcap = CAPFile.fromStream((InputStream)new FileInputStream(capfile));
                        if (isVerbose) {
                            loadcap.dump(System.out);
                        }
                        try {
                            AID target = null;
                            boolean dapRequired = false;
                            if (args.has("to")) {
                                target = AID.fromString((Object)args.valueOf("to"));
                                if (gp.getRegistry().getDomain(target).getPrivileges().has(GPRegistryEntry.Privilege.DAPVerification)) {
                                    dapRequired = true;
                                }
                            }
                            for (GPRegistryEntryApp e : gp.getRegistry().allDomains()) {
                                if (!e.getPrivileges().has(GPRegistryEntry.Privilege.MandatedDAPVerification)) continue;
                                dapRequired = true;
                            }
                            if (dapRequired) {
                                byte[] dap = args.has("sha256") ? loadcap.getMetaInfEntry("dap.rsa.sha256") : loadcap.getMetaInfEntry("dap.rsa.sha1");
                                gp.loadCapFile(loadcap, target, dap, args.has("sha256") ? "SHA-256" : "SHA1");
                            } else {
                                gp.loadCapFile(loadcap, target);
                            }
                        }
                        catch (GPException e) {
                            if (e.sw != 27013) throw e;
                            System.err.println("Applet loading failed. Are you sure the CAP file target is compatible with your card?");
                            throw e;
                        }
                    }
                    if (args.has("put-key")) {
                        PublicKey key;
                        int keyVersion = 115;
                        if (args.has("new-keyver")) {
                            keyVersion = GPUtils.intValue(args.valuesOf("new-keyver").toString());
                        }
                        if ((key = GPCrypto.pem2pubkey(new FileInputStream(new File(args.valueOf("put-key").toString())))) instanceof RSAPublicKey) {
                            gp.putKey((RSAPublicKey)key, 115);
                        }
                    }
                    if (args.has("install")) {
                        AID appaid;
                        File capfile2 = (File)args.valueOf("install");
                        instcap = CAPFile.fromStream((InputStream)new FileInputStream(capfile2));
                        if (args.has("verbose")) {
                            instcap.dump(System.out);
                        }
                        GPRegistry reg = gp.getRegistry();
                        if (args.has("force") && reg.allPackageAIDs().contains(instcap.getPackageAID())) {
                            gp.deleteAID(instcap.getPackageAID(), true);
                        }
                        if (instcap.getAppletAIDs().size() <= 1) {
                            try {
                                AID target = null;
                                if (args.has("to")) {
                                    target = AID.fromString((Object)args.valueOf("to"));
                                }
                                gp.loadCapFile(instcap, target);
                                System.out.println("CAP loaded");
                            }
                            catch (GPException e) {
                                if (e.sw != 27013) {
                                    if (e.sw != 27264) throw e;
                                }
                                System.err.println("Loading failed. Are you sure the CAP file (JC version, packages, sizes) is compatible with your card?");
                                throw e;
                            }
                        }
                        if (instcap.getAppletAIDs().size() == 0) {
                            return;
                        }
                        if (instcap.getAppletAIDs().size() > 1) {
                            if (!args.has("applet")) {
                                GPTool.fail("CAP contains more than one applet, specify the right one with --applet");
                                return;
                            }
                            appaid = AID.fromString((Object)args.valueOf("applet"));
                        } else {
                            appaid = (AID)instcap.getAppletAIDs().get(0);
                        }
                        AID instanceaid = args.has("create") ? AID.fromString((Object)args.valueOf("create")) : appaid;
                        GPRegistryEntry.Privileges privs = GPTool.getInstPrivs(args);
                        if (args.has("force") && reg.getDefaultSelectedAID() != null && privs.has(GPRegistryEntry.Privilege.CardReset)) {
                            gp.deleteAID(reg.getDefaultSelectedAID(), false);
                        }
                        if (gp.getRegistry().allAppletAIDs().contains(instanceaid)) {
                            System.err.println("WARNING: Applet " + instanceaid + " already present on card");
                        }
                        gp.installAndMakeSelectable(instcap.getPackageAID(), appaid, instanceaid, privs, GPTool.getInstParams(args), null);
                    }
                    if (args.has("create") && !args.has("install")) {
                        AID packageAID = null;
                        appletAID = null;
                        if (cap != null) {
                            packageAID = cap.getPackageAID();
                            if (cap.getAppletAIDs().size() != 1) {
                                throw new IllegalArgumentException("There should be only one applet in CAP. Use --applet instead.");
                            }
                            appletAID = (AID)cap.getAppletAIDs().get(0);
                        }
                        if (args.has("package")) {
                            packageAID = AID.fromString((Object)args.valueOf("package"));
                        }
                        if (args.has("applet")) {
                            appletAID = AID.fromString((Object)args.valueOf("applet"));
                        }
                        if (packageAID == null) throw new IllegalArgumentException("Need --package and --applet or --cap");
                        if (appletAID == null) {
                            throw new IllegalArgumentException("Need --package and --applet or --cap");
                        }
                        if (gp.getRegistry().allAIDs().contains(appletAID)) {
                            System.err.println("WARNING: Applet " + appletAID + " already present on card");
                        }
                        instanceAID = AID.fromString((Object)args.valueOf("create"));
                        gp.installAndMakeSelectable(packageAID, appletAID, instanceAID, GPTool.getInstPrivs(args), GPTool.getInstParams(args), null);
                    }
                    if (args.has("domain")) {
                        if ((args.has("allow-from") || args.has("allow-to")) && args.has("params")) {
                            GPTool.fail("SSD extradition options can't be used with SSD installation parameters");
                        }
                        AID packageAID = new AID("A0000001515350");
                        appletAID = new AID("A000000151535041");
                        if (args.has("package") && args.has("applet")) {
                            packageAID = AID.fromString((Object)args.valueOf("package"));
                            appletAID = AID.fromString((Object)args.valueOf("applet"));
                        } else {
                            System.out.println("Note: using default AID-s for SSD instantiation: " + appletAID + " from " + packageAID);
                        }
                        instanceAID = AID.fromString((Object)args.valueOf("domain"));
                        GPRegistryEntry.Privileges privs = GPTool.getInstPrivs(args);
                        privs.add(GPRegistryEntry.Privilege.SecurityDomain);
                        byte[] params = new byte[]{};
                        if (args.has("params")) {
                            params = GPTool.getInstParams(args);
                        } else {
                            if (args.has("allow-to")) {
                                params = GPUtils.concatenate(params, {-126, 1, 32});
                            }
                            if (args.has("allow-from")) {
                                params = GPUtils.concatenate(params, {-121, 1, 32});
                            }
                        }
                        gp.installAndMakeSelectable(packageAID, appletAID, instanceAID, privs, params, null);
                    }
                    if (args.has("move")) {
                        if (!args.has("to")) {
                            GPTool.fail("Specify extradition target with --to");
                        }
                        AID what = AID.fromString((Object)args.valueOf("move"));
                        AID to = AID.fromString((Object)args.valueOf("to"));
                        gp.extradite(what, to);
                    }
                    if (args.has("store-data")) {
                        if (args.has("applet")) {
                            gp.personalize(AID.fromString((Object)args.valueOf("applet")), HexUtils.stringToBin((String)((String)args.valueOf("store-data"))));
                        } else {
                            gp.storeData(HexUtils.stringToBin((String)((String)args.valueOf("store-data"))), 0);
                        }
                    }
                    if (args.has("acr-add")) {
                        if (!args.has("acr-hash")) {
                            System.err.println("Must specify certificate hash with -acr-hash");
                        } else if (!args.has("applet")) {
                            System.err.println("Must specify target application id with -applet");
                        } else if (!args.has("acr-rule")) {
                            System.err.println("Must specify an access rule with -acr-rule (00, 01 or an apdu filter)");
                        } else if (HexUtils.stringToBin((String)((String)args.valueOf("acr-hash"))).length == 20) {
                            SEAccessControlUtility.acrAdd(gp, AID.fromString((Object)args.valueOf("applet")), HexUtils.stringToBin((String)((String)args.valueOf("acr-hash"))), HexUtils.stringToBin((String)((String)args.valueOf("acr-rule"))));
                        } else {
                            System.err.println("certificate hash must be 20 bytes");
                        }
                    }
                    if (args.has("acr-delete")) {
                        if (!args.has("applet")) {
                            System.err.println("Must specify target application id with -applet");
                        } else if (args.has("acr-hash")) {
                            byte[] hash = HexUtils.stringToBin((String)((String)args.valueOf("acr-hash")));
                            if (hash.length == 20) {
                                SEAccessControlUtility.acrDelete(gp, AID.fromString((Object)args.valueOf("applet")), hash);
                            } else {
                                System.err.println("certificate hash must be 20 bytes");
                            }
                        } else {
                            SEAccessControlUtility.acrDelete(gp, AID.fromString((Object)args.valueOf("applet")), null);
                        }
                    }
                    if (args.has("lock-card")) {
                        gp.setCardStatus((byte)127);
                    }
                    if (args.has("unlock-card")) {
                        gp.setCardStatus((byte)15);
                    }
                    if (args.has("initialize-card")) {
                        gp.setCardStatus((byte)7);
                    }
                    if (args.has("secure-card")) {
                        GPRegistryEntryApp isd = gp.getRegistry().getISD();
                        if (isd == null) {
                            GPCommands.listRegistry(gp.getRegistry(), System.out, true);
                            GPTool.fail("ISD is null");
                        }
                        if (isd.getLifeCycle() != 7 && args.has("force")) {
                            System.out.println("Note: forcing status to INITIALIZED");
                            gp.setCardStatus((byte)7);
                        }
                        gp.setCardStatus((byte)15);
                    }
                    if (args.has("lock-applet")) {
                        gp.lockUnlockApplet(AID.fromString((Object)args.valueOf("lock-applet")), true);
                    }
                    if (args.has("unlock-applet")) {
                        gp.lockUnlockApplet(AID.fromString((Object)args.valueOf("unlock-applet")), false);
                    }
                    if (args.has("list")) {
                        GPCommands.listRegistry(gp.getRegistry(), System.out, args.has("verbose"));
                    }
                    if (args.has("delete-key")) {
                        int keyver = GPUtils.intValue((String)args.valueOf("delete-key"));
                        System.out.println("Deleting key " + keyver);
                        gp.deleteKey(keyver);
                    }
                    if (args.has("unlock")) {
                        int kv;
                        boolean replace;
                        ArrayList<GPKey> newkeys = new ArrayList<GPKey>();
                        if (gp.getScpKeyVersion() == 255) {
                            replace = false;
                            kv = 1;
                        } else {
                            kv = gp.getScpKeyVersion();
                            replace = true;
                        }
                        GPKey new_key = new GPKey(GPData.defaultKeyBytes, gp.getSCPVersion() == 3 ? GPKey.Type.AES : GPKey.Type.DES3);
                        newkeys.add(new GPKey(kv, 1, new_key));
                        newkeys.add(new GPKey(kv, 2, new_key));
                        newkeys.add(new GPKey(kv, 3, new_key));
                        gp.putKeys(newkeys, replace);
                        System.out.println("Default " + new_key.toString() + " set as master key for " + gp.getAID());
                    }
                    if (args.has("lock") || args.has("lock-enc") && args.has("lock-mac") && args.has("lock-dek")) {
                        boolean replace = true;
                        List<GPKey> current = gp.getKeyInfoTemplate();
                        int new_version = 1;
                        if (current.size() > 0) {
                            if (current.get(0).getVersion() == 255) {
                                replace = false;
                            } else {
                                new_version = current.get(0).getVersion();
                            }
                        }
                        if (args.has("new-keyver")) {
                            new_version = GPUtils.intValue((String)args.valueOf("new-keyver"));
                            replace = false;
                            System.out.println("New version: " + new_version);
                        }
                        ArrayList<GPKey> updatekeys = new ArrayList<GPKey>();
                        if (args.has("lock-enc") && args.has("lock-mac") && args.has("lock-dek")) {
                            updatekeys.add(new GPKey(new_version, 1, new GPKey(HexUtils.stringToBin((String)((String)args.valueOf("lock-enc"))))));
                            updatekeys.add(new GPKey(new_version, 2, new GPKey(HexUtils.stringToBin((String)((String)args.valueOf("lock-mac"))))));
                            updatekeys.add(new GPKey(new_version, 3, new GPKey(HexUtils.stringToBin((String)((String)args.valueOf("lock-dek"))))));
                        } else {
                            GPKey nk = new GPKey(HexUtils.stringToBin((String)((String)args.valueOf("lock"))));
                            updatekeys.add(new GPKey(new_version, 1, nk));
                            updatekeys.add(new GPKey(new_version, 2, nk));
                            updatekeys.add(new GPKey(new_version, 3, nk));
                        }
                        GPKey.Type t = gp.getSCPVersion() == 3 ? GPKey.Type.AES : GPKey.Type.DES3;
                        for (GPKey k : updatekeys) {
                            k.become(t);
                        }
                        gp.putKeys(updatekeys, replace);
                        if (args.has("lock")) {
                            System.out.println("Card locked with: " + HexUtils.bin2hex((byte[])HexUtils.stringToBin((String)((String)args.valueOf("lock")))));
                            System.out.println("Write this down, DO NOT FORGET/LOSE IT!");
                        } else {
                            System.out.println("Card locked with new keys.");
                            System.out.println("Write them down, DO NOT FORGET/LOSE THEM!");
                        }
                    }
                    if (args.has("make-default")) {
                        gp.makeDefaultSelected(AID.fromString((Object)args.valueOf("make-default")));
                    }
                    if (args.has("rename-isd")) {
                        gp.renameISD(AID.fromString((Object)args.valueOf("rename-isd")));
                    }
                    if (args.has("set-pre-perso")) {
                        byte[] payload = HexUtils.stringToBin((String)((String)args.valueOf("set-pre-perso")));
                        if (args.has("today")) {
                            System.arraycopy(GPData.CPLC.today(), 0, payload, 2, 2);
                        }
                        GPCommands.setPrePerso(gp, payload);
                    }
                    if (!args.has("set-perso")) continue;
                    byte[] payload = HexUtils.stringToBin((String)((String)args.valueOf("set-perso")));
                    if (args.has("today")) {
                        System.arraycopy(GPData.CPLC.today(), 0, payload, 2, 2);
                    }
                    GPCommands.setPerso(gp, payload);
                }
                catch (GPException e) {
                    if (args.has("force")) continue;
                    GPTool.fail(e.getMessage());
                }
                catch (CardException e) {
                    System.out.println("Failed to communicate with card in " + var7_18 + ": " + e.getMessage());
                }
                finally {
                    if (card == null) continue;
                    card.endExclusive();
                    card.disconnect(true);
                    card = null;
                }
            }
        }
        catch (CardException e) {
            if (TerminalManager.getExceptionMessage((Exception)e) != null) {
                System.out.println("PC/SC failure: " + TerminalManager.getExceptionMessage((Exception)e));
            }
            e.printStackTrace();
            GPTool.fail("CardException, terminating");
        }
        System.exit(0);
    }

    private static GPRegistryEntry.Privileges getInstPrivs(OptionSet args) {
        GPRegistryEntry.Privileges privs = new GPRegistryEntry.Privileges();
        if (args.has("privs")) {
            GPTool.addPrivs(privs, (String)args.valueOf("privs"));
        }
        if (args.has("default")) {
            privs.add(GPRegistryEntry.Privilege.CardReset);
        }
        if (args.has("terminate")) {
            privs.add(GPRegistryEntry.Privilege.CardLock);
            privs.add(GPRegistryEntry.Privilege.CardTerminate);
        }
        return privs;
    }

    private static GPRegistryEntry.Privileges addPrivs(GPRegistryEntry.Privileges privs, String v) {
        String[] parts;
        if (v == null) {
            return privs;
        }
        for (String s : parts = v.split(",")) {
            GPRegistryEntry.Privilege p = GPRegistryEntry.Privilege.lookup(s.trim());
            if (p == null) {
                throw new IllegalArgumentException("Unknown privilege: " + s.trim());
            }
            privs.add(p);
        }
        return privs;
    }

    private static byte[] getInstParams(OptionSet args) {
        if (args.has("params")) {
            String arg = (String)args.valueOf("params");
            return HexUtils.stringToBin((String)arg);
        }
        return new byte[0];
    }

    private static boolean ignoreReader(String name) {
        String ignore = System.getenv("GP_READER_IGNORE");
        if (ignore != null) {
            String[] names;
            for (String n : names = ignore.toLowerCase().split(";")) {
                if (!name.toLowerCase().contains(n)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean needsAuthentication(OptionSet args) {
        String[] yes;
        for (String s : yes = new String[]{"list", "load", "install", "delete", "delete-key", "create", "acr-add", "acr-delete", "lock", "unlock", "lock-enc", "lock-mac", "lock-dek", "make-default", "uninstall", "secure-apdu", "domain", "lock-card", "unlock-card", "lock-applet", "unlock-applet", "store-data", "initialize-card", "secure-card", "rename-isd", "set-perso", "set-pre-perso", "move", "put-key"}) {
            if (!args.has(s)) continue;
            return true;
        }
        return false;
    }

    private static void fail(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    private static void verbose(String s) {
        if (isVerbose) {
            System.out.println("# " + s);
        }
    }
}

