/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

abstract class GPCommandLineInterface {
    protected static final String OPT_ALLOW_TO = "allow-to";
    protected static final String OPT_ALLOW_FROM = "allow-from";
    protected static final String OPT_APDU = "apdu";
    protected static final String OPT_APPLET = "applet";
    protected static final String OPT_BS = "bs";
    protected static final String OPT_CAP = "cap";
    protected static final String OPT_CREATE = "create";
    protected static final String OPT_DEBUG = "debug";
    protected static final String OPT_DEFAULT = "default";
    protected static final String OPT_DELETE = "delete";
    protected static final String OPT_DELETE_KEY = "delete-key";
    protected static final String OPT_DOMAIN = "domain";
    protected static final String OPT_MOVE = "move";
    protected static final String OPT_DUMP = "dump";
    protected static final String OPT_EMV = "emv";
    protected static final String OPT_FORCE = "force";
    protected static final String OPT_INFO = "info";
    protected static final String OPT_INITIALIZE_CARD = "initialize-card";
    protected static final String OPT_INSTALL = "install";
    protected static final String OPT_KCV = "kcv";
    protected static final String OPT_KDF3 = "kdf3";
    protected static final String OPT_KEY = "key";
    protected static final String OPT_KEYS = "keys";
    protected static final String OPT_KEY_ENC = "key-enc";
    protected static final String OPT_KEY_ID = "key-id";
    protected static final String OPT_KEY_DEK = "key-dek";
    protected static final String OPT_KEY_MAC = "key-mac";
    protected static final String OPT_KEY_VERSION = "key-ver";
    protected static final String OPT_LIST = "list";
    protected static final String OPT_LIST_PRIVS = "list-privs";
    protected static final String OPT_LOAD = "load";
    protected static final String OPT_LOCK = "lock";
    protected static final String OPT_LOCK_ENC = "lock-enc";
    protected static final String OPT_LOCK_MAC = "lock-mac";
    protected static final String OPT_LOCK_DEK = "lock-dek";
    protected static final String OPT_LOCK_APPLET = "lock-applet";
    protected static final String OPT_LOCK_CARD = "lock-card";
    protected static final String OPT_MAKE_DEFAULT = "make-default";
    protected static final String OPT_NEW_KEY_VERSION = "new-keyver";
    protected static final String OPT_OP201 = "op201";
    protected static final String OPT_PACKAGE = "package";
    protected static final String OPT_PARAMS = "params";
    protected static final String OPT_PRIVS = "privs";
    protected static final String OPT_PUT_KEY = "put-key";
    protected static final String OPT_READER = "reader";
    protected static final String OPT_RENAME_ISD = "rename-isd";
    protected static final String OPT_REPLAY = "replay";
    protected static final String OPT_SC_MODE = "mode";
    protected static final String OPT_SDAID = "sdaid";
    protected static final String OPT_SECURE_APDU = "secure-apdu";
    protected static final String OPT_SECURE_CARD = "secure-card";
    protected static final String OPT_SET_PRE_PERSO = "set-pre-perso";
    protected static final String OPT_SET_PERSO = "set-perso";
    protected static final String OPT_SHA256 = "sha256";
    protected static final String OPT_STORE_DATA = "store-data";
    protected static final String OPT_TERMINALS = "terminals";
    protected static final String OPT_TERMINATE = "terminate";
    protected static final String OPT_TODAY = "today";
    protected static final String OPT_TO = "to";
    protected static final String OPT_UNINSTALL = "uninstall";
    protected static final String OPT_UNLOCK = "unlock";
    protected static final String OPT_UNLOCK_APPLET = "unlock-applet";
    protected static final String OPT_UNLOCK_CARD = "unlock-card";
    protected static final String OPT_VERBOSE = "verbose";
    protected static final String OPT_VERSION = "version";
    protected static final String OPT_VISA2 = "visa2";
    protected static final String OPT_ORACLE = "oracle";
    protected static final String OPT_ACR_LIST = "acr-list";
    protected static final String OPT_ACR_ADD = "acr-add";
    protected static final String OPT_ACR_DELETE = "acr-delete";
    protected static final String OPT_ACR_RULE = "acr-rule";
    protected static final String OPT_ACR_CERT_HASH = "acr-hash";

    GPCommandLineInterface() {
    }

    protected static OptionSet parseArguments(String[] argv) throws IOException {
        OptionSet args = null;
        OptionParser parser = new OptionParser();
        parser.acceptsAll(Arrays.asList("V", OPT_VERSION), "Show information about the program");
        parser.acceptsAll(Arrays.asList("h", "?", "help"), "Shows this help").forHelp();
        parser.acceptsAll(Arrays.asList("d", OPT_DEBUG), "Show PC/SC and APDU trace");
        parser.acceptsAll(Arrays.asList("v", OPT_VERBOSE), "Be verbose about operations");
        parser.acceptsAll(Arrays.asList("r", OPT_READER), "Use specific reader").withRequiredArg();
        parser.acceptsAll(Arrays.asList("l", OPT_LIST), "List the contents of the card");
        parser.acceptsAll(Arrays.asList("i", OPT_INFO), "Show information");
        parser.acceptsAll(Arrays.asList("a", OPT_APDU), "Send raw APDU (hex)").withRequiredArg().describedAs("APDU");
        parser.acceptsAll(Arrays.asList("s", OPT_SECURE_APDU), "Send raw APDU (hex) via SCP").withRequiredArg().describedAs("APDU");
        parser.acceptsAll(Arrays.asList("f", OPT_FORCE), "Force operation");
        parser.accepts(OPT_DUMP, "Dump APDU communication to <File>").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_REPLAY, "Replay APDU responses from <File>").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_TERMINALS, "Use PC/SC provider from <jar:class>").withRequiredArg();
        parser.accepts(OPT_CAP, "Use a CAP file as source").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_LOAD, "Load a CAP file").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_INSTALL, "Install applet(s) from CAP").withOptionalArg().ofType(File.class);
        parser.accepts(OPT_PARAMS, "Installation parameters").withRequiredArg().describedAs("HEX");
        parser.accepts(OPT_PRIVS, "Specify privileges for installation").withRequiredArg();
        parser.accepts(OPT_LIST_PRIVS, "List known privileges");
        parser.accepts(OPT_UNINSTALL, "Uninstall applet/package").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_DEFAULT, "Indicate Default Selected privilege");
        parser.accepts(OPT_TERMINATE, "Indicate Card Lock+Terminate privilege");
        parser.accepts(OPT_DOMAIN, "Create supplementary security domain").withRequiredArg().describedAs("AID");
        parser.accepts(OPT_LOCK_APPLET, "Lock applet").withRequiredArg().describedAs("AID");
        parser.accepts(OPT_UNLOCK_APPLET, "Unlock applet").withRequiredArg().describedAs("AID");
        parser.accepts(OPT_LOCK_CARD, "Lock card");
        parser.accepts(OPT_UNLOCK_CARD, "Unlock card");
        parser.accepts(OPT_SECURE_CARD, "Transition ISD to SECURED state");
        parser.accepts(OPT_INITIALIZE_CARD, "Transition ISD to INITIALIZED state");
        parser.accepts(OPT_MOVE, "Move something").withRequiredArg().describedAs("AID");
        parser.accepts(OPT_TO, "Destination security domain").withRequiredArg().describedAs("AID");
        parser.accepts(OPT_ALLOW_TO, "Accept extradition to SSD");
        parser.accepts(OPT_ALLOW_FROM, "Accept extradition from SSD");
        parser.accepts(OPT_SHA256, "Use SHA-256 for LFDB hash");
        parser.accepts(OPT_SET_PRE_PERSO, "Set PrePerso data in CPLC").withRequiredArg().describedAs("data");
        parser.accepts(OPT_SET_PERSO, "Set Perso data in CPLC").withRequiredArg().describedAs("data");
        parser.accepts(OPT_TODAY, "Set date to today when updating CPLC");
        parser.accepts(OPT_STORE_DATA, "STORE DATA to applet").withRequiredArg().describedAs("data");
        parser.accepts(OPT_MAKE_DEFAULT, "Make AID the default").withRequiredArg().describedAs("AID");
        parser.accepts(OPT_RENAME_ISD, "Rename ISD").withRequiredArg().describedAs("new AID");
        parser.accepts(OPT_DELETE, "Delete applet/package").withOptionalArg().describedAs("AID");
        parser.accepts(OPT_DELETE_KEY, "Delete key with version").withRequiredArg();
        parser.accepts(OPT_CREATE, "Create new instance of an applet").withRequiredArg().describedAs("AID");
        parser.accepts(OPT_APPLET, "Applet AID").withRequiredArg().describedAs("AID");
        parser.acceptsAll(Arrays.asList(OPT_PACKAGE, "pkg"), "Package AID").withRequiredArg().describedAs("AID");
        parser.accepts(OPT_KEY, "Specify master key").withRequiredArg().describedAs(OPT_KEY);
        parser.accepts(OPT_KCV, "Specify master key check value").withRequiredArg().describedAs("KCV");
        parser.accepts(OPT_KEY_MAC, "Specify card MAC key").withRequiredArg().describedAs(OPT_KEY);
        parser.accepts(OPT_KEY_ENC, "Specify card ENC key").withRequiredArg().describedAs(OPT_KEY);
        parser.accepts(OPT_KEY_DEK, "Specify card DEK key").withRequiredArg().describedAs(OPT_KEY);
        parser.accepts(OPT_EMV, "Use EMV diversification");
        parser.accepts(OPT_VISA2, "Use VISA2 diversification");
        parser.accepts(OPT_KDF3, "Use SCP03 KDF diversification");
        parser.accepts(OPT_ORACLE, "Use an oracle for keying information").withOptionalArg().describedAs("URL");
        parser.accepts(OPT_KEY_ID, "Specify key ID").withRequiredArg();
        parser.accepts(OPT_KEY_VERSION, "Specify key version").withRequiredArg();
        parser.accepts(OPT_PUT_KEY, "Put a new key").withRequiredArg().describedAs("PEM file");
        parser.accepts(OPT_LOCK, "Set new key").withRequiredArg().describedAs(OPT_KEY);
        parser.accepts(OPT_LOCK_ENC, "Set new ENC key").withRequiredArg().describedAs(OPT_KEY);
        parser.accepts(OPT_LOCK_MAC, "Set new MAC key").withRequiredArg().describedAs(OPT_KEY);
        parser.accepts(OPT_LOCK_DEK, "Set new DEK key").withRequiredArg().describedAs(OPT_KEY);
        parser.accepts(OPT_UNLOCK, "Set default key for card key");
        parser.accepts(OPT_NEW_KEY_VERSION, "Key version for the new key").withRequiredArg();
        parser.accepts(OPT_ACR_LIST, "List access rules");
        parser.accepts(OPT_ACR_ADD, "Add an access rule");
        parser.accepts(OPT_ACR_DELETE, "Delete an access rule");
        parser.accepts(OPT_ACR_RULE, "Access control rule (can be 0x00(NEVER),0x01(ALWAYS) or an apdu filter").withRequiredArg();
        parser.accepts(OPT_ACR_CERT_HASH, "Certificate hash (sha1)").withRequiredArg();
        parser.accepts(OPT_SC_MODE, "Secure channel to use (mac/enc/clr)").withRequiredArg();
        parser.accepts(OPT_BS, "maximum APDU payload size").withRequiredArg().ofType(Integer.class);
        parser.accepts(OPT_OP201, "Enable OpenPlatform 2.0.1 mode");
        parser.accepts(OPT_SDAID, "ISD AID").withRequiredArg().describedAs("AID");
        try {
            args = parser.parse(argv);
        }
        catch (OptionException e) {
            if (e.getCause() != null) {
                System.err.println(e.getMessage() + ": " + e.getCause().getMessage());
            } else {
                System.err.println(e.getMessage());
            }
            System.err.println();
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        if (args.has("help") || args.specs().size() == 0) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        return args;
    }
}

