/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKey;
import pro.javacard.gp.GPSessionKeyProvider;
import pro.javacard.gp.GPUtils;

public class PlaintextKeys
extends GPSessionKeyProvider {
    private static final Logger logger = LoggerFactory.getLogger(PlaintextKeys.class);
    public static final Map<GPSessionKeyProvider.KeyPurpose, byte[]> SCP02_CONSTANTS;
    public static final Map<GPSessionKeyProvider.KeyPurpose, Byte> SCP03_CONSTANTS;
    Diversification diversifier = null;
    private int version = 0;
    private int id = 0;
    private HashMap<GPSessionKeyProvider.KeyPurpose, GPKey> cardKeys = new HashMap();
    private HashMap<GPSessionKeyProvider.KeyPurpose, GPKey> sessionKeys = new HashMap();

    private PlaintextKeys() {
    }

    public static PlaintextKeys fromMasterKey(GPKey master) {
        return PlaintextKeys.derivedFromMasterKey(master, null);
    }

    public static PlaintextKeys derivedFromMasterKey(GPKey master, Diversification div) {
        PlaintextKeys p = new PlaintextKeys();
        p.cardKeys.put(GPSessionKeyProvider.KeyPurpose.ENC, new GPKey(master.getBytes()));
        p.cardKeys.put(GPSessionKeyProvider.KeyPurpose.MAC, new GPKey(master.getBytes()));
        p.cardKeys.put(GPSessionKeyProvider.KeyPurpose.DEK, new GPKey(master.getBytes()));
        p.diversifier = div;
        return p;
    }

    public static PlaintextKeys fromKeys(GPKey enc, GPKey mac, GPKey kek) {
        PlaintextKeys p = new PlaintextKeys();
        p.cardKeys.put(GPSessionKeyProvider.KeyPurpose.ENC, enc);
        p.cardKeys.put(GPSessionKeyProvider.KeyPurpose.MAC, mac);
        p.cardKeys.put(GPSessionKeyProvider.KeyPurpose.DEK, kek);
        return p;
    }

    public static GPKey diversify(GPKey k, GPSessionKeyProvider.KeyPurpose usage, byte[] kdd, Diversification method) throws GPException {
        try {
            byte[] kv;
            if (method == Diversification.VISA2) {
                kv = PlaintextKeys.fillVisa2(kdd, usage);
            } else if (method == Diversification.EMV) {
                kv = PlaintextKeys.fillEmv(kdd, usage);
            } else {
                throw new IllegalStateException("Unknown diversification method");
            }
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(1, k.getKeyAs(GPKey.Type.DES3));
            return new GPKey(cipher.doFinal(kv));
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new GPException("Diversification failed.", e);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("Can not diversify", e);
        }
    }

    public static final byte[] fillVisa2(byte[] kdd, GPSessionKeyProvider.KeyPurpose key) {
        byte[] data = new byte[16];
        System.arraycopy(kdd, 0, data, 0, 2);
        System.arraycopy(kdd, 4, data, 2, 4);
        data[6] = -16;
        data[7] = key.getValue();
        System.arraycopy(kdd, 0, data, 8, 2);
        System.arraycopy(kdd, 4, data, 10, 4);
        data[14] = 15;
        data[15] = key.getValue();
        return data;
    }

    public static final byte[] fillVisa(byte[] kdd, GPSessionKeyProvider.KeyPurpose key) {
        byte[] data = new byte[16];
        System.arraycopy(kdd, 0, data, 0, 4);
        System.arraycopy(kdd, 8, data, 4, 2);
        data[6] = -16;
        data[7] = 1;
        System.arraycopy(kdd, 0, data, 8, 4);
        System.arraycopy(kdd, 8, data, 12, 2);
        data[14] = 15;
        data[15] = 1;
        return data;
    }

    public static final byte[] fillEmv(byte[] kdd, GPSessionKeyProvider.KeyPurpose key) {
        byte[] data = new byte[16];
        System.arraycopy(kdd, 4, data, 0, 6);
        data[6] = -16;
        data[7] = key.getValue();
        System.arraycopy(kdd, 4, data, 8, 6);
        data[14] = 15;
        data[15] = key.getValue();
        return data;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    private GPKey deriveSessionKeySCP01(GPKey cardKey, GPSessionKeyProvider.KeyPurpose p, byte[] host_challenge, byte[] card_challenge) {
        if (p == GPSessionKeyProvider.KeyPurpose.RMAC) {
            return null;
        }
        if (p == GPSessionKeyProvider.KeyPurpose.DEK) {
            return cardKey;
        }
        byte[] derivationData = new byte[16];
        System.arraycopy(card_challenge, 4, derivationData, 0, 4);
        System.arraycopy(host_challenge, 0, derivationData, 4, 4);
        System.arraycopy(card_challenge, 0, derivationData, 8, 4);
        System.arraycopy(host_challenge, 4, derivationData, 12, 4);
        try {
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(1, cardKey.getKeyAs(GPKey.Type.DES3));
            return new GPKey(cipher.doFinal(derivationData), GPKey.Type.DES3);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("Can not calculate session keys", e);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Session key calculation failed", e);
        }
    }

    private GPKey deriveSessionKeySCP02(GPKey cardKey, GPSessionKeyProvider.KeyPurpose p, byte[] sequence) {
        try {
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            byte[] derivationData = new byte[16];
            System.arraycopy(sequence, 0, derivationData, 2, 2);
            System.arraycopy(SCP02_CONSTANTS.get((Object)p), 0, derivationData, 0, 2);
            cipher.init(1, cardKey.getKeyAs(GPKey.Type.DES3), GPCrypto.iv_null_8);
            return new GPKey(cipher.doFinal(derivationData), GPKey.Type.DES3);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("Session keys calculation failed.", e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Session keys calculation failed.", e);
        }
    }

    private GPKey deriveSessionKeySCP03(GPKey cardKey, GPSessionKeyProvider.KeyPurpose p, byte[] host_challenge, byte[] card_challenge) {
        if (p == GPSessionKeyProvider.KeyPurpose.DEK) {
            return cardKey;
        }
        byte[] context = GPUtils.concatenate(host_challenge, card_challenge);
        byte[] kdf = GPCrypto.scp03_kdf(cardKey, (byte)SCP03_CONSTANTS.get((Object)p), context, cardKey.getLength() * 8);
        return new GPKey(kdf, GPKey.Type.AES);
    }

    @Override
    public boolean init(byte[] atr, byte[] cplc, byte[] kinfo) {
        logger.debug("Card keys: {}", (Object)this.cardKeys.toString());
        return true;
    }

    @Override
    public void calculate(int scp, byte[] kdd, byte[] host_challenge, byte[] card_challenge, byte[] ssc) throws GPException {
        if (scp == 1 || scp == 3) {
            if (host_challenge == null || card_challenge == null) {
                throw new IllegalArgumentException("SCP0" + scp + " requires host challenge and card challenge");
            }
        } else if (scp == 2) {
            if (ssc == null) {
                throw new IllegalArgumentException("SCP02 requires sequence");
            }
        } else {
            throw new IllegalArgumentException("Don't know how to handle SCP0" + scp);
        }
        logger.debug("Card keys: {}", (Object)this.cardKeys.toString());
        if (this.diversifier != null) {
            for (Map.Entry<GPSessionKeyProvider.KeyPurpose, GPKey> e : this.cardKeys.entrySet()) {
                this.cardKeys.put(e.getKey(), PlaintextKeys.diversify(e.getValue(), e.getKey(), kdd, this.diversifier));
            }
            logger.debug("Derived per-card keys: {}", (Object)this.cardKeys.toString());
        }
        for (Map.Entry<GPSessionKeyProvider.KeyPurpose, GPKey> e : this.cardKeys.entrySet()) {
            if (scp == 1) {
                this.sessionKeys.put(e.getKey(), this.deriveSessionKeySCP01(e.getValue(), e.getKey(), host_challenge, card_challenge));
                continue;
            }
            if (scp == 2) {
                this.sessionKeys.put(e.getKey(), this.deriveSessionKeySCP02(e.getValue(), e.getKey(), ssc));
                continue;
            }
            if (scp != 3) continue;
            this.sessionKeys.put(e.getKey(), this.deriveSessionKeySCP03(e.getValue(), e.getKey(), host_challenge, card_challenge));
        }
        logger.debug("session keys: {}", (Object)this.sessionKeys.toString());
    }

    @Override
    public GPKey getKeyFor(GPSessionKeyProvider.KeyPurpose p) {
        return this.sessionKeys.get((Object)p);
    }

    @Override
    public int getID() {
        return this.id;
    }

    public void setDiversifier(Diversification diversifier) {
        this.diversifier = diversifier;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    static {
        HashMap<GPSessionKeyProvider.KeyPurpose, byte[]> scp2 = new HashMap<GPSessionKeyProvider.KeyPurpose, byte[]>();
        scp2.put(GPSessionKeyProvider.KeyPurpose.MAC, new byte[]{1, 1});
        scp2.put(GPSessionKeyProvider.KeyPurpose.RMAC, new byte[]{1, 2});
        scp2.put(GPSessionKeyProvider.KeyPurpose.DEK, new byte[]{1, -127});
        scp2.put(GPSessionKeyProvider.KeyPurpose.ENC, new byte[]{1, -126});
        SCP02_CONSTANTS = Collections.unmodifiableMap(scp2);
        HashMap<GPSessionKeyProvider.KeyPurpose, Byte> scp3 = new HashMap<GPSessionKeyProvider.KeyPurpose, Byte>();
        scp3.put(GPSessionKeyProvider.KeyPurpose.ENC, (byte)4);
        scp3.put(GPSessionKeyProvider.KeyPurpose.MAC, (byte)6);
        scp3.put(GPSessionKeyProvider.KeyPurpose.RMAC, (byte)7);
        SCP03_CONSTANTS = Collections.unmodifiableMap(scp3);
    }

    public static enum Diversification {
        VISA2,
        EMV;

    }
}

