/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import java.util.EnumSet;
import java.util.stream.Collectors;
import pro.javacard.gp.AID;
import pro.javacard.gp.GPDataException;

public class GPRegistryEntry {
    protected AID aid;
    protected int lifecycle;
    protected Kind kind;
    protected AID domain;

    private static String getLifeCycleString(Kind kind, int lifeCycleState) {
        switch (kind) {
            case IssuerSecurityDomain: {
                switch (lifeCycleState) {
                    case 1: {
                        return "OP_READY";
                    }
                    case 7: {
                        return "INITIALIZED";
                    }
                    case 15: {
                        return "SECURED";
                    }
                    case 127: {
                        return "CARD_LOCKED";
                    }
                    case 255: {
                        return "TERMINATED";
                    }
                }
                return "ERROR (0x" + Integer.toHexString(lifeCycleState) + ")";
            }
            case Application: {
                if (lifeCycleState == 3) {
                    return "INSTALLED";
                }
                if (lifeCycleState <= 127) {
                    if ((lifeCycleState & 0x78) != 0) {
                        return "SELECTABLE (0x" + Integer.toHexString(lifeCycleState) + ")";
                    }
                    return "SELECTABLE";
                }
                if (lifeCycleState > 131) {
                    return "LOCKED";
                }
                return "ERROR (0x" + Integer.toHexString(lifeCycleState) + ")";
            }
            case ExecutableLoadFile: {
                if (lifeCycleState == 1) {
                    return "LOADED";
                }
                if (lifeCycleState == 0) {
                    return "LOGICALLY_DELETED";
                }
                return "ERROR (0x" + Integer.toHexString(lifeCycleState) + ")";
            }
            case SecurityDomain: {
                if (lifeCycleState == 3) {
                    return "INSTALLED";
                }
                if (lifeCycleState == 7) {
                    return "SELECTABLE";
                }
                if (lifeCycleState == 15) {
                    return "PERSONALIZED";
                }
                if ((lifeCycleState & 0x83) == 131) {
                    return "LOCKED";
                }
                return "ERROR (0x" + Integer.toHexString(lifeCycleState) + ")";
            }
        }
        return "ERROR";
    }

    public AID getAID() {
        return this.aid;
    }

    void setAID(AID aid) {
        this.aid = aid;
    }

    public AID getDomain() {
        return this.domain;
    }

    public int getLifeCycle() {
        return this.lifecycle;
    }

    void setLifeCycle(int lifecycle) {
        this.lifecycle = lifecycle;
    }

    public Kind getType() {
        return this.kind;
    }

    void setType(Kind type) {
        this.kind = type;
    }

    public boolean isPackage() {
        return this.kind == Kind.ExecutableLoadFile;
    }

    public boolean isApplet() {
        return this.kind == Kind.Application;
    }

    public boolean isDomain() {
        return this.kind == Kind.SecurityDomain || this.kind == Kind.IssuerSecurityDomain;
    }

    void setDomain(AID dom) {
        this.domain = dom;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("AID: " + this.aid + ", " + this.lifecycle + ", Kind: " + this.kind.toShortString());
        return result.toString();
    }

    public String getLifeCycleString() {
        return GPRegistryEntry.getLifeCycleString(this.kind, this.lifecycle);
    }

    public static class Privileges {
        private EnumSet<Privilege> privs = EnumSet.noneOf(Privilege.class);

        public static Privileges set(Privilege ... privs) {
            Privileges p = new Privileges();
            for (Privilege pv : privs) {
                p.add(pv);
            }
            return p;
        }

        public static Privileges fromBytes(byte[] data) throws GPDataException {
            if (data.length != 1 && data.length != 3) {
                throw new IllegalArgumentException("Privileges must be encoded on 1 or 3 bytes");
            }
            Privileges p = new Privileges();
            int b1 = data[0] & 0xFF;
            if ((b1 & 0x80) == 128) {
                p.privs.add(Privilege.SecurityDomain);
            }
            if ((b1 & 0xC1) == 192) {
                p.privs.add(Privilege.DAPVerification);
            }
            if ((b1 & 0xA0) == 160) {
                p.privs.add(Privilege.DelegatedManagement);
            }
            if ((b1 & 0x10) == 16) {
                p.privs.add(Privilege.CardLock);
            }
            if ((b1 & 8) == 8) {
                p.privs.add(Privilege.CardTerminate);
            }
            if ((b1 & 4) == 4) {
                p.privs.add(Privilege.CardReset);
            }
            if ((b1 & 2) == 2) {
                p.privs.add(Privilege.CVMManagement);
            }
            if ((b1 & 0xC1) == 193) {
                p.privs.add(Privilege.MandatedDAPVerification);
            }
            if (data.length > 1) {
                int b3;
                int b2 = data[1] & 0xFF;
                if ((b2 & 0x80) == 128) {
                    p.privs.add(Privilege.TrustedPath);
                }
                if ((b2 & 0x40) == 64) {
                    p.privs.add(Privilege.AuthorizedManagement);
                }
                if ((b2 & 0x20) == 32) {
                    p.privs.add(Privilege.TokenVerification);
                }
                if ((b2 & 0x10) == 16) {
                    p.privs.add(Privilege.GlobalDelete);
                }
                if ((b2 & 8) == 8) {
                    p.privs.add(Privilege.GlobalLock);
                }
                if ((b2 & 4) == 4) {
                    p.privs.add(Privilege.GlobalRegistry);
                }
                if ((b2 & 2) == 2) {
                    p.privs.add(Privilege.FinalApplication);
                }
                if ((b2 & 1) == 1) {
                    p.privs.add(Privilege.GlobalService);
                }
                if (((b3 = data[2] & 0xFF) & 0x80) == 128) {
                    p.privs.add(Privilege.ReceiptGeneration);
                }
                if ((b3 & 0x40) == 64) {
                    p.privs.add(Privilege.CipheredLoadFileDataBlock);
                }
                if ((b3 & 0x20) == 32) {
                    p.privs.add(Privilege.ContactlessActivation);
                }
                if ((b3 & 0x10) == 16) {
                    p.privs.add(Privilege.ContactlessSelfActivation);
                }
                if ((b3 & 0xF) != 0) {
                    throw new GPDataException("RFU bits set in privileges!");
                }
            }
            return p;
        }

        public static Privileges fromByte(byte b) throws GPDataException {
            return Privileges.fromBytes(new byte[]{b});
        }

        public byte[] toBytes() {
            EnumSet<Privilege> p = EnumSet.copyOf(this.privs);
            int b1 = 0;
            if (p.remove((Object)Privilege.SecurityDomain)) {
                b1 |= 0x80;
            }
            if (p.remove((Object)Privilege.DAPVerification)) {
                b1 |= 0xC0;
            }
            if (p.remove((Object)Privilege.DelegatedManagement)) {
                b1 |= 0xA0;
            }
            if (p.remove((Object)Privilege.CardLock)) {
                b1 |= 0x10;
            }
            if (p.remove((Object)Privilege.CardTerminate)) {
                b1 |= 8;
            }
            if (p.remove((Object)Privilege.CardReset)) {
                b1 |= 4;
            }
            if (p.remove((Object)Privilege.CVMManagement)) {
                b1 |= 2;
            }
            if (p.remove((Object)Privilege.MandatedDAPVerification)) {
                b1 |= 0xC1;
            }
            if (p.isEmpty()) {
                return new byte[]{(byte)(b1 & 0xFF)};
            }
            int b2 = 0;
            if (p.remove((Object)Privilege.TrustedPath)) {
                b2 |= 0x80;
            }
            if (p.remove((Object)Privilege.AuthorizedManagement)) {
                b2 |= 0x40;
            }
            if (p.remove((Object)Privilege.TokenVerification)) {
                b2 |= 0x20;
            }
            if (p.remove((Object)Privilege.GlobalDelete)) {
                b2 |= 0x10;
            }
            if (p.remove((Object)Privilege.GlobalLock)) {
                b2 |= 8;
            }
            if (p.remove((Object)Privilege.GlobalRegistry)) {
                b2 |= 4;
            }
            if (p.remove((Object)Privilege.FinalApplication)) {
                b2 |= 2;
            }
            if (p.remove((Object)Privilege.GlobalService)) {
                b2 |= 1;
            }
            int b3 = 0;
            if (p.remove((Object)Privilege.ReceiptGeneration)) {
                b3 |= 0x80;
            }
            if (p.remove((Object)Privilege.CipheredLoadFileDataBlock)) {
                b3 |= 0x40;
            }
            if (p.remove((Object)Privilege.ContactlessActivation)) {
                b3 |= 0x20;
            }
            if (p.remove((Object)Privilege.ContactlessSelfActivation)) {
                b3 |= 0x10;
            }
            return new byte[]{(byte)(b1 & 0xFF), (byte)(b2 & 0xFF), (byte)(b3 & 0xFF)};
        }

        public byte toByte() {
            byte[] bytes = this.toBytes();
            if (bytes.length == 1) {
                return bytes[0];
            }
            throw new IllegalStateException("This privileges set can not be encoded in one byte");
        }

        public String toString() {
            return this.privs.stream().map(i -> i.toString()).collect(Collectors.joining(", "));
        }

        public boolean has(Privilege p) {
            return this.privs.contains((Object)p);
        }

        public void add(Privilege p) {
            this.privs.add(p);
        }

        public boolean isEmpty() {
            return this.privs.size() == 0;
        }
    }

    public static enum Privilege {
        SecurityDomain,
        DAPVerification,
        DelegatedManagement,
        CardLock,
        CardTerminate,
        CardReset,
        CVMManagement,
        MandatedDAPVerification,
        TrustedPath,
        AuthorizedManagement,
        TokenVerification,
        GlobalDelete,
        GlobalLock,
        GlobalRegistry,
        FinalApplication,
        GlobalService,
        ReceiptGeneration,
        CipheredLoadFileDataBlock,
        ContactlessActivation,
        ContactlessSelfActivation;


        public static Privilege lookup(String v) {
            for (Privilege d : Privilege.values()) {
                if (!d.name().equalsIgnoreCase(v)) continue;
                return d;
            }
            return null;
        }
    }

    public static enum Kind {
        IssuerSecurityDomain,
        Application,
        SecurityDomain,
        ExecutableLoadFile;


        public String toShortString() {
            switch (this) {
                case IssuerSecurityDomain: {
                    return "ISD";
                }
                case Application: {
                    return "APP";
                }
                case SecurityDomain: {
                    return "DOM";
                }
                case ExecutableLoadFile: {
                    return "PKG";
                }
            }
            throw new IllegalStateException("Unknown entry type");
        }
    }
}

