/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.spec.SecretKeySpec;
import pro.javacard.gp.GPCrypto;

public final class GPKey {
    private Type type;
    private int version = 0;
    private int id = 0;
    private int length = -1;
    private transient byte[] bytes = null;

    public GPKey(byte[] v, Type type) {
        if (v.length != 16 && v.length != 24 && v.length != 32) {
            throw new IllegalArgumentException("A valid key must be 16/24/32 bytes long");
        }
        this.bytes = Arrays.copyOf(v, v.length);
        this.length = v.length;
        this.type = type;
    }

    public GPKey(byte[] key) {
        this(key, Type.RAW);
    }

    public GPKey(int version, int id, GPKey other) {
        this(other.bytes, other.type);
        this.version = version;
        this.id = id;
    }

    public GPKey(int version, int id, int length, int type) {
        this.version = version;
        this.id = id;
        this.length = length;
        if (type == 128 || type == 129) {
            this.type = Type.DES3;
        } else if (type == 136) {
            this.type = Type.AES;
        } else {
            throw new UnsupportedOperationException("Only AES and 3DES are supported currently");
        }
    }

    private static byte[] resizeDES(byte[] key, int length) {
        if (length == 24) {
            byte[] key24 = new byte[24];
            System.arraycopy(key, 0, key24, 0, 16);
            System.arraycopy(key, 0, key24, 16, 8);
            return key24;
        }
        byte[] key8 = new byte[8];
        System.arraycopy(key, 0, key8, 0, 8);
        return key8;
    }

    public int getID() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public int getLength() {
        return this.length;
    }

    public Type getType() {
        return this.type;
    }

    public Key getKeyAs(Type type) {
        if (type == Type.DES) {
            return new SecretKeySpec(GPKey.resizeDES(this.bytes, 8), "DES");
        }
        if (type == Type.DES3) {
            return new SecretKeySpec(GPKey.resizeDES(this.bytes, 24), "DESede");
        }
        if (type == Type.AES) {
            return new SecretKeySpec(this.bytes, "AES");
        }
        throw new IllegalArgumentException("Can only create DES/3DES/AES keys");
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("version=" + this.version);
        s.append(" id=" + this.id);
        s.append(" type=" + (Object)((Object)this.type));
        if (this.bytes != null) {
            s.append(" bytes=" + HexUtils.bin2hex((byte[])this.bytes));
        } else {
            s.append(" len=" + this.length);
        }
        byte[] kcv = this.getKCV();
        if (kcv.length > 0) {
            s.append(" kcv=" + HexUtils.bin2hex((byte[])this.getKCV()));
        }
        return s.toString();
    }

    public byte[] getKCV() {
        if (this.type == Type.DES3) {
            return GPCrypto.kcv_3des(this);
        }
        if (this.type == Type.AES) {
            return GPCrypto.scp03_key_check_value(this);
        }
        return new byte[0];
    }

    public void become(Type t) {
        if (this.type != Type.RAW) {
            throw new IllegalStateException("Only RAW keys can become a new type");
        }
        this.type = t;
    }

    public static enum Type {
        RAW,
        DES,
        DES3,
        AES;

    }
}

