/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import javax.smartcardio.ResponseAPDU;
import pro.javacard.gp.GPData;

public class GPException
extends Exception {
    public final int sw;

    public GPException(int sw, String message) {
        super(message + ": " + GPData.sw2str(sw));
        this.sw = sw;
    }

    public GPException(String message) {
        super(message);
        this.sw = 0;
    }

    public GPException(String message, Throwable e) {
        super(message, e);
        this.sw = 0;
    }

    public static ResponseAPDU check(ResponseAPDU response, String message, int ... sws) throws GPException {
        for (int sw : sws) {
            if (response.getSW() != sw) continue;
            return response;
        }
        if (response.getSW() == 36864) {
            return response;
        }
        throw new GPException(response.getSW(), message);
    }

    public static ResponseAPDU check(ResponseAPDU response) throws GPException {
        return GPException.check(response, "GlobalPlatform failed", new int[0]);
    }
}

