/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import com.payneteasy.tlv.BerTag;
import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvLogger;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import com.payneteasy.tlv.IBerTlvLogger;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smartcardio.CardException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.GPDataException;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKey;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.GlobalPlatform;

public final class GPData {
    static final byte[] defaultKeyBytes = new byte[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    static final GPKey defaultKey = new GPKey(defaultKeyBytes, GPKey.Type.DES3);
    static final byte[] defaultISDBytes = HexUtils.hex2bin((String)"A000000151000000");
    public static final byte readyStatus = 1;
    public static final byte initializedStatus = 7;
    public static final byte securedStatus = 15;
    public static final byte lockedStatus = 127;
    public static final byte terminatedStatus = -1;
    @Deprecated
    public static final byte defaultSelectedPriv = 4;
    @Deprecated
    public static final byte cardLockPriv = 16;
    @Deprecated
    public static final byte cardTerminatePriv = 8;
    @Deprecated
    public static final byte securityDomainPriv = -128;
    static final Logger logger = LoggerFactory.getLogger(GPData.class);
    static final Map<Integer, String> sw = new HashMap<Integer, String>();

    @Deprecated
    public static IBerTlvLogger getLoggerInstance() {
        return new IBerTlvLogger(){

            public boolean isDebugEnabled() {
                return true;
            }

            public void debug(String s, Object ... objects) {
                logger.trace(s, objects);
            }
        };
    }

    public static String get_key_type_coding_string(int type) {
        if (0 <= type && type <= 127) {
            return "Reserved for private use";
        }
        if (128 == type) {
            return "DES - mode (ECB/CBC) implicitly known";
        }
        if (129 == type) {
            return "Reserved (Triple DES)";
        }
        if (130 == type) {
            return "Triple DES in CBC mode";
        }
        if (131 == type) {
            return "DES in ECB mode";
        }
        if (132 == type) {
            return "DES in CBC mode";
        }
        if (133 == type) {
            return "Pre-Shared Key for Transport Layer Security";
        }
        if (136 == type) {
            return "AES (16, 24, or 32 long keys)";
        }
        if (144 == type) {
            return "HMAC-SHA1 - length of HMAC is implicitly known";
        }
        if (145 == type) {
            return "MAC-SHA1-160 - length of HMAC is 160 bits";
        }
        if (type == 134 || type == 135 || 137 <= type && type <= 143 || 146 <= type && type <= 159) {
            return "RFU (asymmetric algorithms)";
        }
        if (160 == type) {
            return "RSA Public Key - public exponent e component (clear text)";
        }
        if (161 == type) {
            return "RSA Public Key - modulus N component (clear text)";
        }
        if (162 == type) {
            return "RSA Private Key - modulus N component";
        }
        if (163 == type) {
            return "RSA Private Key - private exponent d component";
        }
        if (164 == type) {
            return "RSA Private Key - Chinese Remainder P component";
        }
        if (165 == type) {
            return "RSA Private Key - Chinese Remainder Q component";
        }
        if (166 == type) {
            return "RSA Private Key - Chinese Remainder PQ component";
        }
        if (167 == type) {
            return "RSA Private Key - Chinese Remainder DP1 component";
        }
        if (168 == type) {
            return "RSA Private Key - Chinese Remainder DQ1 component";
        }
        if (169 <= type && type <= 254) {
            return "RFU (asymmetric algorithms)";
        }
        if (255 == type) {
            return "Extended Format";
        }
        return "UNKNOWN";
    }

    public static void pretty_print_key_template(List<GPKey> list, PrintStream out) {
        boolean factory_keys = false;
        out.flush();
        for (GPKey k : list) {
            out.println("VER:" + k.getVersion() + " ID:" + k.getID() + " TYPE:" + (Object)((Object)k.getType()) + " LEN:" + k.getLength());
            if (k.getVersion() != 0 && k.getVersion() != 255) continue;
            factory_keys = true;
        }
        if (factory_keys) {
            out.println("Key version suggests factory keys");
        }
        out.flush();
    }

    public static List<GPKey> get_key_template_list(byte[] data) throws GPException {
        ArrayList<GPKey> r = new ArrayList<GPKey>();
        BerTlvParser parser = new BerTlvParser();
        BerTlvs tlvs = parser.parse(data);
        BerTlvLogger.log((String)"    ", (BerTlvs)tlvs, (IBerTlvLogger)GPData.getLoggerInstance());
        BerTlv keys = tlvs.find(new BerTag(224));
        if (keys != null && keys.isConstructed()) {
            for (BerTlv key : keys.findAll(new BerTag(192))) {
                byte[] tmpl = key.getBytesValue();
                if (tmpl.length < 4) {
                    throw new GPDataException("Key info template shorter than 4 bytes", tmpl);
                }
                int id = tmpl[0] & 0xFF;
                int version = tmpl[1] & 0xFF;
                int type = tmpl[2] & 0xFF;
                int length = tmpl[3] & 0xFF;
                if (type == 255) {
                    throw new GPDataException("Extended key template not yet supported", tmpl);
                }
                r.add(new GPKey(version, id, length, type));
            }
        }
        return r;
    }

    public static void pretty_print_card_data(byte[] data) {
        BerTlvParser parser = new BerTlvParser();
        BerTlvs tlvs = parser.parse(data);
        BerTlvLogger.log((String)"    ", (BerTlvs)tlvs, (IBerTlvLogger)GPData.getLoggerInstance());
        BerTlv cd = tlvs.find(new BerTag(102));
        if (cd != null && cd.isConstructed()) {
            BerTlv isdd = tlvs.find(new BerTag(115));
            if (isdd != null) {
                for (BerTlv vt : isdd.getValues()) {
                    CharSequence[] p;
                    BerTlv ot = vt.find(new BerTag(6));
                    if (ot == null) continue;
                    String oid = GPData.oid2string(ot.getBytesValue());
                    System.out.println("Tag " + new BigInteger(1, vt.getTag().bytes).toString(16) + ": " + oid);
                    if (oid.equals("1.2.840.114283.1")) {
                        System.out.println("-> Global Platform card");
                    }
                    if (oid.startsWith("1.2.840.114283.2")) {
                        p = oid.substring("1.2.840.114283.2.".length()).split("\\.");
                        System.out.println("-> GP Version: " + String.join((CharSequence)".", p));
                    }
                    if (!oid.startsWith("1.2.840.114283.4")) continue;
                    p = oid.substring("1.2.840.114283.4.".length()).split("\\.");
                    if (p.length == 2) {
                        System.out.println("-> GP SCP0" + (String)p[0] + " i=" + String.format("%02x", Integer.valueOf((String)p[1])));
                        continue;
                    }
                    if (!oid.equals("1.2.840.114283.4.0")) continue;
                    System.out.println("-> GP SCP80 i=00");
                }
            }
        } else {
            System.out.println("No Card Data");
        }
    }

    public static void pretty_print_cplc(byte[] data, PrintStream out) {
        if (data == null) {
            out.println("NO CPLC");
            return;
        }
        CPLC cplc = CPLC.fromBytes(data);
        out.println(cplc);
    }

    public static void print_card_info(GlobalPlatform gp) throws CardException, GPException {
        GPData.pretty_print_cplc(gp.fetchCPLC(), System.out);
        gp.dumpCardProperties(System.out);
        System.out.println("***** CARD DATA");
        byte[] card_data = gp.fetchCardData();
        GPData.pretty_print_card_data(card_data);
        System.out.println("***** KEY INFO");
        GPData.pretty_print_key_template(gp.getKeyInfoTemplate(), System.out);
    }

    public static String sw2str(int sw) {
        String msg = GPData.sw.get(sw);
        if (msg == null) {
            return String.format("0x%04X", sw);
        }
        return String.format("0x%04X (%s)", sw, msg);
    }

    public static String oid2string(byte[] oid) {
        try {
            if (oid[0] != 6) {
                oid = GPUtils.concatenate({6, (byte)oid.length}, oid);
            }
            ASN1ObjectIdentifier realoid = (ASN1ObjectIdentifier)ASN1ObjectIdentifier.fromByteArray((byte[])oid);
            return realoid.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not handle " + HexUtils.bin2hex((byte[])oid));
        }
    }

    public static GlobalPlatform.GPSpec oid2version(byte[] bytes) throws GPDataException {
        String oid = GPData.oid2string(bytes);
        if (oid.equals("1.2.840.114283.2.2.1.1")) {
            return GlobalPlatform.GPSpec.GP211;
        }
        if (oid.equals("1.2.840.114283.2.2.2")) {
            return GlobalPlatform.GPSpec.GP22;
        }
        if (oid.equals("1.2.840.114283.2.2.2.1")) {
            return GlobalPlatform.GPSpec.GP22;
        }
        throw new GPDataException("Unknown GP version OID: " + oid, bytes);
    }

    static {
        sw.put(25600, "No specific diagnosis");
        sw.put(26368, "Wrong length (Lc)");
        sw.put(27904, "Invalid INStruction");
        sw.put(28160, "Invalid CLAss");
        sw.put(25219, "Card Life Cycle State is CARD_LOCKED");
        sw.put(25985, "Memory failure");
        sw.put(26754, "Secure messaging not supported");
        sw.put(27010, "Security status not satisfied");
        sw.put(27013, "Conditions of use not satisfied");
        sw.put(27264, "Wrong data/incorrect values in data");
        sw.put(27265, "Function not supported e.g. card Life Cycle State is CARD_LOCKED");
        sw.put(27266, "Application/file not found");
        sw.put(27268, "Not enough memory space");
        sw.put(27270, "Incorrect P1/P2");
        sw.put(27272, "Referenced data not found");
    }

    public static final class CPLC {
        private HashMap<Field, byte[]> values = null;

        private CPLC(byte[] data) {
            int offset = 3;
            this.values = new HashMap();
            this.values.put(Field.ICFabricator, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICType, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.OperatingSystemID, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.OperatingSystemReleaseDate, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.OperatingSystemReleaseLevel, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICFabricationDate, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICSerialNumber, Arrays.copyOfRange(data, offset, offset + 4));
            offset = (short)(offset + 4);
            this.values.put(Field.ICBatchIdentifier, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICModuleFabricator, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICModulePackagingDate, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICCManufacturer, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICEmbeddingDate, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICPrePersonalizer, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICPrePersonalizationEquipmentDate, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICPrePersonalizationEquipmentID, Arrays.copyOfRange(data, offset, offset + 4));
            offset = (short)(offset + 4);
            this.values.put(Field.ICPersonalizer, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICPersonalizationDate, Arrays.copyOfRange(data, offset, offset + 2));
            offset = (short)(offset + 2);
            this.values.put(Field.ICPersonalizationEquipmentID, Arrays.copyOfRange(data, offset, offset + 4));
            offset = (short)(offset + 4);
        }

        public static CPLC fromBytes(byte[] data) {
            if (data == null || data.length < 3 || data[2] != 42) {
                throw new IllegalArgumentException("CPLC MUST be 0x2A bytes long");
            }
            return new CPLC(data);
        }

        public byte[] get(Field f) {
            return this.values.get((Object)f);
        }

        public String toString() {
            return Arrays.asList(Field.values()).stream().map(i -> i.toString() + "=" + HexUtils.bin2hex((byte[])this.values.get(i))).collect(Collectors.joining(", ", "[CPLC ", "]"));
        }

        public static enum Field {
            ICFabricator,
            ICType,
            OperatingSystemID,
            OperatingSystemReleaseDate,
            OperatingSystemReleaseLevel,
            ICFabricationDate,
            ICSerialNumber,
            ICBatchIdentifier,
            ICModuleFabricator,
            ICModulePackagingDate,
            ICCManufacturer,
            ICEmbeddingDate,
            ICPrePersonalizer,
            ICPrePersonalizationEquipmentDate,
            ICPrePersonalizationEquipmentID,
            ICPersonalizer,
            ICPersonalizationDate,
            ICPersonalizationEquipmentID;

        }
    }
}

