/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Arrays;
import java.util.Vector;
import pro.javacard.CAPFile;
import pro.javacard.CAPFileSigner;
import pro.javacard.JavaCardSDK;
import pro.javacard.OffCardVerifier;
import pro.javacard.VerifierError;

public class CAPFileTool {
    private static boolean has(Vector<String> args, String v) {
        for (String s : args) {
            if (!s.equalsIgnoreCase(v)) continue;
            args.remove(s);
            return true;
        }
        return false;
    }

    public static void main(String[] argv) {
        Vector<String> args = new Vector<String>(Arrays.asList(argv));
        if (args.size() < 1) {
            System.err.println("Usage:");
            System.err.println("    capfile <capfile>");
            System.err.println("    capfile -v <sdkpath> <capfile>");
            System.err.println("    capfile -s <keyfile> <capfile>");
            System.exit(1);
        }
        try {
            if (CAPFileTool.has(args, "-s")) {
                if (args.size() < 2) {
                    CAPFileTool.fail("Usage:\n    capfile -s <keyfile> <capfile>");
                }
                String keyfile = args.remove(0);
                Path capfile = Paths.get(args.remove(0), new String[0]);
                CAPFile cap = CAPFile.fromBytes(Files.readAllBytes(capfile));
                cap.dump(System.out);
                try {
                    KeyPair kp = CAPFileSigner.pem2keypair(keyfile);
                    CAPFileSigner.addSignature(cap, kp.getPrivate());
                    Path where = capfile.getParent();
                    if (where == null) {
                        where = Paths.get(".", new String[0]);
                    }
                    Path tmpfile = Files.createTempFile(where, "capfile", "unsigned", new FileAttribute[0]);
                    cap.store(Files.newOutputStream(tmpfile, new OpenOption[0]));
                    Files.move(tmpfile, capfile, StandardCopyOption.ATOMIC_MOVE);
                    System.out.println("Signed " + capfile);
                }
                catch (GeneralSecurityException e) {
                    CAPFileTool.fail("Failed to sign: " + e.getMessage());
                }
            } else if (CAPFileTool.has(args, "-v")) {
                if (args.size() < 2) {
                    CAPFileTool.fail("Usage:\n    capfile -v <sdkpath> <capfile> [<expfiles...>]");
                }
                String sdkpath = args.remove(0);
                String capfile = args.remove(0);
                CAPFile cap = CAPFile.fromBytes(Files.readAllBytes(Paths.get(capfile, new String[0])));
                cap.dump(System.out);
                try {
                    JavaCardSDK sdk = JavaCardSDK.detectSDK(sdkpath);
                    OffCardVerifier verifier = OffCardVerifier.forSDK(sdk);
                    verifier.verify(new File(capfile));
                }
                catch (VerifierError e) {
                    CAPFileTool.fail("Verification failed: " + e.getMessage());
                }
            }
        }
        catch (IOException | IllegalArgumentException e) {
            CAPFileTool.fail(e.getMessage());
        }
    }

    private static void fail(String message) {
        System.err.println(message);
        System.exit(1);
    }
}

