/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import pro.javacard.AID;
import pro.javacard.CAPPackage;
import pro.javacard.HexUtils;
import pro.javacard.WellKnownAID;

public class CAPFile {
    public static final String DAP_RSA_V1_SHA1_FILE = "dap.rsa.sha1";
    public static final String DAP_RSA_V1_SHA256_FILE = "dap.rsa.sha256";
    private static final String[] componentNames = new String[]{"Header", "Directory", "Import", "Applet", "Class", "Method", "StaticField", "Export", "ConstantPool", "RefLocation", "Descriptor", "Debug"};
    final Map<String, byte[]> entries;
    private final Map<AID, String> applets;
    private final List<CAPPackage> imports;
    private CAPPackage pkg;
    private byte flags;
    private String cap_version;
    private Manifest manifest;
    private Document appletxml;

    public static CAPFile fromStream(InputStream in) throws IOException {
        return new CAPFile(in);
    }

    public static CAPFile fromBytes(byte[] bytes) throws IOException {
        return CAPFile.fromStream(new ByteArrayInputStream(bytes));
    }

    protected byte[] getComponent(String name) {
        return this.entries.get(CAPFile.pkg2jcdir(this.pkg.name) + name + ".cap");
    }

    public byte[] getMetaInfEntry(String name) {
        return this.entries.get("META-INF/" + name);
    }

    public void store(OutputStream to) throws IOException {
        try (ZipOutputStream out = new ZipOutputStream(to);){
            for (Map.Entry<String, byte[]> e : this.entries.entrySet()) {
                out.putNextEntry(new ZipEntry(e.getKey()));
                out.write(e.getValue());
                out.closeEntry();
            }
        }
    }

    protected CAPFile(InputStream in) throws IOException {
        byte[] imps;
        block25: {
            this.applets = new LinkedHashMap<AID, String>();
            this.imports = new ArrayList<CAPPackage>();
            this.manifest = null;
            this.appletxml = null;
            ZipInputStream zip = new ZipInputStream(in);
            Object object = null;
            try {
                byte[] ai;
                this.entries = this.readEntries(zip);
                byte[] mf = this.entries.get("META-INF/MANIFEST.MF");
                if (mf != null) {
                    ByteArrayInputStream mfi = new ByteArrayInputStream(mf);
                    this.manifest = new Manifest(mfi);
                }
                if ((ai = this.entries.get("APPLET-INF/applet.xml")) == null) break block25;
                try {
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    this.appletxml = dBuilder.parse(new ByteArrayInputStream(ai));
                    this.appletxml.getDocumentElement().normalize();
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new IOException(e);
                }
            }
            catch (Throwable mf) {
                object = mf;
                throw mf;
            }
            finally {
                if (zip != null) {
                    if (object != null) {
                        try {
                            zip.close();
                        }
                        catch (Throwable mf) {
                            ((Throwable)object).addSuppressed(mf);
                        }
                    } else {
                        zip.close();
                    }
                }
            }
        }
        String pkgname = null;
        for (String p : this.entries.keySet()) {
            if (!p.endsWith("Header.cap")) continue;
            pkgname = CAPFile.jcdir2pkg(p);
            break;
        }
        if (pkgname == null) {
            throw new IOException("Could not figure out the package name of the applet!");
        }
        byte[] header = this.entries.get(CAPFile.pkg2jcdir(pkgname) + "Header.cap");
        this.cap_version = String.format("%d.%d", header[8], header[7]);
        this.flags = header[9];
        this.pkg = new CAPPackage(new AID(header, 13, header[12]), header[11], header[10], pkgname);
        byte[] applet = this.getComponent("Applet");
        if (applet != null) {
            int offset = 4;
            for (int j = 0; j < (applet[3] & 0xFF); ++j) {
                byte len;
                AID appaid;
                if (!this.applets.containsKey(appaid = new AID(applet, offset, len = applet[offset++]))) {
                    this.applets.put(appaid, null);
                }
                offset += len + 2;
            }
        }
        if ((imps = this.getComponent("Import")) != null) {
            int offset = 4;
            for (int j = 0; j < (imps[3] & 0xFF); ++j) {
                AID aid = new AID(imps, offset + 3, imps[offset + 2]);
                CAPPackage p = new CAPPackage(aid, imps[offset + 1], imps[offset], WellKnownAID.getName(aid));
                this.imports.add(p);
                offset += imps[offset + 2] + 3;
            }
        }
        if (this.appletxml != null) {
            NodeList apps = this.appletxml.getElementsByTagName("applet");
            for (int i = 0; i < apps.getLength(); ++i) {
                Element app = (Element)apps.item(i);
                String name = app.getElementsByTagName("applet-class").item(0).getTextContent();
                String aidstring = app.getElementsByTagName("applet-AID").item(0).getTextContent();
                AID aid = AID.fromString(aidstring.replace("//aid/", "").replace("/", ""));
                if (!this.applets.containsKey(aid)) {
                    throw new IOException("applet.xml contains missing applet " + aid);
                }
                this.applets.put(aid, name);
            }
        }
    }

    private Map<String, byte[]> readEntries(ZipInputStream in) throws IOException {
        LinkedHashMap<String, byte[]> result = new LinkedHashMap<String, byte[]>();
        ZipEntry entry = in.getNextEntry();
        while (entry != null) {
            int c;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((c = in.read(buf)) != -1) {
                bos.write(buf, 0, c);
            }
            result.put(entry.getName(), bos.toByteArray());
            entry = in.getNextEntry();
        }
        return result;
    }

    public AID getPackageAID() {
        return this.pkg.aid;
    }

    public List<AID> getAppletAIDs() {
        ArrayList<AID> result = new ArrayList<AID>();
        result.addAll(this.applets.keySet());
        return result;
    }

    public String getPackageName() {
        return this.pkg.name;
    }

    public byte[] getCode(boolean includeDebug) {
        byte[] result = new byte[]{};
        for (String name : componentNames) {
            byte[] c = this.getComponent(name);
            if (c == null || !includeDebug && (name.equals("Debug") || name.equals("Descriptor"))) continue;
            result = CAPFile.concat(result, c);
        }
        return result;
    }

    public byte[] getLoadFileDataHash(String hash, boolean includeDebug) {
        try {
            return MessageDigest.getInstance(hash).digest(this.getCode(includeDebug));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Not possible", e);
        }
    }

    public void dump(PrintStream out) {
        String gpversion = this.guessGlobalPlatformVersion();
        gpversion = gpversion != null ? "/GlobalPlatform " + gpversion : "";
        out.println("CAP file (v" + this.cap_version + "), contains: " + String.join((CharSequence)", ", this.getFlags()) + " for JavaCard " + this.guessJavaCardVersion() + gpversion);
        out.println("Package: " + this.pkg);
        for (CAPPackage cAPPackage : this.getImports()) {
            out.println("Import: " + cAPPackage);
        }
        for (Map.Entry entry : this.getApplets().entrySet()) {
            out.println("Applet: " + (entry.getValue() == null ? "" : (String)entry.getValue() + " ") + entry.getKey());
        }
        if (this.manifest != null) {
            Attributes mains = this.manifest.getMainAttributes();
            Map<String, Attributes> map = this.manifest.getEntries();
            if (map.keySet().size() > 1) {
                throw new IllegalArgumentException("Too many elments in CAP");
            }
            Attributes caps = map.get(map.keySet().toArray()[0]);
            String jdk_name = mains.getValue("Created-By");
            String cap_creation_time = caps.getValue("Java-Card-CAP-Creation-Time");
            String converter_version = caps.getValue("Java-Card-Converter-Version");
            String converter_provider = caps.getValue("Java-Card-Converter-Provider");
            out.println("Generated by " + converter_provider + " converter " + converter_version);
            out.println("On " + cap_creation_time + " with JDK " + jdk_name);
        }
        out.println("Total code size: " + this.getCode(false).length + " bytes (" + this.getCode(true).length + " with debug)");
        out.println("SHA256 (code): " + HexUtils.bin2hex(this.getLoadFileDataHash("SHA-256", false)));
        out.println("SHA1   (code): " + HexUtils.bin2hex(this.getLoadFileDataHash("SHA-1", false)));
    }

    private List<String> getFlags() {
        ArrayList<String> result = new ArrayList<String>();
        if ((this.flags & 1) == 1) {
            result.add("integers");
        }
        if ((this.flags & 2) == 2) {
            result.add("exports");
        }
        if ((this.flags & 4) == 4) {
            result.add("applets");
        }
        return result;
    }

    public List<CAPPackage> getImports() {
        return this.imports;
    }

    public Map<AID, String> getApplets() {
        return this.applets;
    }

    public String guessJavaCardVersion() {
        AID jf = new AID("A0000000620101");
        for (CAPPackage p : this.imports) {
            if (!p.aid.equals(jf)) continue;
            switch (p.minor) {
                case 0: {
                    return "2.1.1";
                }
                case 1: {
                    return "2.1.2";
                }
                case 2: {
                    return "2.2.1";
                }
                case 3: {
                    return "2.2.2";
                }
                case 4: {
                    return "3.0.1";
                }
                case 5: {
                    return "3.0.4";
                }
                case 6: {
                    return "3.0.5";
                }
            }
            return String.format("unknown: %d.%d", p.major, p.minor);
        }
        return "2.1.1";
    }

    public String guessGlobalPlatformVersion() {
        AID jf = new AID("A00000015100");
        for (CAPPackage p : this.imports) {
            if (!p.aid.equals(jf) || p.major != 1) continue;
            if (p.minor == 0) {
                return "2.1.1";
            }
            if (p.minor >= 1 && p.minor <= 4) {
                return "2.2";
            }
            if (p.minor == 5) {
                return "2.2.1";
            }
            if (p.minor == 6) {
                return "2.3.1";
            }
            return String.format("unknown: %d.%d", p.major, p.minor);
        }
        return null;
    }

    private static String pkg2jcdir(String pkgname) {
        return pkgname.replace(".", "/") + "/javacard/";
    }

    private static String jcdir2pkg(String jcdir) {
        return jcdir.substring(0, jcdir.lastIndexOf("/javacard/")).replace('/', '.');
    }

    private static byte[] concat(byte[] a, byte[] b) {
        byte[] r = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, r, a.length, b.length);
        return r;
    }
}

