/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem.memory;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

final class MemoryURLConnection
extends URLConnection {
    MemoryURLConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            if (Files.notExists(this.getPath(), new LinkOption[0])) {
                throw new IOException("file does not exist");
            }
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (!this.doInput) {
            throw new IllegalStateException("input not supported");
        }
        Path path = this.getPath();
        return Files.newInputStream(path, new OpenOption[0]);
    }

    private Path getPath() throws IOException {
        Path path;
        try {
            path = Paths.get(this.url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException("invalid URI syntax", e);
        }
        return path;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.connect();
        if (!this.doOutput) {
            throw new IllegalStateException("input not supported");
        }
        Path path = this.getPath();
        return Files.newOutputStream(path, new OpenOption[0]);
    }

    @Override
    public long getContentLengthLong() {
        try {
            Path path = this.getPath();
            return Files.size(path);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public long getLastModified() {
        try {
            Path path = this.getPath();
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }
}

