/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AbstractPath;
import com.github.marschall.memoryfilesystem.EntryCreationContext;
import com.github.marschall.memoryfilesystem.MemoryEntry;
import com.github.marschall.memoryfilesystem.MemoryEntryAttributes;
import java.nio.file.attribute.BasicFileAttributeView;

class MemorySymbolicLink
extends MemoryEntry {
    private AbstractPath target;

    MemorySymbolicLink(String originalName, AbstractPath target, EntryCreationContext context) {
        super(originalName, context);
        this.target = target;
    }

    @Override
    MemoryEntryAttributes newMemoryEntryAttributes(EntryCreationContext context) {
        return new MemorySymbolicLAttributes(context);
    }

    AbstractPath getTarget() {
        return this.target;
    }

    void setTarget(AbstractPath target) {
        this.target = target;
    }

    public String toString() {
        return "symlink(" + this.getOriginalName() + ") -> " + this.target;
    }

    static final class MemorySymbolicLAttributes
    extends MemoryEntryAttributes {
        MemorySymbolicLAttributes(EntryCreationContext context) {
            super(context);
        }

        @Override
        BasicFileAttributeView newBasicFileAttributeView() {
            return new MemoryEntryAttributes.MemorySymbolicLinkAttributesView();
        }

        @Override
        long size() {
            return -1L;
        }
    }
}

