/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AbsolutePath;
import com.github.marschall.memoryfilesystem.AbstractPath;
import com.github.marschall.memoryfilesystem.AttributeAccessors;
import com.github.marschall.memoryfilesystem.AutoRelease;
import com.github.marschall.memoryfilesystem.AutoReleaseLock;
import com.github.marschall.memoryfilesystem.ClosedFileSystemChecker;
import com.github.marschall.memoryfilesystem.CurrentUser;
import com.github.marschall.memoryfilesystem.DefaultOpenOptions;
import com.github.marschall.memoryfilesystem.DirectoryChannel;
import com.github.marschall.memoryfilesystem.ElementPath;
import com.github.marschall.memoryfilesystem.EmptyPath;
import com.github.marschall.memoryfilesystem.EntryCreationContext;
import com.github.marschall.memoryfilesystem.FileAttributeViews;
import com.github.marschall.memoryfilesystem.FileSystemContext;
import com.github.marschall.memoryfilesystem.GlobPathMatcher;
import com.github.marschall.memoryfilesystem.LockType;
import com.github.marschall.memoryfilesystem.MemoryDirectory;
import com.github.marschall.memoryfilesystem.MemoryEntry;
import com.github.marschall.memoryfilesystem.MemoryFile;
import com.github.marschall.memoryfilesystem.MemoryFileStore;
import com.github.marschall.memoryfilesystem.MemoryFileSystemProvider;
import com.github.marschall.memoryfilesystem.MemorySymbolicLink;
import com.github.marschall.memoryfilesystem.MemoryUserPrincipalLookupService;
import com.github.marschall.memoryfilesystem.MemoryWatchKey;
import com.github.marschall.memoryfilesystem.Options;
import com.github.marschall.memoryfilesystem.PathParser;
import com.github.marschall.memoryfilesystem.RegexPathMatcher;
import com.github.marschall.memoryfilesystem.Root;
import com.github.marschall.memoryfilesystem.StringTransformer;
import com.github.marschall.memoryfilesystem.TwoPathOperation;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.channels.FileChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.spi.FileSystemProvider;
import java.text.Collator;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class MemoryFileSystem
extends FileSystem
implements FileSystemContext {
    private static final Set<String> UNSUPPORTED_INITIAL_ATTRIBUTES;
    private static final Set<OpenOption> NO_OPEN_OPTIONS;
    private static final FileAttribute<?>[] NO_FILE_ATTRIBUTES;
    private final String key;
    private final String separator;
    private final MemoryFileSystemProvider provider;
    private final MemoryFileStore store;
    private final Iterable<FileStore> stores;
    private final ClosedFileSystemChecker checker;
    private volatile Map<Root, MemoryDirectory> roots;
    private volatile Map<String, Root> rootByKey;
    private final ConcurrentMap<AbsolutePath, List<MemoryWatchKey>> watchKeys;
    private volatile AbstractPath defaultPath;
    private final MemoryUserPrincipalLookupService userPrincipalLookupService;
    private final PathParser pathParser;
    private final EmptyPath emptyPath;
    private final StringTransformer storeTransformer;
    private final StringTransformer lookUpTransformer;
    private final Collator collator;
    private final Set<Class<? extends FileAttributeView>> additionalViews;
    private final Set<String> supportedFileAttributeViews;
    private final ReadWriteLock pathOrderingLock;
    private final Set<PosixFilePermission> umask;
    private final TemporalUnit resolution;
    private final boolean supportFileChannelOnDirectory;

    MemoryFileSystem(String key, String separator, PathParser pathParser, MemoryFileSystemProvider provider, MemoryFileStore store, MemoryUserPrincipalLookupService userPrincipalLookupService, ClosedFileSystemChecker checker, StringTransformer storeTransformer, StringTransformer lookUpTransformer, Collator collator, Set<Class<? extends FileAttributeView>> additionalViews, Set<PosixFilePermission> umask, TemporalUnit resolution, boolean supportDirectoryFileChannelHack) {
        this.key = key;
        this.separator = separator;
        this.pathParser = pathParser;
        this.provider = provider;
        this.store = store;
        this.userPrincipalLookupService = userPrincipalLookupService;
        this.checker = checker;
        this.storeTransformer = storeTransformer;
        this.lookUpTransformer = lookUpTransformer;
        this.collator = collator;
        this.additionalViews = additionalViews;
        this.umask = umask;
        this.resolution = resolution;
        this.supportFileChannelOnDirectory = supportDirectoryFileChannelHack;
        this.stores = Collections.singletonList(store);
        this.watchKeys = new ConcurrentHashMap<AbsolutePath, List<MemoryWatchKey>>(1);
        this.emptyPath = new EmptyPath(this);
        this.supportedFileAttributeViews = this.buildSupportedFileAttributeViews(additionalViews);
        this.pathOrderingLock = new ReentrantReadWriteLock();
    }

    private Set<String> buildSupportedFileAttributeViews(Set<Class<? extends FileAttributeView>> additionalViews) {
        if (additionalViews.isEmpty()) {
            return Collections.singleton("basic");
        }
        HashSet<String> views = new HashSet<String>(additionalViews.size() + 2);
        views.add("basic");
        for (Class<? extends FileAttributeView> viewClass : additionalViews) {
            if (FileOwnerAttributeView.class.isAssignableFrom(viewClass)) {
                views.add("owner");
            }
            if (viewClass == FileOwnerAttributeView.class) continue;
            views.add(FileAttributeViews.mapAttributeView(viewClass));
        }
        return Collections.unmodifiableSet(views);
    }

    String getKey() {
        return this.key;
    }

    Set<PosixFilePermission> getUmask() {
        return this.umask;
    }

    EntryCreationContext newEntryCreationContext(Path path, FileAttribute<?>[] attributes) throws IOException {
        Set<PosixFilePermission> permissions = EnumSet.allOf(PosixFilePermission.class);
        for (FileAttribute<?> attribute : attributes) {
            if (!(attribute instanceof PosixFileAttributes)) continue;
            permissions = ((PosixFileAttributes)((Object)attribute)).permissions();
            break;
        }
        UserPrincipal user = this.getCurrentUser();
        GroupPrincipal group = this.getGroupOf(user);
        return new EntryCreationContext(this.additionalViews, permissions, user, group, this, path);
    }

    private UserPrincipal getCurrentUser() {
        UserPrincipal currentUser = CurrentUser.get();
        if (currentUser != null) {
            return currentUser;
        }
        return this.userPrincipalLookupService.getDefaultUser();
    }

    private GroupPrincipal getGroupOf(UserPrincipal user) throws IOException {
        return this.userPrincipalLookupService.lookupPrincipalByGroupName(user.getName());
    }

    EmptyPath getEmptyPath() {
        return this.emptyPath;
    }

    void setRootDirectories(Map<Root, MemoryDirectory> rootDirectories) {
        this.roots = rootDirectories;
        this.rootByKey = this.buildRootsByKey(rootDirectories.keySet());
    }

    private Map<String, Root> buildRootsByKey(Collection<Root> rootDirectories) {
        if (rootDirectories.isEmpty()) {
            throw new IllegalArgumentException("a file system root must be present");
        }
        if (rootDirectories.size() == 1) {
            Root root = rootDirectories.iterator().next();
            String key = this.lookUpTransformer.transform(root.getKey());
            return Collections.singletonMap(key, root);
        }
        HashMap<String, Root> map = new HashMap<String, Root>(rootDirectories.size());
        for (Root root : rootDirectories) {
            String key = this.lookUpTransformer.transform(root.getKey());
            map.put(key, root);
        }
        return map;
    }

    void setCurrentWorkingDirectory(String currentWorkingDirectory) {
        this.defaultPath = this.getPath(currentWorkingDirectory, new String[0]);
        if (!this.defaultPath.isAbsolute()) {
            throw new IllegalArgumentException("current working directory must be absolute");
        }
    }

    AbstractPath getDefaultPath() {
        return this.defaultPath;
    }

    FileChannel newFileChannel(AbstractPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        this.checker.check();
        MemoryEntry entry = this.getEntry(path, options, attrs);
        if (entry instanceof MemoryFile) {
            return ((MemoryFile)entry).newChannel(options, path);
        }
        if (entry instanceof MemoryDirectory) {
            boolean isRead = options.contains(StandardOpenOption.READ);
            boolean isWrite = options.contains(StandardOpenOption.WRITE);
            if (this.supportFileChannelOnDirectory && isRead && !isWrite) {
                return new DirectoryChannel();
            }
        }
        throw new FileSystemException(path.toAbsolutePath().toString(), null, "is not a file");
    }

    private static Set<OpenOption> toOptionSet(Set<OpenOption> defaultOptions, OpenOption ... options) {
        if (options == null || options.length == 0) {
            return defaultOptions;
        }
        HashSet<OpenOption> optionsSet = new HashSet<OpenOption>(options.length);
        Collections.addAll(optionsSet, options);
        return optionsSet;
    }

    InputStream newInputStream(AbstractPath path, OpenOption ... options) throws IOException {
        this.checker.check();
        Set<OpenOption> optionsSet = MemoryFileSystem.toOptionSet(Collections.emptySet(), options);
        MemoryFile file = this.getFile(path, optionsSet, new FileAttribute[0]);
        return file.newInputStream(optionsSet, (Path)path);
    }

    OutputStream newOutputStream(AbstractPath path, OpenOption ... options) throws IOException {
        this.checker.check();
        Set<OpenOption> optionsSet = MemoryFileSystem.toOptionSet(DefaultOpenOptions.INSTANCE, options);
        MemoryFile file = this.getFile(path, optionsSet, new FileAttribute[0]);
        return file.newOutputStream(optionsSet, (Path)path);
    }

    private static void checkSupportedInitialAttributes(FileAttribute<?> ... attrs) {
        if (attrs != null) {
            for (FileAttribute<?> attribute : attrs) {
                String attributeName = attribute.name();
                if (!UNSUPPORTED_INITIAL_ATTRIBUTES.contains(attributeName)) continue;
                throw new UnsupportedOperationException("'" + attributeName + "' not supported as initial attribute");
            }
        }
    }

    private GetEntryResult getEntry(final AbstractPath path, final Set<? extends OpenOption> options, FileAttribute<?>[] attrs, final boolean followSymLinks, final Set<MemorySymbolicLink> encounteredSymlinks) throws IOException {
        final FileAttribute[] newAttributes = this.applyUmask(attrs);
        final AbstractPath absolutePath = (AbstractPath)path.toAbsolutePath().normalize();
        MemoryDirectory rootDirectory = this.getRootDirectory(absolutePath);
        if (absolutePath.isRoot()) {
            return new GetEntryResult(rootDirectory);
        }
        final AbstractPath parent = (AbstractPath)absolutePath.getParent();
        return this.withWriteLockOnLastDo(rootDirectory, parent, followSymLinks, encounteredSymlinks, new MemoryDirectoryBlock<GetEntryResult>(){

            @Override
            public GetEntryResult value(MemoryDirectory directory) throws IOException {
                ElementPath elementPath = (ElementPath)absolutePath;
                boolean isCreateNew = options.contains(StandardOpenOption.CREATE_NEW);
                String fileName = elementPath.getLastNameElement();
                String key = MemoryFileSystem.this.lookUpTransformer.transform(fileName);
                EntryCreationContext creationContext = MemoryFileSystem.this.newEntryCreationContext(absolutePath, newAttributes);
                if (isCreateNew) {
                    MemoryFile file = this.createEntryOnAccess(path, newAttributes, directory, elementPath, creationContext);
                    return new GetEntryResult(file);
                }
                MemoryEntry storedEntry = directory.getEntry(key);
                if (storedEntry == null) {
                    boolean isCreate = options.contains(StandardOpenOption.CREATE);
                    if (isCreate) {
                        MemoryFile file = this.createEntryOnAccess(path, newAttributes, directory, elementPath, creationContext);
                        return new GetEntryResult(file);
                    }
                    throw new NoSuchFileException(path.toString());
                }
                if (storedEntry instanceof MemorySymbolicLink && followSymLinks) {
                    MemorySymbolicLink link = (MemorySymbolicLink)storedEntry;
                    if (!encounteredSymlinks.add(link)) {
                        throw new FileSystemLoopException(path.toString());
                    }
                    AbstractPath linkTarget = link.getTarget();
                    if (linkTarget.isAbsolute()) {
                        return new GetEntryResult(linkTarget);
                    }
                    return new GetEntryResult((AbstractPath)parent.resolve(linkTarget));
                }
                return new GetEntryResult(storedEntry);
            }

            private MemoryFile createEntryOnAccess(AbstractPath path2, FileAttribute<?>[] newAttributes2, MemoryDirectory directory, ElementPath elementPath, EntryCreationContext creationContext) throws IOException {
                String fileName = elementPath.getLastNameElement();
                String key = MemoryFileSystem.this.lookUpTransformer.transform(fileName);
                String name = MemoryFileSystem.this.storeTransformer.transform(fileName);
                MemoryFile file = new MemoryFile(name, creationContext);
                MemoryFileSystem.checkSupportedInitialAttributes(newAttributes2);
                AttributeAccessors.setAttributes(file, newAttributes2);
                directory.checkAccess(AccessMode.WRITE);
                directory.addEntry(key, file, path2);
                return file;
            }
        });
    }

    private MemoryFile getFile(AbstractPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        MemoryEntry file = this.getEntry(path, options, new FileAttribute[0]);
        if (file instanceof MemoryFile) {
            return (MemoryFile)file;
        }
        throw new FileSystemException(path.toString().toString(), null, "is not a file");
    }

    private MemoryEntry getEntry(AbstractPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        boolean followSymLinks = Options.isFollowSymLinks(options);
        Set<MemorySymbolicLink> encounteredSymlinks = followSymLinks ? new HashSet(4) : Collections.emptySet();
        GetEntryResult result = this.getEntry(path, options, attrs, followSymLinks, encounteredSymlinks);
        while (result.entry == null) {
            result = this.getEntry(result.linkTarget, options, attrs, followSymLinks, encounteredSymlinks);
        }
        return result.entry;
    }

    private FileAttribute<?>[] applyUmask(FileAttribute<?>[] attributes) {
        if (this.umask.isEmpty()) {
            return attributes;
        }
        int length = attributes.length;
        boolean changed = false;
        FileAttribute[] copy = null;
        for (int i = 0; i < length; ++i) {
            FileAttribute<?> attribute = attributes[i];
            if (changed) {
                copy[i] = attribute;
                continue;
            }
            if (!"posix:permissions".equals(attribute.name())) continue;
            copy = new FileAttribute[length];
            changed = true;
            if (i > 0) {
                System.arraycopy(attributes, 0, copy, 0, i - 1);
            }
            Set perms = (Set)attribute.value();
            EnumSet<PosixFilePermission> newPerms = EnumSet.copyOf(perms);
            newPerms.removeAll(this.umask);
            copy[i] = PosixFilePermissions.asFileAttribute(newPerms);
        }
        if (changed) {
            return copy;
        }
        FileAttribute[] withPermissions = new FileAttribute[length + 1];
        System.arraycopy(attributes, 0, withPermissions, 0, length);
        EnumSet<PosixFilePermission> permissions = EnumSet.allOf(PosixFilePermission.class);
        permissions.removeAll(this.umask);
        withPermissions[length] = PosixFilePermissions.asFileAttribute(permissions);
        return withPermissions;
    }

    DirectoryStream<Path> newDirectoryStream(AbstractPath abstractPath, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.accessFileReading(abstractPath, false, entry -> {
            if (!(entry instanceof MemoryDirectory)) {
                throw new NotDirectoryException(abstractPath.toString());
            }
            MemoryDirectory directory = (MemoryDirectory)entry;
            return directory.newDirectoryStream(abstractPath, filter);
        });
    }

    void createDirectory(AbstractPath path, FileAttribute<?> ... attrs) throws IOException {
        FileAttribute[] masked = this.applyUmask(attrs);
        this.createFile(path, name -> {
            EntryCreationContext context = this.newEntryCreationContext(path, masked);
            MemoryDirectory directory = new MemoryDirectory(name, context);
            AttributeAccessors.setAttributes(directory, masked);
            return directory;
        });
    }

    void createSymbolicLink(AbstractPath link, AbstractPath target, FileAttribute<?> ... attrs) throws IOException {
        FileAttribute[] masked = this.applyUmask(attrs);
        this.createFile(link, name -> {
            EntryCreationContext context = this.newEntryCreationContext(link, masked);
            MemorySymbolicLink symbolicLink = new MemorySymbolicLink(name, target, context);
            AttributeAccessors.setAttributes(symbolicLink, masked);
            return symbolicLink;
        });
    }

    void createLink(AbstractPath link, AbstractPath existing) throws IOException {
        MemoryFile existingFile = this.getFile(existing);
        if (existingFile == null) {
            throw new FileSystemException(link.toString(), existing.toString(), "hard links are only supported for regular files");
        }
        this.createFile(link, name -> {
            EntryCreationContext context = this.newEntryCreationContext(link, NO_FILE_ATTRIBUTES);
            return existingFile.createLink(name, context);
        });
    }

    boolean isSameFile(AbstractPath path, AbstractPath path2) throws IOException {
        MemoryFile file = this.getFile(path);
        if (file == null) {
            return false;
        }
        MemoryFile file2 = this.getFile(path2);
        if (file2 == null) {
            return false;
        }
        return file.hasSameInodeAs(file2);
    }

    private MemoryFile getFile(AbstractPath existing) throws IOException {
        return this.accessFileReading(existing, true, entry -> {
            if (entry instanceof MemoryFile) {
                return (MemoryFile)entry;
            }
            return null;
        });
    }

    private void createFile(AbstractPath path, MemoryEntryCreator creator) throws IOException {
        this.checker.check();
        AbstractPath absolutePath = (AbstractPath)path.toAbsolutePath().normalize();
        if (absolutePath.isRoot()) {
            throw new FileAlreadyExistsException(path.toString(), null, "can not create root");
        }
        ElementPath elementPath = (ElementPath)absolutePath;
        this.accessDirectoryWriting((AbstractPath)elementPath.getParent(), true, directory -> {
            String name = this.storeTransformer.transform(elementPath.getLastNameElement());
            MemoryEntry newEntry = creator.create(name);
            String key = this.lookUpTransformer.transform(newEntry.getOriginalName());
            directory.checkAccess(AccessMode.WRITE);
            directory.addEntry(key, newEntry, path);
            return null;
        });
    }

    AbstractPath toRealPath(AbstractPath abstractPath, LinkOption ... options) throws IOException {
        this.checker.check();
        AbstractPath absolutePath = (AbstractPath)abstractPath.toAbsolutePath().normalize();
        boolean followSymLinks = Options.isFollowSymLinks(options);
        Set<MemorySymbolicLink> encounteredSymlinks = followSymLinks ? new HashSet(4) : Collections.emptySet();
        MemoryDirectory root = this.getRootDirectory(absolutePath);
        return this.toRealPath(root, absolutePath, encounteredSymlinks, followSymLinks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractPath toRealPath(MemoryDirectory root, AbstractPath path, Set<MemorySymbolicLink> encounteredLinks, boolean followSymLinks) throws IOException {
        if (path.isRoot()) {
            return (AbstractPath)path.getRoot();
        }
        if (path instanceof ElementPath) {
            ElementPath elementPath = (ElementPath)path;
            List<String> nameElements = elementPath.getNameElements();
            int pathElementCount = nameElements.size();
            ArrayList<String> realPath = new ArrayList<String>(pathElementCount);
            ArrayList<AutoRelease> locks = new ArrayList<AutoRelease>(pathElementCount + 1);
            try {
                locks.add(root.readLock());
                MemoryDirectory parent = root;
                for (int i = 0; i < pathElementCount; ++i) {
                    String fileName = nameElements.get(i);
                    String key = this.lookUpTransformer.transform(fileName);
                    MemoryEntry current = parent.getEntryOrException(key, path);
                    locks.add(current.readLock());
                    realPath.add(current.getOriginalName());
                    if (followSymLinks && current instanceof MemorySymbolicLink) {
                        int j;
                        Path newLookUpPath;
                        MemorySymbolicLink link = (MemorySymbolicLink)current;
                        if (!encounteredLinks.add(link)) {
                            throw new FileSystemLoopException(path.toString());
                        }
                        AbstractPath symLinkTarget = link.getTarget();
                        if (symLinkTarget.isAbsolute()) {
                            newLookUpPath = symLinkTarget;
                        } else {
                            newLookUpPath = path.getRoot();
                            for (j = 0; j < i; ++j) {
                                newLookUpPath = newLookUpPath.resolve(nameElements.get(j));
                            }
                            newLookUpPath = newLookUpPath.resolve(symLinkTarget);
                        }
                        for (j = i + 1; j < pathElementCount; ++j) {
                            newLookUpPath = newLookUpPath.resolve(nameElements.get(j));
                        }
                        AbstractPath abstractPath = this.toRealPath(root, (AbstractPath)newLookUpPath, encounteredLinks, followSymLinks);
                        return abstractPath;
                    }
                    if (current instanceof MemoryDirectory) {
                        parent = (MemoryDirectory)current;
                        continue;
                    }
                    if (i >= pathElementCount - 1) continue;
                    throw new NotDirectoryException(path.toString());
                }
            }
            finally {
                for (int i = locks.size() - 1; i >= 0; --i) {
                    AutoRelease lock = (AutoRelease)locks.get(i);
                    lock.close();
                }
            }
            return AbstractPath.createAbsolute(this, (Root)path.getRoot(), realPath);
        }
        throw new IllegalArgumentException("unknown path type" + path);
    }

    void checkAccess(AbstractPath path, AccessMode ... modes) throws IOException {
        this.checker.check();
        this.accessFileReading(path, true, entry -> {
            entry.checkAccess(modes);
            return null;
        });
    }

    <A extends BasicFileAttributes> A readAttributes(AbstractPath path, Class<A> type, LinkOption ... options) throws IOException {
        this.checker.check();
        return (A)this.accessFileReading(path, Options.isFollowSymLinks(options), entry -> entry.readAttributes(type));
    }

    <V extends FileAttributeView> V getLazyFileAttributeView(AbstractPath path, Class<V> type, LinkOption ... options) {
        if (type != BasicFileAttributeView.class && !this.additionalViews.contains(type)) {
            return null;
        }
        LazyFileAttributeView handler = new LazyFileAttributeView(path, type, options);
        Object proxy = Proxy.newProxyInstance(MemoryFileSystem.class.getClassLoader(), new Class[]{type}, (InvocationHandler)handler);
        return (V)((FileAttributeView)type.cast(proxy));
    }

    <V extends FileAttributeView> V getFileAttributeView(AbstractPath path, Class<V> type, LinkOption ... options) throws IOException {
        return (V)this.accessFileReading(path, Options.isFollowSymLinks(options), entry -> entry.getFileAttributeView(type));
    }

    Map<String, Object> readAttributes(AbstractPath path, String attributes, LinkOption ... options) throws IOException {
        this.checker.check();
        return this.accessFileReading(path, Options.isFollowSymLinks(options), entry -> AttributeAccessors.readAttributes(entry, attributes));
    }

    void setAttribute(AbstractPath path, String attribute, Object value, LinkOption ... options) throws IOException {
        this.checker.check();
        this.accessFileWriting(path, Options.isFollowSymLinks(options), entry -> {
            AttributeAccessors.setAttribute(entry, attribute, value);
            return null;
        });
    }

    private <R> R accessFileReading(AbstractPath path, boolean followSymLinks, MemoryEntryBlock<? extends R> callback) throws IOException {
        return this.accessFile(path, followSymLinks, LockType.READ, callback);
    }

    private <R> R accessFileWriting(AbstractPath path, boolean followSymLinks, MemoryEntryBlock<? extends R> callback) throws IOException {
        return this.accessFile(path, followSymLinks, LockType.WRITE, callback);
    }

    private <R> R accessFile(AbstractPath path, boolean followSymLinks, LockType lockType, MemoryEntryBlock<? extends R> callback) throws IOException {
        this.checker.check();
        AbstractPath absolutePath = (AbstractPath)path.toAbsolutePath().normalize();
        MemoryDirectory root = this.getRootDirectory(absolutePath);
        Set<MemorySymbolicLink> encounteredSymlinks = followSymLinks ? new HashSet(4) : Collections.emptySet();
        return this.withLockDo(root, absolutePath, encounteredSymlinks, followSymLinks, lockType, callback);
    }

    private <R> R withWriteLockOnLastDo(MemoryDirectory root, AbstractPath path, boolean followSymLinks, MemoryDirectoryBlock<R> callback) throws IOException {
        Set<MemorySymbolicLink> encounteredSymlinks = followSymLinks ? new HashSet(4) : Collections.emptySet();
        return this.withWriteLockOnLastDo(root, path, followSymLinks, encounteredSymlinks, callback);
    }

    private <R> R withWriteLockOnLastDo(MemoryDirectory root, AbstractPath path, boolean followSymLinks, Set<MemorySymbolicLink> encounteredSymlinks, MemoryDirectoryBlock<R> callback) throws IOException {
        return (R)this.withLockDo(root, path, encounteredSymlinks, followSymLinks, LockType.WRITE, entry -> {
            if (!(entry instanceof MemoryDirectory)) {
                throw new NotDirectoryException(path.toString());
            }
            return callback.value((MemoryDirectory)entry);
        });
    }

    private <R> R accessDirectoryWriting(AbstractPath path, boolean followSymLinks, MemoryDirectoryBlock<R> callback) throws IOException {
        return (R)this.accessFileWriting(path, followSymLinks, entry -> {
            if (!(entry instanceof MemoryDirectory)) {
                throw new NotDirectoryException(path.toString());
            }
            return callback.value((MemoryDirectory)entry);
        });
    }

    private <R> R withReadLockDo(MemoryDirectory root, AbstractPath path, boolean followSymLinks, MemoryEntryBlock<? extends R> callback) throws IOException {
        Set<MemorySymbolicLink> encounteredSymlinks = followSymLinks ? new HashSet(4) : Collections.emptySet();
        return this.withLockDo(root, path, encounteredSymlinks, followSymLinks, LockType.READ, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R withLockDo(MemoryDirectory root, AbstractPath path, Set<MemorySymbolicLink> encounteredLinks, boolean followSymLinks, LockType lockType, MemoryEntryBlock<? extends R> callback) throws IOException {
        if (path.isRoot()) {
            try (AutoRelease lock = root.lock(lockType);){
                R r = callback.value(root);
                return r;
            }
        }
        if (path instanceof ElementPath) {
            R result = null;
            Path newLookUpPath = null;
            ElementPath elementPath = (ElementPath)path;
            List<String> nameElements = elementPath.getNameElements();
            int pathElementCount = nameElements.size();
            ArrayList<AutoRelease> locks = new ArrayList<AutoRelease>(pathElementCount + 1);
            try {
                locks.add(root.readLock());
                MemoryDirectory parent = root;
                for (int i = 0; i < pathElementCount; ++i) {
                    boolean isLast;
                    String fileName = nameElements.get(i);
                    String key = this.lookUpTransformer.transform(fileName);
                    MemoryEntry current = parent.getEntryOrException(key, path);
                    boolean bl = isLast = i == pathElementCount - 1;
                    if (isLast) {
                        locks.add(current.lock(lockType));
                    } else {
                        locks.add(current.readLock());
                    }
                    if (followSymLinks && current instanceof MemorySymbolicLink) {
                        int j;
                        MemorySymbolicLink link = (MemorySymbolicLink)current;
                        if (!encounteredLinks.add(link)) {
                            throw new FileSystemLoopException(path.toString());
                        }
                        AbstractPath symLinkTarget = link.getTarget();
                        if (symLinkTarget.isAbsolute()) {
                            newLookUpPath = symLinkTarget;
                        } else {
                            newLookUpPath = path.getRoot();
                            for (j = 0; j < i; ++j) {
                                newLookUpPath = newLookUpPath.resolve(nameElements.get(j));
                            }
                            newLookUpPath = newLookUpPath.resolve(symLinkTarget);
                        }
                        for (j = i + 1; j < pathElementCount; ++j) {
                            newLookUpPath = newLookUpPath.resolve(nameElements.get(j));
                        }
                        break;
                    }
                    if (isLast) {
                        result = callback.value(current);
                        continue;
                    }
                    if (current instanceof MemoryDirectory) {
                        parent = (MemoryDirectory)current;
                        continue;
                    }
                    throw new NotDirectoryException(path.toString());
                }
            }
            finally {
                for (int i = locks.size() - 1; i >= 0; --i) {
                    AutoRelease lock = (AutoRelease)locks.get(i);
                    lock.close();
                }
            }
            if (newLookUpPath == null) {
                return result;
            }
            return this.withLockDo(root, (AbstractPath)newLookUpPath, encounteredLinks, followSymLinks, lockType, callback);
        }
        throw new IllegalArgumentException("unknown path type" + path);
    }

    private MemoryDirectory getRootDirectory(AbstractPath path) throws IOException {
        Path root = path.getRoot();
        MemoryDirectory directory = this.roots.get(root);
        if (directory == null) {
            throw new NoSuchFileException(path.toString(), null, "the root doesn't exist");
        }
        return directory;
    }

    void copyOrMove(AbstractPath source, AbstractPath target, TwoPathOperation operation, CopyOption ... options) throws IOException {
        try (AutoRelease autoRelease = AutoReleaseLock.autoRelease(this.pathOrderingLock.writeLock());){
            EndPointCopyContext sourceContext = this.buildEndpointCopyContext(source);
            EndPointCopyContext targetContext = this.buildEndpointCopyContext(target);
            int order = this.orderPaths(sourceContext, targetContext);
            CopyContext copyContext = MemoryFileSystem.buildCopyContext(sourceContext, targetContext, operation, options, order);
            AbstractPath firstParent = copyContext.first.parent;
            AbstractPath secondParent = copyContext.second.parent;
            if (firstParent == null && secondParent == null) {
                return;
            }
            if (firstParent == null || secondParent == null) {
                throw new FileSystemException(MemoryFileSystem.toStringOrNull(firstParent), MemoryFileSystem.toStringOrNull(secondParent), "can't copy or move root directory");
            }
            MemoryDirectory firstRoot = this.getRootDirectory(copyContext.first.path);
            MemoryDirectory secondRoot = this.getRootDirectory(copyContext.second.path);
            this.withWriteLockOnLastDo(firstRoot, firstParent, copyContext.firstFollowSymLinks, firstDirectory -> {
                this.withWriteLockOnLastDo(secondRoot, secondParent, copyContext.secondFollowSymLinks, secondDirectory -> {
                    MemoryFileSystem.handleTwoPathOperation(copyContext, firstDirectory, secondDirectory);
                    return null;
                });
                return null;
            });
        }
    }

    static void copyOrMoveBetweenFileSystems(MemoryFileSystem sourceFileSystem, MemoryFileSystem targetFileSystem, AbstractPath source, AbstractPath target, TwoPathOperation operation, CopyOption ... options) throws IOException {
        EndPointCopyContext sourceContext = sourceFileSystem.buildEndpointCopyContext(source);
        EndPointCopyContext targetContext = targetFileSystem.buildEndpointCopyContext(target);
        int order = MemoryFileSystem.orderFileSystems(sourceContext, targetContext);
        CopyContext copyContext = MemoryFileSystem.buildCopyContext(sourceContext, targetContext, operation, options, order);
        AbstractPath firstParent = copyContext.first.parent;
        AbstractPath secondParent = copyContext.second.parent;
        if (firstParent == null || secondParent == null) {
            throw new FileSystemException(MemoryFileSystem.toStringOrNull(firstParent), MemoryFileSystem.toStringOrNull(secondParent), "can't move ore copy the file system root");
        }
        MemoryDirectory firstRoot = sourceFileSystem.getRootDirectory(copyContext.first.path);
        MemoryDirectory secondRoot = targetFileSystem.getRootDirectory(copyContext.second.path);
        copyContext.first.path.getMemoryFileSystem().withWriteLockOnLastDo(firstRoot, firstParent, copyContext.firstFollowSymLinks, firstDirectory -> {
            copyContext.second.path.getMemoryFileSystem().withWriteLockOnLastDo(secondRoot, secondParent, copyContext.secondFollowSymLinks, secondDirectory -> {
                MemoryFileSystem.handleTwoPathOperation(copyContext, firstDirectory, secondDirectory);
                return null;
            });
            return null;
        });
    }

    private static String toStringOrNull(AbstractPath path) {
        return Objects.toString(path, null);
    }

    private int orderPaths(EndPointCopyContext source, EndPointCopyContext target) {
        int parentOrder = source.parent == null ? (target.parent == null ? 0 : -1) : (target.parent == null ? 1 : source.parent.compareTo(target.parent));
        if (parentOrder != 0) {
            return parentOrder;
        }
        if (source.elementName == null) {
            return target.elementName == null ? 0 : -1;
        }
        if (target.elementName == null) {
            return 1;
        }
        return this.collator.compare(source.elementName, target.elementName);
    }

    private static int orderFileSystems(EndPointCopyContext source, EndPointCopyContext target) {
        String targetKey;
        MemoryFileSystem sourceFileSystem = source.path.getMemoryFileSystem();
        MemoryFileSystem targetFileSystem = target.path.getMemoryFileSystem();
        String sourceKey = sourceFileSystem.getKey();
        int comparison = sourceKey.compareTo(targetKey = targetFileSystem.getKey());
        if (comparison != 0) {
            return comparison;
        }
        throw new AssertionError((Object)("the two file system keys " + sourceKey + " and " + targetKey + " compare equal."));
    }

    private EndPointCopyContext buildEndpointCopyContext(AbstractPath path) {
        AbstractPath absolutePath = (AbstractPath)path.toAbsolutePath().normalize();
        if (absolutePath.isRoot()) {
            return new EndPointCopyContext(absolutePath, null, null);
        }
        ElementPath elementPath = (ElementPath)absolutePath;
        AbstractPath parent = (AbstractPath)elementPath.getParent();
        String elementName = elementPath.getLastNameElement();
        return new EndPointCopyContext(elementPath, parent, elementName);
    }

    private static CopyContext buildCopyContext(EndPointCopyContext source, EndPointCopyContext target, TwoPathOperation operation, CopyOption[] options, int order) {
        boolean inverted;
        boolean secondFollowSymLinks;
        boolean firstFollowSymLinks;
        EndPointCopyContext second;
        EndPointCopyContext first;
        boolean followSymLinks = Options.isFollowSymLinks(options);
        boolean replaceExisting = Options.isReplaceExisting(options);
        boolean copyAttributes = Options.isCopyAttributes(options);
        if (order <= 0) {
            first = source;
            second = target;
            firstFollowSymLinks = followSymLinks;
            secondFollowSymLinks = false;
            inverted = false;
        } else {
            first = target;
            second = source;
            firstFollowSymLinks = false;
            secondFollowSymLinks = followSymLinks;
            inverted = true;
        }
        return new CopyContext(operation, source, target, first, second, firstFollowSymLinks, secondFollowSymLinks, inverted, replaceExisting, copyAttributes);
    }

    void delete(AbstractPath abstractPath) throws IOException {
        try (AutoRelease autoRelease = AutoReleaseLock.autoRelease(this.pathOrderingLock.readLock());){
            AbstractPath absolutePath = (AbstractPath)abstractPath.toAbsolutePath().normalize();
            if (absolutePath.isRoot()) {
                throw new FileSystemException(abstractPath.toString(), null, "can not delete root");
            }
            ElementPath elementPath = (ElementPath)absolutePath;
            AbstractPath parent = (AbstractPath)elementPath.getParent();
            this.accessDirectoryWriting(parent, true, directory -> {
                String fileName = elementPath.getLastNameElement();
                String key = this.lookUpTransformer.transform(fileName);
                MemoryEntry child = directory.getEntryOrException(key, abstractPath);
                try (AutoRelease lock = child.writeLock();){
                    if (child instanceof MemoryDirectory) {
                        MemoryDirectory childDirectory = (MemoryDirectory)child;
                        childDirectory.checkEmpty(abstractPath);
                    }
                    if (child instanceof MemoryFile) {
                        MemoryFile file = (MemoryFile)child;
                        if (file.openCount() > 0) {
                            throw new FileSystemException(abstractPath.toString(), null, "file still open");
                        }
                        file.markForDeletion();
                    }
                    directory.checkAccess(AccessMode.WRITE);
                    directory.removeEntry(key);
                }
                return null;
            });
        }
    }

    @Override
    public FileSystemProvider provider() {
        this.checker.check();
        return this.provider;
    }

    @Override
    @javax.annotation.PreDestroy
    @PreDestroy
    public void close() {
        if (this.checker.close()) {
            this.checker.close();
            this.provider.close(this);
        }
    }

    @Override
    public boolean isOpen() {
        return this.checker.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        this.checker.check();
        return this.store.isReadOnly();
    }

    @Override
    public String getSeparator() {
        this.checker.check();
        return this.separator;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        this.checker.check();
        return this.roots.keySet();
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        this.checker.check();
        return this.stores;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        this.checker.check();
        return this.supportedFileAttributeViews;
    }

    @Override
    public AbstractPath getPath(String first, String ... more) {
        this.checker.check();
        return this.pathParser.parse(this.rootByKey, first, more);
    }

    AbstractPath getPathFromUri(String uri) {
        this.checker.check();
        return this.pathParser.parseUri(this.rootByKey, uri);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        this.checker.check();
        int colonIndex = syntaxAndPattern.indexOf(58);
        if (colonIndex <= 0 || colonIndex == syntaxAndPattern.length() - 1) {
            throw new IllegalArgumentException("syntaxAndPattern must have form \"syntax:pattern\" but was \"" + syntaxAndPattern + "\"");
        }
        String syntax = syntaxAndPattern.substring(0, colonIndex);
        String pattern = syntaxAndPattern.substring(colonIndex + 1);
        if (syntax.equalsIgnoreCase(GlobPathMatcher.name())) {
            return this.pathParser.transpileGlob(pattern, this.lookUpTransformer.getRegexFlags());
        }
        if (syntax.equalsIgnoreCase(RegexPathMatcher.name())) {
            return this.pathParser.compileRegex(pattern, this.lookUpTransformer.getRegexFlags());
        }
        throw new UnsupportedOperationException("unsupported syntax \"" + syntax + "\"");
    }

    @Override
    public MemoryUserPrincipalLookupService getUserPrincipalLookupService() {
        this.checker.check();
        return this.userPrincipalLookupService;
    }

    @Override
    public WatchService newWatchService() {
        this.checker.check();
        throw new UnsupportedOperationException();
    }

    void register(MemoryWatchKey watchKey) {
        List previous;
        this.checker.check();
        AbsolutePath absolutePath = (AbsolutePath)watchKey.watchable().toAbsolutePath();
        List<MemoryWatchKey> keys = (CopyOnWriteArrayList<MemoryWatchKey>)this.watchKeys.get(absolutePath);
        if (keys == null && (previous = (List)this.watchKeys.putIfAbsent(absolutePath, keys = new CopyOnWriteArrayList<MemoryWatchKey>())) != null) {
            keys = previous;
        }
        keys.add(watchKey);
    }

    FileStore getFileStore() {
        return this.store;
    }

    Collator getCollator() {
        return this.collator;
    }

    @Override
    public Instant truncate(Instant instant) {
        if (instant == null || this.resolution == null) {
            return instant;
        }
        return instant.truncatedTo(this.resolution);
    }

    @Override
    public UserPrincipal getDefaultUser() {
        return this.getUserPrincipalLookupService().getDefaultUser();
    }

    boolean isHidden(AbstractPath abstractPath) throws IOException {
        if (this.supportedFileAttributeViews.contains("posix")) {
            return this.accessFileReading(abstractPath, false, entry -> {
                String originalName = entry.getOriginalName();
                return !originalName.isEmpty() && originalName.charAt(0) == '.';
            });
        }
        if (this.supportedFileAttributeViews.contains("dos")) {
            return this.readAttributes(abstractPath, DosFileAttributes.class, new LinkOption[0]).isHidden();
        }
        return false;
    }

    private MemoryEntry copyEntry(Path absoluteTargetPath, MemoryEntry sourceEntry, String targetElementName) throws IOException {
        if (sourceEntry instanceof MemoryFile) {
            MemoryFile sourceFile = (MemoryFile)sourceEntry;
            try (AutoRelease lock = sourceFile.readLock();){
                EntryCreationContext context = this.newEntryCreationContext(absoluteTargetPath, NO_FILE_ATTRIBUTES);
                MemoryFile memoryFile = new MemoryFile(targetElementName, context, sourceFile);
                return memoryFile;
            }
        }
        if (sourceEntry instanceof MemoryDirectory) {
            MemoryDirectory sourceDirectory = (MemoryDirectory)sourceEntry;
            try (AutoRelease lock = sourceDirectory.readLock();){
                EntryCreationContext context = this.newEntryCreationContext(absoluteTargetPath, NO_FILE_ATTRIBUTES);
                MemoryDirectory memoryDirectory = new MemoryDirectory(targetElementName, context);
                return memoryDirectory;
            }
        }
        if (sourceEntry instanceof MemorySymbolicLink) {
            MemorySymbolicLink sourceLink = (MemorySymbolicLink)sourceEntry;
            try (AutoRelease lock = sourceLink.readLock();){
                EntryCreationContext context = this.newEntryCreationContext(absoluteTargetPath, NO_FILE_ATTRIBUTES);
                MemorySymbolicLink memorySymbolicLink = new MemorySymbolicLink(targetElementName, sourceLink.getTarget(), context);
                return memorySymbolicLink;
            }
        }
        throw new AssertionError((Object)("unknown entry type:" + sourceEntry));
    }

    Path readSymbolicLink(AbstractPath path) throws IOException {
        AbstractPath parent = (AbstractPath)path.toAbsolutePath().getParent();
        return this.accessFileReading(parent, true, parentEntry -> {
            if (!(parentEntry instanceof MemoryDirectory)) {
                throw new FileSystemException(path.toString(), null, "parent is not a directory");
            }
            MemoryDirectory directory = (MemoryDirectory)parentEntry;
            return this.withReadLockDo(directory, (AbstractPath)path.getFileName(), false, entry -> {
                if (!(entry instanceof MemorySymbolicLink)) {
                    throw new NotLinkException("file is not a symbolic link");
                }
                return ((MemorySymbolicLink)entry).getTarget();
            });
        });
    }

    static void handleTwoPathOperation(CopyContext copyContext, MemoryDirectory firstDirectory, MemoryDirectory secondDirectory) throws IOException {
        StringTransformer targetTransformer;
        String targetElementName;
        MemoryEntry targetEntry;
        EndPointCopyContext sourceContext = copyContext.source;
        EndPointCopyContext targetContext = copyContext.target;
        MemoryDirectory sourceParent = copyContext.getSourceParent(firstDirectory, secondDirectory);
        MemoryDirectory targetParent = copyContext.getTargetParent(firstDirectory, secondDirectory);
        StringTransformer sourceTransformer = sourceContext.path.getMemoryFileSystem().lookUpTransformer;
        String sourceElementName = sourceTransformer.transform(sourceContext.elementName);
        MemoryEntry sourceEntry = sourceParent.getEntryOrException(sourceElementName, sourceContext.path);
        if (sourceEntry == (targetEntry = targetParent.getEntry(targetElementName = (targetTransformer = targetContext.path.getMemoryFileSystem().lookUpTransformer).transform(targetContext.elementName)))) {
            return;
        }
        if (sourceEntry == targetParent) {
            throw new FileSystemException(sourceContext.path.toString(), targetContext.path.toString(), "invalid argument");
        }
        targetParent.checkAccess(AccessMode.WRITE);
        if (copyContext.operation.isMove()) {
            sourceParent.checkAccess(AccessMode.WRITE);
        }
        if (targetEntry != null) {
            if (!copyContext.replaceExisting) {
                throw new FileAlreadyExistsException(targetContext.path.toString());
            }
            if (targetEntry instanceof MemoryDirectory) {
                MemoryDirectory targetDirectory = (MemoryDirectory)targetEntry;
                try (AutoRelease lock = targetDirectory.readLock();){
                    targetDirectory.checkEmpty(targetContext.path);
                }
            }
            targetParent.removeEntry(targetElementName);
        }
        if (copyContext.operation.isMove()) {
            sourceParent.removeEntry(sourceElementName);
            targetParent.addEntry(targetElementName, sourceEntry, copyContext.target.path);
            String newOriginalName = targetContext.path.getMemoryFileSystem().storeTransformer.transform(targetContext.elementName);
            sourceEntry.setOriginalName(newOriginalName);
        } else {
            MemoryEntry toCopy = MemoryFileSystem.getCopySource(copyContext, sourceEntry);
            MemoryEntry copy = targetContext.path.getMemoryFileSystem().copyEntry(targetContext.path, toCopy, targetElementName);
            if (copyContext.copyAttributes) {
                copy.initializeAttributes(toCopy);
            }
            targetParent.addEntry(targetElementName, copy, copyContext.target.path);
        }
    }

    private static MemoryEntry getCopySource(CopyContext copyContext, MemoryEntry sourceEntry) throws IOException {
        MemoryEntry toCopy;
        if (sourceEntry instanceof MemorySymbolicLink && copyContext.isSourceFollowSymLinks()) {
            AbstractPath linkTarget = ((MemorySymbolicLink)sourceEntry).getTarget();
            MemoryFileSystem sourceFileSystem = copyContext.source.path.getFileSystem();
            AbstractPath lookupPath = linkTarget.isAbsolute() ? linkTarget : (AbstractPath)copyContext.source.parent.resolve(linkTarget);
            toCopy = sourceFileSystem.getFile(lookupPath, NO_OPEN_OPTIONS, NO_FILE_ATTRIBUTES);
        } else {
            toCopy = sourceEntry;
        }
        return toCopy;
    }

    public String toString() {
        return MemoryFileSystem.class.getSimpleName() + '[' + this.key + ']';
    }

    static {
        NO_OPEN_OPTIONS = Collections.emptySet();
        NO_FILE_ATTRIBUTES = new FileAttribute[0];
        HashSet<String> unsupported = new HashSet<String>(3);
        unsupported.add("lastAccessTime");
        unsupported.add("creationTime");
        unsupported.add("lastModifiedTime");
        UNSUPPORTED_INITIAL_ATTRIBUTES = Collections.unmodifiableSet(unsupported);
    }

    @FunctionalInterface
    static interface MemoryEntryCreator {
        public MemoryEntry create(String var1) throws IOException;
    }

    @FunctionalInterface
    static interface MemoryDirectoryBlock<R> {
        public R value(MemoryDirectory var1) throws IOException;
    }

    @FunctionalInterface
    static interface MemoryEntryBlock<R> {
        public R value(MemoryEntry var1) throws IOException;
    }

    static class LazyFileAttributeView
    implements InvocationHandler {
        static final AtomicReferenceFieldUpdater<LazyFileAttributeView, FileAttributeView> ATTRIBUTE_VIEW_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LazyFileAttributeView.class, FileAttributeView.class, "attributeView");
        private final AbstractPath path;
        private final LinkOption[] options;
        private final Class<? extends FileAttributeView> type;
        private volatile FileAttributeView attributeView;

        LazyFileAttributeView(AbstractPath path, Class<? extends FileAttributeView> type, LinkOption ... options) {
            this.path = path;
            this.options = options;
            this.type = type;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            switch (methodName = method.getName()) {
                case "name": {
                    if (args != null && args.length > 0) {
                        throw new AssertionError((Object)"#name() not expected to have any arguments");
                    }
                    return FileAttributeViews.mapAttributeView(this.type);
                }
                case "toString": {
                    if (args != null && args.length > 0) {
                        throw new AssertionError((Object)"#toString() not expected to have any arguments");
                    }
                    return this.type.toString();
                }
                case "equals": {
                    if (args == null || args.length != 1) {
                        throw new AssertionError((Object)"#equals() expected to exactly one argument");
                    }
                    return proxy == args[0];
                }
                case "hashCode": {
                    if (args != null && args.length > 0) {
                        throw new AssertionError((Object)"#hashCode() not expected to have any arguments");
                    }
                    return System.identityHashCode(proxy);
                }
            }
            try {
                return method.invoke((Object)this.getView(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private FileAttributeView getView() throws IOException {
            FileAttributeView view = ATTRIBUTE_VIEW_UPDATER.get(this);
            if (view != null) {
                return view;
            }
            FileAttributeView newValue = this.path.getMemoryFileSystem().getFileAttributeView(this.path, this.type, this.options);
            boolean successful = ATTRIBUTE_VIEW_UPDATER.compareAndSet(this, null, newValue);
            if (successful) {
                return newValue;
            }
            return ATTRIBUTE_VIEW_UPDATER.get(this);
        }
    }

    static final class CopyContext {
        final EndPointCopyContext source;
        final EndPointCopyContext target;
        final EndPointCopyContext first;
        final EndPointCopyContext second;
        final boolean firstFollowSymLinks;
        final boolean secondFollowSymLinks;
        private final boolean inverted;
        final boolean replaceExisting;
        final boolean copyAttributes;
        final TwoPathOperation operation;

        CopyContext(TwoPathOperation operation, EndPointCopyContext source, EndPointCopyContext target, EndPointCopyContext first, EndPointCopyContext second, boolean firstFollowSymLinks, boolean secondFollowSymLinks, boolean inverted, boolean replaceExisting, boolean copyAttributes) {
            this.operation = operation;
            this.source = source;
            this.target = target;
            this.first = first;
            this.second = second;
            this.firstFollowSymLinks = firstFollowSymLinks;
            this.secondFollowSymLinks = secondFollowSymLinks;
            this.inverted = inverted;
            this.replaceExisting = replaceExisting;
            this.copyAttributes = copyAttributes;
        }

        boolean isSourceFollowSymLinks() {
            if (this.inverted) {
                return this.secondFollowSymLinks;
            }
            return this.firstFollowSymLinks;
        }

        MemoryDirectory getSourceParent(MemoryDirectory firstDirectory, MemoryDirectory secondDirectory) {
            if (!this.inverted) {
                return firstDirectory;
            }
            return secondDirectory;
        }

        MemoryDirectory getTargetParent(MemoryDirectory firstDirectory, MemoryDirectory secondDirectory) {
            if (!this.inverted) {
                return secondDirectory;
            }
            return firstDirectory;
        }
    }

    static final class EndPointCopyContext {
        final AbstractPath path;
        final AbstractPath parent;
        final String elementName;

        EndPointCopyContext(AbstractPath path, AbstractPath parent, String elementName) {
            this.path = path;
            this.parent = parent;
            this.elementName = elementName;
        }
    }

    static final class GetEntryResult {
        final MemoryEntry entry;
        final AbstractPath linkTarget;

        GetEntryResult(MemoryEntry entry) {
            this.entry = entry;
            this.linkTarget = null;
        }

        GetEntryResult(AbstractPath linkTarget) {
            this.entry = null;
            this.linkTarget = linkTarget;
        }
    }
}

