/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AppendingBlockChannel;
import com.github.marschall.memoryfilesystem.AppendingBlockOutputStream;
import com.github.marschall.memoryfilesystem.AutoRelease;
import com.github.marschall.memoryfilesystem.BlockChannel;
import com.github.marschall.memoryfilesystem.BlockInputStream;
import com.github.marschall.memoryfilesystem.EntryCreationContext;
import com.github.marschall.memoryfilesystem.InitializingFileAttributeView;
import com.github.marschall.memoryfilesystem.LockSet;
import com.github.marschall.memoryfilesystem.MemoryContents;
import com.github.marschall.memoryfilesystem.MemoryEntry;
import com.github.marschall.memoryfilesystem.MemoryFileLock;
import com.github.marschall.memoryfilesystem.NonAppendingBlockChannel;
import com.github.marschall.memoryfilesystem.NonAppendingBlockOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Set;

class MemoryFile
extends MemoryEntry
implements MemoryContents {
    private static final int ARRAY_HEADER = 20;
    static final int BLOCK_SIZE = 4076;
    private final InitializingFileAttributeView basicFileAttributeView = new MemoryFileAttributesView();
    private LockSet lockSet;
    private int openCount;
    private byte[] directBlock;
    private byte[][] indirectBlocks;
    private long size;
    private int indirectBlocksAllocated;

    MemoryFile(String originalName, EntryCreationContext context) {
        this(originalName, context, 0);
    }

    MemoryFile(String originalName, EntryCreationContext context, int initialBlocks) {
        super(originalName, context);
        this.directBlock = initialBlocks == 0 ? new byte[4076] : new byte[4076];
        if (initialBlocks > 1) {
            this.indirectBlocks = new byte[4076][];
            for (int i = 0; i < initialBlocks - 1; ++i) {
                this.indirectBlocks[i] = new byte[4076];
            }
            this.indirectBlocksAllocated = initialBlocks - 1;
        }
        this.size = 0L;
        this.openCount = 0;
    }

    MemoryFile(String originalName, EntryCreationContext context, MemoryFile other) {
        super(originalName, context);
        if (other.directBlock != null) {
            this.directBlock = (byte[])other.directBlock.clone();
        }
        if (other.indirectBlocks != null) {
            this.indirectBlocks = (byte[][])other.indirectBlocks.clone();
            for (int i = 0; i < other.indirectBlocksAllocated; ++i) {
                this.indirectBlocks[i] = (byte[])other.indirectBlocks[i].clone();
            }
        }
        this.indirectBlocksAllocated = other.indirectBlocksAllocated;
        this.size = other.size;
        this.openCount = 0;
    }

    @Override
    InitializingFileAttributeView getBasicFileAttributeView() {
        return this.basicFileAttributeView;
    }

    @Override
    public void accessed() {
        super.accessed();
    }

    @Override
    public void modified() {
        super.modified();
    }

    @Override
    public long size() {
        try (AutoRelease lock = this.readLock();){
            long l = this.size;
            return l;
        }
    }

    InputStream newInputStream(Set<? extends OpenOption> options, Path path) throws IOException {
        boolean deleteOnClose = options.contains(StandardOpenOption.DELETE_ON_CLOSE);
        boolean sync = options.contains(StandardOpenOption.SYNC);
        return this.newInputStream(deleteOnClose, path);
    }

    OutputStream newOutputStream(Set<? extends OpenOption> options, Path path) throws IOException {
        boolean deleteOnClose = options.contains(StandardOpenOption.DELETE_ON_CLOSE);
        boolean append = options.contains(StandardOpenOption.APPEND);
        boolean sync = options.contains(StandardOpenOption.SYNC);
        if (append) {
            return this.newAppendingOutputStream(deleteOnClose, path);
        }
        boolean truncate = options.contains(StandardOpenOption.TRUNCATE_EXISTING);
        if (truncate) {
            this.truncate(0L);
        }
        return this.newOutputStream(deleteOnClose, path);
    }

    BlockChannel newChannel(Set<? extends OpenOption> options, Path path) throws IOException {
        boolean truncate;
        boolean append = options.contains(StandardOpenOption.APPEND);
        boolean readable = options.contains(StandardOpenOption.READ);
        boolean deleteOnClose = options.contains(StandardOpenOption.DELETE_ON_CLOSE);
        boolean sync = options.contains(StandardOpenOption.SYNC);
        if (append) {
            return this.newAppendingChannel(readable, deleteOnClose, path);
        }
        boolean writable = options.contains(StandardOpenOption.WRITE);
        if (writable && (truncate = options.contains(StandardOpenOption.TRUNCATE_EXISTING))) {
            this.truncate(0L);
        }
        return this.newChannel(readable, writable, deleteOnClose, path);
    }

    InputStream newInputStream(boolean deleteOnClose, Path path) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.incrementOpenCount(path);
            BlockInputStream blockInputStream = new BlockInputStream(this, deleteOnClose, path);
            return blockInputStream;
        }
    }

    OutputStream newOutputStream(boolean deleteOnClose, Path path) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.incrementOpenCount(path);
            NonAppendingBlockOutputStream nonAppendingBlockOutputStream = new NonAppendingBlockOutputStream(this, deleteOnClose, path);
            return nonAppendingBlockOutputStream;
        }
    }

    OutputStream newAppendingOutputStream(boolean deleteOnClose, Path path) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.incrementOpenCount(path);
            AppendingBlockOutputStream appendingBlockOutputStream = new AppendingBlockOutputStream(this, deleteOnClose, path);
            return appendingBlockOutputStream;
        }
    }

    BlockChannel newChannel(boolean readable, boolean writable, boolean deleteOnClose, Path path) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.incrementOpenCount(path);
            NonAppendingBlockChannel nonAppendingBlockChannel = new NonAppendingBlockChannel(this, readable, writable, deleteOnClose, path);
            return nonAppendingBlockChannel;
        }
    }

    BlockChannel newAppendingChannel(boolean readable, boolean deleteOnClose, Path path) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.incrementOpenCount(path);
            AppendingBlockChannel appendingBlockChannel = new AppendingBlockChannel(this, readable, this.size, deleteOnClose, path);
            return appendingBlockChannel;
        }
    }

    private void incrementOpenCount(Path path) throws NoSuchFileException {
        if (this.openCount < 0) {
            throw new NoSuchFileException(path.toString());
        }
        ++this.openCount;
    }

    int openCount() {
        return this.openCount;
    }

    void markForDeletion() {
        this.openCount = -1;
    }

    @Override
    public void closedStream(Path toDelete) {
        try (AutoRelease lock = this.writeLock();){
            --this.openCount;
        }
        if (toDelete != null) {
            try {
                Files.delete(toDelete);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void closedChannel(Path toDelete) {
        try (AutoRelease lock = this.writeLock();){
            --this.openCount;
        }
        if (toDelete != null) {
            try {
                Files.delete(toDelete);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private byte[] getBlock(int currentBlock) {
        if (currentBlock == 0) {
            return this.directBlock;
        }
        return this.indirectBlocks[currentBlock - 1];
    }

    @Override
    public long read(ByteBuffer dst, long position, long maximum) throws IOException {
        try (AutoRelease lock = this.readLock();){
            if (position >= this.size) {
                long l = -1L;
                return l;
            }
            long remaining = dst.remaining();
            long toRead = Math.min(Math.min(this.size - position, remaining), maximum);
            int currentBlock = (int)(position / 4076L);
            int startIndexInBlock = (int)(position - (long)currentBlock * 4076L);
            long read = 0L;
            while (read < toRead) {
                int lengthInBlock = (int)Math.min(4076L - (long)startIndexInBlock, toRead - read);
                byte[] block = this.getBlock(currentBlock);
                dst.put(block, startIndexInBlock, lengthInBlock);
                read += (long)lengthInBlock;
                startIndexInBlock = 0;
                ++currentBlock;
            }
            long l = read;
            return l;
        }
    }

    @Override
    public int readShort(ByteBuffer dst, long position) throws IOException {
        return (int)this.read(dst, position, Integer.MAX_VALUE);
    }

    @Override
    public int read(byte[] dst, long position, int off, int len) throws IOException {
        try (AutoRelease lock = this.readLock();){
            if (position >= this.size) {
                int n = -1;
                return n;
            }
            int toRead = (int)Math.min(Math.min(this.size - position, (long)len), Integer.MAX_VALUE);
            int currentBlock = (int)(position / 4076L);
            int startIndexInBlock = (int)(position - (long)currentBlock * 4076L);
            int read = 0;
            while (read < toRead) {
                int lengthInBlock = (int)Math.min(4076L - (long)startIndexInBlock, (long)toRead - (long)read);
                byte[] block = this.getBlock(currentBlock);
                System.arraycopy(block, startIndexInBlock, dst, off + read, lengthInBlock);
                read += lengthInBlock;
                startIndexInBlock = 0;
                ++currentBlock;
            }
            int n = read;
            return n;
        }
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.ensureCapacity(position + count);
            long transferred = 0L;
            long toTransfer = count;
            int currentBlock = (int)(position / 4076L);
            int startIndexInBlock = (int)(position - (long)currentBlock * 4076L);
            while (transferred < toTransfer) {
                int lengthInBlock = (int)Math.min(4076L - (long)startIndexInBlock, toTransfer - transferred);
                byte[] block = this.getBlock(currentBlock);
                ByteBuffer buffer = ByteBuffer.wrap(block, startIndexInBlock, lengthInBlock);
                MemoryFile.readFully(buffer, src, lengthInBlock);
                transferred += (long)lengthInBlock;
                startIndexInBlock = 0;
                ++currentBlock;
            }
            this.size = Math.max(this.size, position + transferred);
            long l = transferred;
            return l;
        }
    }

    @Override
    public long transferTo(WritableByteChannel target, long position, long count) throws IOException {
        try (AutoRelease lock = this.readLock();){
            long transferred = 0L;
            long toTransfer = Math.min(count, this.size - position);
            int currentBlock = (int)(position / 4076L);
            int startIndexInBlock = (int)(position - (long)currentBlock * 4076L);
            while (transferred < toTransfer) {
                int lengthInBlock = (int)Math.min(4076L - (long)startIndexInBlock, toTransfer - transferred);
                byte[] block = this.getBlock(currentBlock);
                ByteBuffer buffer = ByteBuffer.wrap(block, startIndexInBlock, lengthInBlock);
                MemoryFile.writeFully(buffer, target, lengthInBlock);
                transferred += (long)lengthInBlock;
                startIndexInBlock = 0;
                ++currentBlock;
            }
            long l = transferred;
            return l;
        }
    }

    private static int writeFully(ByteBuffer src, WritableByteChannel target, int toWrite) throws IOException {
        int written;
        for (written = 0; written < toWrite; written += target.write(src)) {
        }
        return written;
    }

    private static int readFully(ByteBuffer src, ReadableByteChannel target, int toRead) throws IOException {
        int read;
        for (read = 0; read < toRead; read += target.read(src)) {
        }
        return read;
    }

    @Override
    public long write(ByteBuffer src, long position, long maximum) {
        try (AutoRelease lock = this.writeLock();){
            long remaining = src.remaining();
            this.ensureCapacity(position + remaining);
            long toWrite = Math.min(remaining, maximum);
            int currentBlock = (int)(position / 4076L);
            int startIndexInBlock = (int)(position - (long)currentBlock * 4076L);
            long written = 0L;
            while (written < toWrite) {
                int lengthInBlock = (int)Math.min(4076L - (long)startIndexInBlock, toWrite - written);
                byte[] block = this.getBlock(currentBlock);
                src.get(block, startIndexInBlock, lengthInBlock);
                written += (long)lengthInBlock;
                startIndexInBlock = 0;
                ++currentBlock;
            }
            this.size = Math.max(this.size, position + written);
            long l = written;
            return l;
        }
    }

    @Override
    public int writeShort(ByteBuffer src, long position) {
        return (int)this.write(src, position, Integer.MAX_VALUE);
    }

    @Override
    public int write(byte[] src, long position, int off, int len) {
        try (AutoRelease lock = this.writeLock();){
            this.ensureCapacity(position + (long)len);
            int toWrite = Math.min(len, Integer.MAX_VALUE);
            int currentBlock = (int)(position / 4076L);
            int startIndexInBlock = (int)(position - (long)currentBlock * 4076L);
            int written = 0;
            while (written < toWrite) {
                int lengthInBlock = (int)Math.min(4076L - (long)startIndexInBlock, (long)toWrite - (long)written);
                byte[] block = this.getBlock(currentBlock);
                System.arraycopy(src, off + written, block, startIndexInBlock, lengthInBlock);
                written += lengthInBlock;
                startIndexInBlock = 0;
                ++currentBlock;
            }
            this.size = Math.max(this.size, position + (long)written);
            int n = written;
            return n;
        }
    }

    @Override
    public long writeAtEnd(ByteBuffer src, long maximum) {
        try (AutoRelease lock = this.writeLock();){
            long l = this.write(src, this.size, maximum);
            return l;
        }
    }

    @Override
    public int writeAtEnd(ByteBuffer src) {
        try (AutoRelease lock = this.writeLock();){
            int n = this.writeShort(src, this.size);
            return n;
        }
    }

    @Override
    public int writeAtEnd(byte[] src, int off, int len) {
        try (AutoRelease lock = this.writeLock();){
            int n = this.write(src, this.size, off, len);
            return n;
        }
    }

    @Override
    public void truncate(long newSize) {
        try (AutoRelease lock = this.writeLock();){
            if (newSize < this.size) {
                this.size = newSize;
            }
        }
    }

    private void ensureCapacity(long capacity) {
        int blocksRequired;
        if (capacity <= 4076L) {
            return;
        }
        if (this.indirectBlocks == null) {
            this.indirectBlocks = new byte[4076][];
        }
        if ((blocksRequired = (int)((capacity - 1L) / 4076L)) > 4076) {
            throw new AssertionError((Object)"files bigger than 16GB not yet supported");
        }
        if (blocksRequired > this.indirectBlocksAllocated) {
            for (int i = this.indirectBlocksAllocated; i < blocksRequired; ++i) {
                this.indirectBlocks[i] = new byte[4076];
                ++this.indirectBlocksAllocated;
            }
        }
    }

    @Override
    public MemoryFileLock tryLock(MemoryFileLock lock) {
        try (AutoRelease autoRelease = this.writeLock();){
            MemoryFileLock memoryFileLock = this.lockSet().tryLock(lock);
            return memoryFileLock;
        }
    }

    @Override
    public MemoryFileLock lock(MemoryFileLock lock) throws IOException {
        try (AutoRelease autoRelease = this.writeLock();){
            MemoryFileLock memoryFileLock = this.lockSet().lock(lock);
            return memoryFileLock;
        }
    }

    @Override
    public void unlock(MemoryFileLock lock) {
        try (AutoRelease autoRelease = this.writeLock();){
            this.lockSet.remove(lock);
        }
    }

    LockSet lockSet() {
        if (this.lockSet == null) {
            this.lockSet = new LockSet();
        }
        return this.lockSet;
    }

    public String toString() {
        return "file(" + this.getOriginalName() + ')';
    }

    static final class MemoryFileAttributes
    extends MemoryEntry.MemoryEntryFileAttributes {
        private final long size;

        MemoryFileAttributes(Object fileKey, FileTime lastModifiedTime, FileTime lastAccessTime, FileTime creationTime, long size) {
            super(fileKey, lastModifiedTime, lastAccessTime, creationTime);
            this.size = size;
        }

        @Override
        public boolean isRegularFile() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return this.size;
        }
    }

    class MemoryFileAttributesView
    extends MemoryEntry.MemoryEntryFileAttributesView {
        MemoryFileAttributesView() {
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            MemoryFile.this.checkAccess(AccessMode.READ);
            try (AutoRelease lock = MemoryFile.this.readLock();){
                FileTime lastModifiedTime = MemoryFile.this.lastModifiedTime();
                FileTime lastAccessTime = MemoryFile.this.lastAccessTime();
                FileTime creationTime = MemoryFile.this.creationTime();
                MemoryFileAttributes memoryFileAttributes = new MemoryFileAttributes(MemoryFile.this, lastModifiedTime, lastAccessTime, creationTime, MemoryFile.this.size);
                return memoryFileAttributes;
            }
        }
    }
}

