/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AbstractPath;
import com.github.marschall.memoryfilesystem.ElementPath;
import com.github.marschall.memoryfilesystem.MemoryFileSystem;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.Iterator;

abstract class Root
extends AbstractPath {
    Root(MemoryFileSystem fileSystem) {
        super(fileSystem);
    }

    abstract boolean isNamed();

    @Override
    public boolean isAbsolute() {
        return true;
    }

    abstract String getKey();

    @Override
    boolean isRoot() {
        return true;
    }

    @Override
    public Path getRoot() {
        return this;
    }

    @Override
    public Path getFileName() {
        return null;
    }

    @Override
    public Path getParent() {
        return null;
    }

    @Override
    public int getNameCount() {
        return 0;
    }

    @Override
    public Path getName(int index) {
        throw new IllegalArgumentException("root does not have any name elements");
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        throw new IllegalArgumentException("can't create subpath of root");
    }

    @Override
    public Path normalize() {
        return this;
    }

    @Override
    public Path toAbsolutePath() {
        return this;
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this;
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Path> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    Path resolve(ElementPath other) {
        return AbstractPath.createAboslute(this.getMemoryFileSystem(), this, other.getNameElements());
    }

    @Override
    Path resolveSibling(AbstractPath other) {
        return other;
    }

    @Override
    Path relativize(AbstractPath other) {
        if (!other.isAbsolute()) {
            throw new IllegalArgumentException("can only relativize an absolute path against an absolute path");
        }
        if (!other.getRoot().equals(this)) {
            throw new IllegalArgumentException("paths must have the same root");
        }
        if (other.equals(this)) {
            return Root.createRelative(this.getMemoryFileSystem(), Collections.emptyList());
        }
        if (other instanceof ElementPath) {
            ElementPath otherPath = (ElementPath)other;
            return Root.createRelative(this.getMemoryFileSystem(), otherPath.getNameElements());
        }
        throw new IllegalArgumentException("unsupported path argument");
    }
}

