/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AutoRelease;
import com.github.marschall.memoryfilesystem.AutoReleaseLock;
import com.github.marschall.memoryfilesystem.EntryCreationContext;
import com.github.marschall.memoryfilesystem.FileAttributeViews;
import com.github.marschall.memoryfilesystem.InitializingFileAttributeView;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.AccessMode;
import java.nio.file.FileSystemException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

abstract class MemoryEntry {
    private final String originalName;
    private FileTime lastModifiedTime;
    private FileTime lastAccessTime;
    private FileTime creationTime;
    private final ReadWriteLock lock;
    private final Map<String, InitializingFileAttributeView> additionalAttributes;

    MemoryEntry(String originalName, EntryCreationContext context) {
        FileTime now;
        this.originalName = originalName;
        this.lock = new ReentrantReadWriteLock();
        this.lastAccessTime = now = this.getNow();
        this.lastModifiedTime = now;
        this.creationTime = now;
        if (context.additionalViews.isEmpty()) {
            this.additionalAttributes = Collections.emptyMap();
        } else if (context.additionalViews.size() == 1) {
            InitializingFileAttributeView view = this.instantiate(context.firstView(), context);
            this.additionalAttributes = Collections.singletonMap(view.name(), view);
        } else {
            this.additionalAttributes = new HashMap<String, InitializingFileAttributeView>(context.additionalViews.size());
            for (Class<? extends FileAttributeView> viewClass : context.additionalViews) {
                InitializingFileAttributeView view = this.instantiate(viewClass, context);
                this.additionalAttributes.put(view.name(), view);
            }
        }
    }

    void initializeAttributes(MemoryEntry other) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            other.getBasicFileAttributeView().initializeFrom(this.getBasicFileAttributeView());
            for (InitializingFileAttributeView view : this.additionalAttributes.values()) {
                view.initializeFrom(other.additionalAttributes);
            }
        }
    }

    void initializeRoot() {
        try (AutoRelease lock = this.readLock();){
            for (InitializingFileAttributeView view : this.additionalAttributes.values()) {
                view.initializeRoot();
            }
        }
    }

    private InitializingFileAttributeView instantiate(Class<? extends FileAttributeView> viewClass, EntryCreationContext context) {
        if (viewClass == PosixFileAttributeView.class) {
            return new MemoryPosixFileAttributeView(context);
        }
        if (viewClass == DosFileAttributeView.class) {
            return new MemoryDosFileAttributeView();
        }
        if (viewClass == UserDefinedFileAttributeView.class) {
            return new MemoryUserDefinedFileAttributeView();
        }
        throw new IllegalArgumentException("unknown file attribute view: " + viewClass);
    }

    String getOriginalName() {
        return this.originalName;
    }

    private FileTime getNow() {
        long now = System.currentTimeMillis();
        return FileTime.fromMillis(now);
    }

    AutoRelease readLock() {
        return AutoReleaseLock.autoRelease(this.lock.readLock());
    }

    AutoRelease writeLock() {
        return AutoReleaseLock.autoRelease(this.lock.writeLock());
    }

    FileTime lastModifiedTime() {
        try (AutoRelease lock = this.readLock();){
            FileTime fileTime = this.lastModifiedTime;
            return fileTime;
        }
    }

    FileTime lastAccessTime() {
        try (AutoRelease lock = this.readLock();){
            FileTime fileTime = this.lastAccessTime;
            return fileTime;
        }
    }

    FileTime creationTime() {
        try (AutoRelease lock = this.readLock();){
            FileTime fileTime = this.creationTime;
            return fileTime;
        }
    }

    void checkAccess(AccessMode ... modes) {
        try (AutoRelease lock = this.readLock();){
            AccessMode unsupported = this.getUnsupported(modes);
            if (unsupported != null) {
                throw new UnsupportedOperationException("access mode " + (Object)((Object)unsupported) + " is not supported");
            }
        }
    }

    private AccessMode getUnsupported(AccessMode ... modes) {
        for (AccessMode mode : modes) {
            if (mode == AccessMode.READ || mode == AccessMode.WRITE || mode == AccessMode.EXECUTE) continue;
            return mode;
        }
        return null;
    }

    void modified() {
        FileTime now;
        this.lastAccessTime = now = this.getNow();
        this.lastModifiedTime = now;
    }

    void accessed() {
        this.lastAccessTime = this.getNow();
    }

    void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) {
        if (lastModifiedTime == null) {
            throw new IllegalArgumentException("lastModifiedTime must not be null");
        }
        if (lastAccessTime == null) {
            throw new IllegalArgumentException("lastAccessTime must not be null");
        }
        if (createTime == null) {
            throw new IllegalArgumentException("createTime must not be null");
        }
        try (AutoRelease lock = this.writeLock();){
            this.checkAccess(AccessMode.WRITE);
            this.lastModifiedTime = lastModifiedTime;
            this.lastAccessTime = lastAccessTime;
            this.creationTime = createTime;
        }
    }

    <A extends FileAttributeView> A getFileAttributeView(Class<A> type) {
        Throwable throwable = null;
        try (AutoRelease lock = this.readLock();){
            this.checkAccess(AccessMode.READ);
            if (type == BasicFileAttributeView.class) {
                InitializingFileAttributeView initializingFileAttributeView = this.getBasicFileAttributeView();
                return (A)initializingFileAttributeView;
            }
            String name = null;
            if (type == FileOwnerAttributeView.class) {
                if (this.additionalAttributes.containsKey("posix")) {
                    name = "posix";
                } else if (this.additionalAttributes.containsKey("acl")) {
                    name = "acl";
                }
            } else {
                name = FileAttributeViews.mapAttributeView(type);
            }
            if (name == null) {
                throw new UnsupportedOperationException("file attribute view" + type + " not supported");
            }
            FileAttributeView view = this.additionalAttributes.get(name);
            if (view != null) {
                FileAttributeView fileAttributeView = view;
                return (A)fileAttributeView;
            }
            try {
                throw new UnsupportedOperationException("file attribute view" + type + " not supported");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    <A extends BasicFileAttributes> A readAttributes(Class<A> type) throws IOException {
        Throwable throwable = null;
        try (AutoRelease lock = this.readLock();){
            this.checkAccess(AccessMode.READ);
            if (type == BasicFileAttributes.class) {
                BasicFileAttributes basicFileAttributes = this.getBasicFileAttributes();
                return (A)basicFileAttributes;
            }
            String viewName = FileAttributeViews.mapFileAttributes(type);
            if (viewName == null) throw new UnsupportedOperationException("file attributes " + type + " not supported");
            FileAttributeView view = this.additionalAttributes.get(viewName);
            if (view instanceof BasicFileAttributeView) {
                BasicFileAttributes basicFileAttributes = ((BasicFileAttributeView)view).readAttributes();
                return (A)basicFileAttributes;
            }
            try {
                throw new UnsupportedOperationException("file attributes " + type + " not supported");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    abstract InitializingFileAttributeView getBasicFileAttributeView();

    abstract BasicFileAttributes getBasicFileAttributes();

    class MemoryUserDefinedFileAttributeView
    extends DelegatingFileAttributes
    implements UserDefinedFileAttributeView {
        private Map<String, byte[]> values;

        MemoryUserDefinedFileAttributeView() {
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            throw new UnsupportedOperationException("readAttributes");
        }

        @Override
        void initializeFromSelf(FileAttributeView selfAttributes) {
            MemoryUserDefinedFileAttributeView other = (MemoryUserDefinedFileAttributeView)selfAttributes;
            if (other.values == null) {
                this.values = null;
            } else {
                this.values = new HashMap<String, byte[]>(other.values.size());
                for (Map.Entry<String, byte[]> entry : other.values.entrySet()) {
                    this.values.put(entry.getKey(), (byte[])entry.getValue().clone());
                }
            }
        }

        private Map<String, byte[]> getValues() {
            if (this.values == null) {
                this.values = new HashMap<String, byte[]>(3);
            }
            return this.values;
        }

        @Override
        public String name() {
            return "user";
        }

        @Override
        public List<String> list() throws IOException {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                if (this.values == null) {
                    List<String> list = Collections.emptyList();
                    return list;
                }
                Set<String> keys = this.getValues().keySet();
                ArrayList<String> arrayList = new ArrayList<String>(keys);
                return arrayList;
            }
        }

        @Override
        public int size(String name) throws IOException {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                byte[] value = this.getValue(name);
                int n = value.length;
                return n;
            }
        }

        private byte[] getValue(String name) throws FileSystemException {
            if (name == null) {
                throw new NullPointerException("name is null");
            }
            if (this.values == null) {
                throw new FileSystemException(null, null, "attribute " + name + " not present");
            }
            byte[] value = this.values.get(name);
            if (value == null) {
                throw new FileSystemException(null, null, "attribute " + name + " not present");
            }
            return value;
        }

        @Override
        public int read(String name, ByteBuffer dst) throws IOException {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                byte[] value = this.getValue(name);
                int remaining = dst.remaining();
                int required = value.length;
                if (remaining < required) {
                    throw new FileSystemException(null, null, required + " bytes in buffer required but only " + remaining + " available");
                }
                int startPosition = dst.position();
                dst.put(value);
                int endPosition = dst.position();
                int n = endPosition - startPosition;
                return n;
            }
        }

        @Override
        public int write(String name, ByteBuffer src) throws IOException {
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                if (name == null) {
                    throw new NullPointerException("name is null");
                }
                if (src == null) {
                    throw new NullPointerException("buffer is null");
                }
                int remaining = src.remaining();
                byte[] dst = new byte[remaining];
                int startPosition = src.position();
                src.get(dst);
                int endPosition = src.position();
                this.getValues().put(name, dst);
                int n = endPosition - startPosition;
                return n;
            }
        }

        @Override
        public void delete(String name) throws IOException {
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                if (this.values != null) {
                    if (name == null) {
                        throw new NullPointerException("name is null");
                    }
                    this.values.remove(name);
                }
            }
        }
    }

    class MemoryPosixFileAttributeView
    extends MemoryFileOwnerAttributeView
    implements PosixFileAttributeView,
    PosixFileAttributes {
        private GroupPrincipal group;
        private Set<PosixFilePermission> perms;

        MemoryPosixFileAttributeView(EntryCreationContext context) {
            super(context);
            if (context.group == null) {
                throw new NullPointerException("group");
            }
            this.group = context.group;
            this.perms = this.saveCopy(context.umask);
        }

        @Override
        public String name() {
            return "posix";
        }

        @Override
        void initializeFromSelf(FileAttributeView selfAttributes) {
            MemoryPosixFileAttributeView other = (MemoryPosixFileAttributeView)selfAttributes;
            this.group = other.group;
            this.perms = this.saveCopy(other.perms);
        }

        @Override
        public GroupPrincipal group() {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                GroupPrincipal groupPrincipal = this.group;
                return groupPrincipal;
            }
        }

        @Override
        public UserPrincipal owner() {
            return this.getOwner();
        }

        @Override
        public void setGroup(GroupPrincipal group) throws IOException {
            if (group == null) {
                throw new IllegalArgumentException("group must not be null");
            }
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                MemoryEntry.this.checkAccess(AccessMode.WRITE);
                this.group = group;
            }
        }

        @Override
        public PosixFileAttributes readAttributes() throws IOException {
            MemoryEntry.this.checkAccess(AccessMode.READ);
            return this;
        }

        @Override
        public Set<PosixFilePermission> permissions() {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                Set<PosixFilePermission> set = this.perms;
                return set;
            }
        }

        private Set<PosixFilePermission> saveCopy(Set<PosixFilePermission> perms) {
            if (perms.isEmpty()) {
                return Collections.emptySet();
            }
            if (perms.size() == 1) {
                return Collections.singleton(perms.iterator().next());
            }
            EnumSet<PosixFilePermission> copy = EnumSet.noneOf(PosixFilePermission.class);
            copy.addAll(perms);
            return copy;
        }

        @Override
        public void setPermissions(Set<PosixFilePermission> perms) throws IOException {
            if (perms == null) {
                throw new IllegalArgumentException("permissions must not be null");
            }
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                MemoryEntry.this.checkAccess(AccessMode.WRITE);
                this.perms = this.saveCopy(perms);
            }
        }
    }

    abstract class MemoryFileOwnerAttributeView
    extends DelegatingFileAttributes
    implements FileOwnerAttributeView {
        private UserPrincipal owner;

        MemoryFileOwnerAttributeView(EntryCreationContext context) {
            if (context.user == null) {
                throw new NullPointerException("owner");
            }
            this.owner = context.user;
        }

        @Override
        public UserPrincipal getOwner() {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                UserPrincipal userPrincipal = this.owner;
                return userPrincipal;
            }
        }

        @Override
        public void setOwner(UserPrincipal owner) throws IOException {
            if (owner == null) {
                throw new IllegalArgumentException("owner must not be null");
            }
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                MemoryEntry.this.checkAccess(AccessMode.WRITE);
                this.owner = owner;
            }
        }
    }

    class MemoryDosFileAttributeView
    extends DelegatingFileAttributes
    implements DosFileAttributeView,
    DosFileAttributes {
        private boolean readOnly;
        private boolean hidden;
        private boolean system;
        private boolean archive;

        MemoryDosFileAttributeView() {
        }

        @Override
        public String name() {
            return "dos";
        }

        @Override
        public void initializeRoot() {
            this.hidden = true;
            this.system = true;
        }

        @Override
        public DosFileAttributes readAttributes() {
            MemoryEntry.this.checkAccess(AccessMode.READ);
            return this;
        }

        @Override
        void initializeFromSelf(FileAttributeView selfAttributes) {
            MemoryDosFileAttributeView other = (MemoryDosFileAttributeView)selfAttributes;
            this.readOnly = other.readOnly;
            this.hidden = other.hidden;
            this.system = other.system;
            this.archive = other.archive;
        }

        @Override
        public void setReadOnly(boolean value) {
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                MemoryEntry.this.checkAccess(AccessMode.WRITE);
                this.readOnly = value;
            }
        }

        @Override
        public void setHidden(boolean value) {
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                MemoryEntry.this.checkAccess(AccessMode.WRITE);
                this.hidden = value;
            }
        }

        @Override
        public void setSystem(boolean value) {
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                MemoryEntry.this.checkAccess(AccessMode.WRITE);
                this.system = value;
            }
        }

        @Override
        public void setArchive(boolean value) {
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                MemoryEntry.this.checkAccess(AccessMode.WRITE);
                this.archive = value;
            }
        }

        @Override
        public boolean isHidden() {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                boolean bl = this.hidden;
                return bl;
            }
        }

        @Override
        public boolean isArchive() {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                boolean bl = this.archive;
                return bl;
            }
        }

        @Override
        public boolean isSystem() {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                boolean bl = this.system;
                return bl;
            }
        }

        @Override
        public boolean isReadOnly() {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                boolean bl = this.readOnly;
                return bl;
            }
        }
    }

    abstract class DelegatingFileAttributes
    implements BasicFileAttributeView,
    BasicFileAttributes,
    InitializingFileAttributeView {
        DelegatingFileAttributes() {
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            MemoryEntry.this.getBasicFileAttributeView().setTimes(lastModifiedTime, lastAccessTime, createTime);
        }

        @Override
        public void initializeFrom(BasicFileAttributeView basicFileAttributeView) {
        }

        @Override
        public void initializeRoot() {
        }

        @Override
        public void initializeFrom(Map<String, ? extends FileAttributeView> additionalAttributes) {
            FileAttributeView selfAttributes = additionalAttributes.get(this.name());
            if (selfAttributes != null) {
                this.initializeFromSelf(selfAttributes);
            }
        }

        abstract void initializeFromSelf(FileAttributeView var1);

        @Override
        public FileTime lastModifiedTime() {
            return MemoryEntry.this.getBasicFileAttributes().lastModifiedTime();
        }

        @Override
        public FileTime lastAccessTime() {
            return MemoryEntry.this.getBasicFileAttributes().lastAccessTime();
        }

        @Override
        public FileTime creationTime() {
            return MemoryEntry.this.getBasicFileAttributes().creationTime();
        }

        @Override
        public boolean isRegularFile() {
            return MemoryEntry.this.getBasicFileAttributes().isRegularFile();
        }

        @Override
        public boolean isDirectory() {
            return MemoryEntry.this.getBasicFileAttributes().isDirectory();
        }

        @Override
        public boolean isSymbolicLink() {
            return MemoryEntry.this.getBasicFileAttributes().isSymbolicLink();
        }

        @Override
        public boolean isOther() {
            return MemoryEntry.this.getBasicFileAttributes().isOther();
        }

        @Override
        public long size() {
            return MemoryEntry.this.getBasicFileAttributes().size();
        }

        @Override
        public Object fileKey() {
            return MemoryEntry.this.getBasicFileAttributes().fileKey();
        }
    }

    abstract class MemoryEntryFileAttributes
    implements BasicFileAttributes {
        MemoryEntryFileAttributes() {
        }

        @Override
        public FileTime lastModifiedTime() {
            return MemoryEntry.this.lastModifiedTime();
        }

        @Override
        public FileTime lastAccessTime() {
            return MemoryEntry.this.lastAccessTime();
        }

        @Override
        public FileTime creationTime() {
            return MemoryEntry.this.creationTime();
        }
    }

    abstract class MemoryEntryFileAttributesView
    implements InitializingFileAttributeView {
        MemoryEntryFileAttributesView() {
        }

        @Override
        public String name() {
            return "basic";
        }

        @Override
        public void initializeFrom(BasicFileAttributeView basicFileAttributeView) throws IOException {
            BasicFileAttributes otherAttributes = basicFileAttributeView.readAttributes();
            this.setTimes(otherAttributes.lastModifiedTime(), otherAttributes.lastAccessTime(), otherAttributes.creationTime());
        }

        @Override
        public void initializeFrom(Map<String, ? extends FileAttributeView> additionalAttributes) {
        }

        @Override
        public void initializeRoot() {
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) {
            MemoryEntry.this.setTimes(lastModifiedTime, lastAccessTime, createTime);
        }
    }
}

