/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.FileAttributeViews;
import com.github.marschall.memoryfilesystem.MemoryFileSystemProperties;
import com.github.marschall.memoryfilesystem.StringTransformer;
import com.github.marschall.memoryfilesystem.StringTransformers;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class MemoryFileSystemBuilder {
    private final List<String> roots = new ArrayList<String>();
    private final List<String> users = new ArrayList<String>();
    private final List<String> groups = new ArrayList<String>();
    private final Set<String> additionalFileAttributeViews = new HashSet<String>();
    private String separator;
    private String currentWorkingDirectory;
    private StringTransformer storeTransformer;
    private StringTransformer lookUpTransformer;
    private StringTransformer principalTransformer;
    private Collator collator;
    private Locale locale;

    private MemoryFileSystemBuilder() {
    }

    public MemoryFileSystemBuilder addRoot(String root) {
        this.roots.add(root);
        return this;
    }

    public MemoryFileSystemBuilder setSeprator(String separator) {
        this.separator = separator;
        return this;
    }

    public MemoryFileSystemBuilder addUser(String userName) {
        this.users.add(userName);
        return this;
    }

    public MemoryFileSystemBuilder addGroup(String groupName) {
        this.groups.add(groupName);
        return this;
    }

    public MemoryFileSystemBuilder addFileAttributeView(String fileAttributeViewName) {
        if (FileAttributeViews.isSupported(fileAttributeViewName)) {
            if (!"basic".equals(fileAttributeViewName)) {
                this.additionalFileAttributeViews.add(fileAttributeViewName);
            }
        } else {
            throw new IllegalArgumentException("file attribute view \"" + fileAttributeViewName + "\" is not supported");
        }
        return this;
    }

    public MemoryFileSystemBuilder addFileAttributeView(Class<? extends FileAttributeView> fileAttributeView) {
        return this.addFileAttributeView(FileAttributeViews.mapAttributeView(fileAttributeView));
    }

    public MemoryFileSystemBuilder setCurrentWorkingDirectory(String currentWorkingDirectory) {
        this.currentWorkingDirectory = currentWorkingDirectory;
        return this;
    }

    public MemoryFileSystemBuilder setStoreTransformer(StringTransformer storeTransformer) {
        this.storeTransformer = storeTransformer;
        return this;
    }

    public MemoryFileSystemBuilder setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    private Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public MemoryFileSystemBuilder setCaseSensitive(boolean caseSensitive) {
        if (caseSensitive) {
            this.lookUpTransformer = StringTransformers.IDENTIY;
            this.collator = MemoryFileSystemProperties.caseSensitiveCollator(this.getLocale());
        } else {
            this.lookUpTransformer = StringTransformers.caseInsensitive(this.getLocale());
            this.collator = MemoryFileSystemProperties.caseInsensitiveCollator(this.getLocale());
        }
        return this;
    }

    public MemoryFileSystemBuilder setLookUpTransformer(StringTransformer lookUpTransformer) {
        this.lookUpTransformer = lookUpTransformer;
        return this;
    }

    public MemoryFileSystemBuilder setCollator(Collator collator) {
        this.collator = collator;
        return this;
    }

    public static MemoryFileSystemBuilder newEmpty() {
        return new MemoryFileSystemBuilder();
    }

    public static MemoryFileSystemBuilder newUnix() {
        return new MemoryFileSystemBuilder().addRoot("/").setSeprator("/").addUser(MemoryFileSystemBuilder.getSystemUserName()).addGroup(MemoryFileSystemBuilder.getSystemUserName()).addFileAttributeView(PosixFileAttributeView.class).setCurrentWorkingDirectory("/home/" + MemoryFileSystemBuilder.getSystemUserName()).setStoreTransformer(StringTransformers.IDENTIY).setCaseSensitive(true);
    }

    public static MemoryFileSystemBuilder newMacOs() {
        MemoryFileSystemBuilder builder = new MemoryFileSystemBuilder();
        return builder.addRoot("/").setSeprator("/").addUser(MemoryFileSystemBuilder.getSystemUserName()).addGroup(MemoryFileSystemBuilder.getSystemUserName()).addFileAttributeView(PosixFileAttributeView.class).setCurrentWorkingDirectory("/Users/" + MemoryFileSystemBuilder.getSystemUserName()).setCollator(MemoryFileSystemProperties.caseSensitiveCollator(builder.getLocale())).setLookUpTransformer(StringTransformers.caseInsensitiveMacOS(builder.getLocale())).setStoreTransformer(StringTransformers.MAC_OS);
    }

    public static MemoryFileSystemBuilder newWindows() {
        return new MemoryFileSystemBuilder().addRoot("C:\\").setSeprator("\\").addUser(MemoryFileSystemBuilder.getSystemUserName()).addGroup(MemoryFileSystemBuilder.getSystemUserName()).addFileAttributeView(DosFileAttributeView.class).setCurrentWorkingDirectory("C:\\Users\\" + MemoryFileSystemBuilder.getSystemUserName()).setStoreTransformer(StringTransformers.IDENTIY).setCaseSensitive(false);
    }

    static String getSystemUserName() {
        return System.getProperty("user.name");
    }

    public FileSystem build(String name) throws IOException {
        Map<String, ?> env = this.buildEnvironment();
        URI uri = URI.create("memory:".concat(name));
        ClassLoader classLoader = MemoryFileSystemBuilder.class.getClassLoader();
        return FileSystems.newFileSystem(uri, env, classLoader);
    }

    public Map<String, ?> buildEnvironment() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (!this.roots.isEmpty()) {
            env.put("roots", this.roots);
        }
        if (this.separator != null) {
            env.put("file.separator", this.separator);
        }
        if (this.currentWorkingDirectory != null) {
            env.put("user.dir", this.currentWorkingDirectory);
        }
        if (this.storeTransformer != null) {
            env.put("path.store.transformer", this.storeTransformer);
        }
        if (this.lookUpTransformer != null) {
            env.put("path.lookup.transformer", this.lookUpTransformer);
        }
        if (this.principalTransformer != null) {
            env.put("princial.transformer", this.principalTransformer);
        }
        if (this.collator != null) {
            env.put("collator", this.collator);
        }
        if (this.additionalFileAttributeViews != null) {
            env.put("file.attrs", this.additionalFileAttributeViews);
        }
        return env;
    }
}

