/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.FileAttributeViews;
import com.github.marschall.memoryfilesystem.MemoryFileSystemProperties;
import com.github.marschall.memoryfilesystem.StringTransformer;
import com.github.marschall.memoryfilesystem.StringTransformers;
import java.nio.file.attribute.FileAttributeView;
import java.text.Collator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class EnvironmentParser {
    private final Map<String, ?> env;
    private List<String> roots;

    EnvironmentParser(Map<String, ?> env) {
        this.env = env;
    }

    List<String> getRoots() {
        if (this.roots == null) {
            this.roots = this.parseStringProperty("roots", false);
            if (this.roots == null) {
                this.roots = this.getDefaultRoots();
            } else {
                this.validateRoots(this.roots);
            }
        }
        return this.roots;
    }

    List<String> getUserNames() {
        List<String> userNames = this.parseStringProperty("users", false);
        if (userNames == null) {
            return Collections.singletonList(this.getSystemUserName());
        }
        return userNames;
    }

    StringTransformer getStoreTransformer() {
        return this.getStringTranformer("path.store.transformer");
    }

    StringTransformer getLookUpTransformer() {
        return this.getStringTranformer("path.lookup.transformer");
    }

    StringTransformer getStringTranformer(String property) {
        Object value = this.env.get(property);
        if (value != null) {
            if (value instanceof StringTransformer) {
                return (StringTransformer)value;
            }
            throw new IllegalArgumentException(property + " must be a " + StringTransformer.class + " but was " + value.getClass());
        }
        return StringTransformers.IDENTIY;
    }

    Collator getCollator() {
        String property = "collator";
        Object value = this.env.get(property);
        if (value != null) {
            if (value instanceof Collator) {
                return (Collator)value;
            }
            throw new IllegalArgumentException(property + " must be a " + Collator.class + " but was " + value.getClass());
        }
        return MemoryFileSystemProperties.caseSensitiveCollator(Locale.getDefault());
    }

    Set<Class<? extends FileAttributeView>> getAdditionalViews() {
        String property = "file.attrs";
        Object value = this.env.get(property);
        if (value != null) {
            if (value instanceof Set) {
                Set values = (Set)value;
                if (values.isEmpty()) {
                    return Collections.emptySet();
                }
                if (values.size() == 1) {
                    Object viewName = values.iterator().next();
                    if (viewName instanceof String) {
                        Class<? extends FileAttributeView> viewClass = FileAttributeViews.mapAttributeViewName((String)viewName);
                        return Collections.singleton(viewClass);
                    }
                    throw new IllegalArgumentException(property + " values must be a " + String.class + " but was " + viewName);
                }
                HashSet<Class<? extends FileAttributeView>> views = new HashSet<Class<? extends FileAttributeView>>(values.size());
                for (Object viewName : values) {
                    if (viewName instanceof String) {
                        Class<? extends FileAttributeView> viewClass = FileAttributeViews.mapAttributeViewName((String)viewName);
                        views.add(viewClass);
                        continue;
                    }
                    throw new IllegalArgumentException(property + " values must be a " + String.class + " but was " + viewName);
                }
                return views;
            }
            throw new IllegalArgumentException(property + " must be a " + Set.class + " but was " + value.getClass());
        }
        return Collections.emptySet();
    }

    StringTransformer getPrincipalNameTransfomer() {
        return this.getStringTranformer("princial.transformer");
    }

    String getDefaultDirectory() {
        Object value = this.env.get("user.dir");
        if (value != null) {
            if (value instanceof String) {
                return (String)value;
            }
            throw new IllegalArgumentException("user.dir must be a " + String.class + " but was " + value.getClass());
        }
        return this.getRoots().get(0);
    }

    String getSystemUserName() {
        return System.getProperty("user.name");
    }

    List<String> getGroupNames() {
        List<String> groupNames = this.parseStringProperty("users", true);
        if (groupNames == null) {
            return Collections.emptyList();
        }
        return groupNames;
    }

    private List<String> parseStringProperty(String key, boolean allowEmpty) {
        Object value = this.env.get(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof List)) {
            throw new IllegalArgumentException("value of " + key + " must be an instance of " + List.class + " but was " + value.getClass());
        }
        List values = (List)value;
        if (!allowEmpty && values.isEmpty()) {
            throw new IllegalArgumentException("value of " + key + " must not be empty");
        }
        if (values.size() == 1) {
            Object singleValue = values.get(0);
            if (singleValue instanceof String) {
                String stringValue = (String)singleValue;
                return Collections.singletonList(stringValue);
            }
            throw new IllegalArgumentException(key + " must be a String but was " + singleValue.getClass());
        }
        for (Object each : values) {
            if (each == null) {
                throw new IllegalArgumentException("each value of " + key + " must be a String but was null");
            }
            if (each instanceof String) continue;
            throw new IllegalArgumentException("each value of " + key + " must be a String but was " + each.getClass());
        }
        List returnValue = values;
        return returnValue;
    }

    private void validateRoots(List<String> roots) {
        if (roots.size() == 1) {
            String root = roots.get(0);
            if (!this.isUnixRoot(root) && !this.isWindowsRoot(root)) {
                throw this.invalidRoot(root);
            }
        } else {
            for (String root : roots) {
                if (this.isWindowsRoot(root)) continue;
                throw this.invalidRoot(root);
            }
        }
    }

    private IllegalArgumentException invalidRoot(String root) {
        return new IllegalArgumentException("roots have to either be \"\" or \"[A-Z]:\\\" (mixing is not allowed) \"" + root + "\"doesn't fit");
    }

    private boolean isWindowsRoot(String root) {
        return root.length() == 3 && root.charAt(0) >= 'A' && root.charAt(0) <= 'Z' && root.endsWith(":\\");
    }

    private boolean isUnixRoot(String root) {
        return "/".equals(root);
    }

    private List<String> getDefaultRoots() {
        return MemoryFileSystemProperties.DEFAULT_ROOTS;
    }

    String getSeparator() {
        Object property = this.env.get("file.separator");
        if (property == null) {
            return "/";
        }
        if (property instanceof String) {
            String separator = (String)property;
            this.validateSeparator(separator);
            return separator;
        }
        throw new IllegalArgumentException("the value of the property 'file.separator' has to be of class " + String.class.getName() + " but was " + property.getClass().getName());
    }

    private void validateSeparator(String separator) {
        if (!"/".equals(separator) && !"\\".equals(separator)) {
            throw new IllegalArgumentException("only \"/\" and \"\\\" are valid separators, \"" + separator + "\" is invalid");
        }
    }

    boolean isSingleEmptyRoot() {
        return this.getRoots().size() == 1 && "/".equals(this.getRoots().get(0));
    }
}

