/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AutoRelease;
import com.github.marschall.memoryfilesystem.BlockChannel;
import com.github.marschall.memoryfilesystem.MemoryContents;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;

final class AppendingBlockChannel
extends BlockChannel {
    private final long startPosition;

    AppendingBlockChannel(MemoryContents memoryContents, boolean readable, long startPosition, boolean deleteOnClose, Path path) {
        super(memoryContents, readable, deleteOnClose, path);
        this.startPosition = startPosition;
    }

    @Override
    void writeCheck() throws ClosedChannelException {
        this.closedCheck();
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        throw new IOException("truncation not supported in append mode");
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        throw new IOException("writing to a given position is not supported in append mode");
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            int written = this.memoryContents.writeAtEnd(src);
            this.position = this.memoryContents.size();
            int n = written;
            return n;
        }
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        throw new IOException("writing to a given position is not supported in append mode");
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        this.validateOffsetAndLength(srcs, offset, length);
        try (AutoRelease lock = this.writeLock();){
            long written;
            long totalWritten = 0L;
            for (int i = 0; i < length && totalWritten != Long.MAX_VALUE; totalWritten += written, ++i) {
                written = this.memoryContents.writeAtEnd(srcs[offset + 1], Long.MAX_VALUE - totalWritten);
                if (written != -1L) {
                    this.position += written;
                    continue;
                }
                if (i != 0) break;
                long l = -1L;
                return l;
            }
            long l = totalWritten;
            return l;
        }
    }

    @Override
    public void force(boolean metaData) throws IOException {
        if (metaData) {
            this.memoryContents.modified();
        }
    }
}

