/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.portlet.server.result;

import org.springframework.http.HttpStatus;
import org.springframework.test.web.AssertionErrors;
import org.springframework.test.web.portlet.server.PortletMvcResult;
import org.springframework.test.web.portlet.server.PortletResultMatcher;

public class StatusResultMatchers {
    protected StatusResultMatchers() {
    }

    public PortletResultMatcher isOk() {
        return this.matcher(HttpStatus.OK);
    }

    public PortletResultMatcher matches(HttpStatus httpStatus) {
        return this.matcher(httpStatus);
    }

    private PortletResultMatcher matcher(final HttpStatus status) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult result) {
                String statusInRequest = result.getResponse().getProperty("portlet.http-status-code");
                Integer intStatus = statusInRequest != null ? Integer.valueOf(statusInRequest) : null;
                AssertionErrors.assertEquals("Status", status.value(), intStatus);
            }
        };
    }
}

