/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.portlet.server.result;

import javax.portlet.PortletPreferences;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.springframework.test.web.AssertionErrors;
import org.springframework.test.web.portlet.server.PortletMvcResult;
import org.springframework.test.web.portlet.server.PortletResultMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesResultMatchers {
    protected PreferencesResultMatchers() {
    }

    public PortletResultMatcher has(final String name, final Matcher<String> matcher) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult result) throws Exception {
                MatcherAssert.assertThat((String)("Preference '" + name + "'"), (Object)PreferencesResultMatchers.this.getPortletPreferences(result).getValue(name, null), (Matcher)matcher);
            }
        };
    }

    public PortletResultMatcher has(String name, String value) {
        return this.has(name, (Matcher<String>)Matchers.equalTo((Object)value));
    }

    public PortletResultMatcher exists(final String ... names) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult result) throws Exception {
                PortletPreferences preferences = PreferencesResultMatchers.this.getPortletPreferences(result);
                for (String name : names) {
                    MatcherAssert.assertThat((String)("Preference '" + name + "'"), preferences.getMap().keySet(), (Matcher)Matchers.hasItem((Object)name));
                }
            }
        };
    }

    public PortletResultMatcher count(final int count) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult result) throws Exception {
                AssertionErrors.assertEquals("Preference count", count, PreferencesResultMatchers.this.getPortletPreferences(result).getMap().size());
            }
        };
    }

    private PortletPreferences getPortletPreferences(PortletMvcResult result) {
        return result.getRequest().getPreferences();
    }
}

