/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.portlet.server;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.springframework.mock.web.portlet.MockActionRequest;
import org.springframework.mock.web.portlet.MockActionResponse;
import org.springframework.mock.web.portlet.MockPortletRequest;
import org.springframework.mock.web.portlet.MockPortletResponse;
import org.springframework.mock.web.portlet.MockRenderRequest;
import org.springframework.mock.web.portlet.MockRenderResponse;
import org.springframework.mock.web.portlet.MockResourceRequest;
import org.springframework.mock.web.portlet.MockResourceResponse;
import org.springframework.test.web.portlet.server.DefaultPortletMvcResult;
import org.springframework.test.web.portlet.server.PortletMvcResult;
import org.springframework.test.web.portlet.server.PortletResultActions;
import org.springframework.test.web.portlet.server.PortletResultHandler;
import org.springframework.test.web.portlet.server.PortletResultMatcher;
import org.springframework.test.web.portlet.server.request.ActionRequestBuilder;
import org.springframework.test.web.portlet.server.request.RenderRequestBuilder;
import org.springframework.test.web.portlet.server.request.ResourceRequestBuilder;

public class PortletMockMvc {
    static String MVC_RESULT_ATTRIBUTE = PortletMockMvc.class.getName().concat(".MVC_RESULT_ATTRIBUTE");
    private final GenericPortlet portlet;

    PortletMockMvc(GenericPortlet portlet) {
        this.portlet = portlet;
    }

    public PortletResultActions perform(RenderRequestBuilder builder) throws Exception {
        MockRenderRequest request = builder.buildRequest();
        MockRenderResponse response = new MockRenderResponse();
        DefaultPortletMvcResult mvcResult = new DefaultPortletMvcResult((MockPortletRequest)request, (MockPortletResponse)response);
        request.setAttribute(MVC_RESULT_ATTRIBUTE, (Object)mvcResult);
        this.portlet.render((RenderRequest)request, (RenderResponse)response);
        return new DefaultResultActions(mvcResult);
    }

    public PortletResultActions perform(ActionRequestBuilder builder) throws Exception {
        MockActionRequest request = builder.buildRequest();
        MockActionResponse response = new MockActionResponse();
        DefaultPortletMvcResult mvcResult = new DefaultPortletMvcResult((MockPortletRequest)request, (MockPortletResponse)response);
        request.setAttribute(MVC_RESULT_ATTRIBUTE, (Object)mvcResult);
        this.portlet.processAction((ActionRequest)request, (ActionResponse)response);
        return new DefaultResultActions(mvcResult);
    }

    public PortletResultActions perform(ResourceRequestBuilder builder) throws Exception {
        MockResourceRequest request = builder.buildRequest();
        MockResourceResponse response = new MockResourceResponse();
        DefaultPortletMvcResult mvcResult = new DefaultPortletMvcResult((MockPortletRequest)request, (MockPortletResponse)response);
        request.setAttribute(MVC_RESULT_ATTRIBUTE, (Object)mvcResult);
        this.portlet.serveResource((ResourceRequest)request, (ResourceResponse)response);
        return new DefaultResultActions(mvcResult);
    }

    private static class DefaultResultActions
    implements PortletResultActions {
        private PortletMvcResult mvcResult;

        public DefaultResultActions(PortletMvcResult mvcResult) {
            this.mvcResult = mvcResult;
        }

        public PortletResultActions andExpect(PortletResultMatcher matcher) throws Exception {
            matcher.match(this.mvcResult);
            return this;
        }

        public PortletResultActions andDo(PortletResultHandler printer) throws Exception {
            printer.handle(this.mvcResult);
            return this;
        }

        public PortletMvcResult andReturn() {
            return this.mvcResult;
        }
    }
}

