/*
 * Decompiled with CFR 0.152.
 */
package com.marcoscg.ratedialog;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import com.marcoscg.ratedialog.R;

public class RateDialog {
    public static int DEFAULT_DAYS_UNTIL_PROMPT = 3;
    public static int DEFAULT_LAUNCHES_UNTIL_PROMPT = 7;
    private static String DEFAULT_DIALOG_KEY = "default_rate_dialog_key";
    private Activity activity;
    private AlertDialog alertDialog;
    private SharedPreferences prefs;
    private int daysUntilPrompt;
    private int launchesUntilPrompt;

    public RateDialog(Activity activity, String dialogKey) {
        this(activity, dialogKey, DEFAULT_DAYS_UNTIL_PROMPT, DEFAULT_LAUNCHES_UNTIL_PROMPT);
    }

    public RateDialog(Activity activity) {
        this(activity, DEFAULT_DIALOG_KEY);
    }

    public RateDialog(Activity activity, String dialogKey, int daysUntilPrompt, int launchesUntilPrompt) {
        this.activity = activity;
        this.daysUntilPrompt = daysUntilPrompt;
        this.launchesUntilPrompt = launchesUntilPrompt;
        this.prefs = activity.getSharedPreferences(dialogKey + "_rdp", 0);
        this.setupDialog();
    }

    public RateDialog(Activity activity, int daysUntilPrompt, int launchesUntilPrompt) {
        this(activity, DEFAULT_DIALOG_KEY, daysUntilPrompt, launchesUntilPrompt);
    }

    @Deprecated
    public static void with(Activity activity) {
        RateDialog.init(activity);
    }

    @Deprecated
    public static void with(Activity activity, int daysUntilPrompt, int launchesUntilPrompt) {
        RateDialog.init(activity, daysUntilPrompt, launchesUntilPrompt);
    }

    public static void init(Activity activity) {
        RateDialog.init(activity, DEFAULT_DAYS_UNTIL_PROMPT, DEFAULT_LAUNCHES_UNTIL_PROMPT);
    }

    public static void init(Activity activity, int daysUntilPrompt, int launchesUntilPrompt) {
        new RateDialog(activity, DEFAULT_DIALOG_KEY, daysUntilPrompt, launchesUntilPrompt).init();
    }

    @Deprecated
    public static void show(Activity activity) {
        RateDialog.showDialog(activity);
    }

    public static void showDialog(Activity activity) {
        new RateDialog(activity, DEFAULT_DIALOG_KEY).showDialog();
    }

    public void init() {
        if (this.prefs == null || this.prefs.getBoolean("do_not_show_again", false)) {
            return;
        }
        long launchCount = this.prefs.getLong("launch_count", 0L) + 1L;
        this.prefs.edit().putLong("launch_count", launchCount).apply();
        long dateFirstLaunch = this.prefs.getLong("date_first_launch", 0L);
        if (dateFirstLaunch == 0L) {
            dateFirstLaunch = System.currentTimeMillis();
            this.prefs.edit().putLong("date_first_launch", dateFirstLaunch).apply();
        }
        if (launchCount >= (long)this.launchesUntilPrompt && System.currentTimeMillis() >= dateFirstLaunch + (long)(this.daysUntilPrompt * 24 * 60 * 60 * 1000)) {
            this.showDialog();
        }
    }

    public void showDialog() {
        if (this.alertDialog != null) {
            this.alertDialog.show();
        }
    }

    private void neverShow() {
        if (this.prefs != null) {
            this.prefs.edit().putBoolean("do_not_show_again", true).apply();
        }
    }

    private void setupDialog() {
        LayoutInflater inflater = this.activity.getLayoutInflater();
        View view = inflater.inflate(R.layout.dialog_layout, null);
        TextView title = (TextView)view.findViewById(R.id.title);
        TextView message = (TextView)view.findViewById(R.id.message);
        title.setText((CharSequence)String.format(this.activity.getResources().getString(R.string.rate_dialog_title), this.activity.getResources().getString(R.string.app_name)));
        message.setText((CharSequence)this.activity.getString(R.string.rate_dialog_message, new Object[]{this.activity.getResources().getString(R.string.app_name)}));
        this.alertDialog = new AlertDialog.Builder((Context)this.activity).setView(view).setPositiveButton((CharSequence)this.activity.getResources().getString(R.string.rate_dialog_action_rate), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                try {
                    RateDialog.this.activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + RateDialog.this.activity.getPackageName()))));
                }
                catch (ActivityNotFoundException anfe) {
                    RateDialog.this.activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + RateDialog.this.activity.getPackageName()))));
                }
                RateDialog.this.neverShow();
                Toast.makeText((Context)RateDialog.this.activity, (CharSequence)RateDialog.this.activity.getResources().getString(R.string.rate_dialog_thank_you), (int)0).show();
            }
        }).setNeutralButton((CharSequence)this.activity.getResources().getString(R.string.rate_dialog_action_later), null).setNegativeButton((CharSequence)this.activity.getResources().getString(R.string.rate_dialog_action_never), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                RateDialog.this.neverShow();
            }
        }).create();
        this.alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                RateDialog.this.setButtonStyle(RateDialog.this.alertDialog.getButton(-1));
                RateDialog.this.setButtonStyle(RateDialog.this.alertDialog.getButton(-3));
                RateDialog.this.setButtonStyle(RateDialog.this.alertDialog.getButton(-2));
            }
        });
    }

    private void setButtonStyle(Button button) {
        if (Build.VERSION.SDK_INT >= 21) {
            button.setPadding(this.dpToPx(14), 0, this.dpToPx(14), 0);
        } else {
            button.setPadding(this.dpToPx(12), 0, this.dpToPx(12), 0);
        }
        button.setTypeface(Typeface.createFromAsset((AssetManager)this.activity.getAssets(), (String)"medium.ttf"));
    }

    private int dpToPx(int dp) {
        return (int)((float)dp * Resources.getSystem().getDisplayMetrics().density);
    }
}

