/*
 * Decompiled with CFR 0.152.
 */
package com.marcoscg.ratedialog;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.widget.TextView;

public class TitleTextView
extends TextView {
    private Context ctx;

    public TitleTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.ctx = context;
        this.init();
    }

    public TitleTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.ctx = context;
        this.init();
    }

    public TitleTextView(Context context) {
        super(context);
        this.ctx = context;
        this.init();
    }

    private void init() {
        Typeface tf = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)"medium.ttf");
        this.setTypeface(tf);
        this.setTextColor(this.getPrimaryTextColor(this.ctx));
    }

    private int getPrimaryTextColor(Context context) {
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        theme.resolveAttribute(16842806, typedValue, true);
        TypedArray arr = context.obtainStyledAttributes(typedValue.data, new int[]{16842806});
        int color = arr.getColor(0, -1);
        arr.recycle();
        return color;
    }
}

