/*
 * Decompiled with CFR 0.152.
 */
package com.marcoscg.fingerauth;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Handler;
import android.support.annotation.StringRes;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.AppCompatImageView;
import android.view.View;
import android.widget.TextView;
import com.marcoscg.fingerauth.FingerAuth;
import com.marcoscg.fingerauth.R;

public class FingerAuthDialog {
    private AlertDialog.Builder builder;
    private AlertDialog alertDialog;
    private FingerAuth.OnFingerAuthListener onFingerAuthListener;
    private AppCompatImageView imageView;
    private TextView textView;
    private FingerAuth fingerAuth;
    private int successDelay = 1000;

    public FingerAuthDialog(Activity activity) {
        this.builder = new AlertDialog.Builder((Context)activity, R.style.FingerAuthDialogStyle);
        this.builder.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                FingerAuthDialog.this.dismiss();
            }
        });
        this.builder.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                if (FingerAuthDialog.this.fingerAuth != null) {
                    FingerAuthDialog.this.fingerAuth.cancelSignal();
                }
            }
        });
        View dialogView = activity.getLayoutInflater().inflate(R.layout.fingerauth_dialog_content, null);
        this.imageView = (AppCompatImageView)dialogView.findViewById(R.id.fingerauth_dialog_icon);
        this.textView = (TextView)dialogView.findViewById(R.id.fingerauth_dialog_status);
        this.builder.setView(dialogView);
        this.init((Context)activity);
    }

    public FingerAuthDialog setTitle(CharSequence title) {
        this.builder.setTitle(title);
        return this;
    }

    public FingerAuthDialog setCancelable(boolean cancelable) {
        this.builder.setCancelable(cancelable);
        return this;
    }

    public FingerAuthDialog setPositiveButton(CharSequence text, DialogInterface.OnClickListener onClickListener) {
        this.builder.setPositiveButton(text, onClickListener);
        return this;
    }

    public FingerAuthDialog setPositiveButton(@StringRes int text, DialogInterface.OnClickListener onClickListener) {
        this.builder.setPositiveButton(text, onClickListener);
        return this;
    }

    public FingerAuthDialog setNegativeButton(CharSequence text, DialogInterface.OnClickListener onClickListener) {
        this.builder.setNegativeButton(text, onClickListener);
        return this;
    }

    public FingerAuthDialog setNegativeButton(@StringRes int text, DialogInterface.OnClickListener onClickListener) {
        this.builder.setNegativeButton(text, onClickListener);
        return this;
    }

    public FingerAuthDialog setMaxFailedCount(int maxFailedCount) {
        if (this.fingerAuth != null) {
            this.fingerAuth.setMaxFailedCount(maxFailedCount);
        }
        return this;
    }

    public FingerAuthDialog setSuccessDelay(int successDelayMillis) {
        this.successDelay = successDelayMillis;
        return this;
    }

    public FingerAuthDialog setOnFingerAuthListener(FingerAuth.OnFingerAuthListener onFingerAuthListener) {
        this.onFingerAuthListener = onFingerAuthListener;
        return this;
    }

    public void show() {
        if (this.alertDialog == null) {
            this.alertDialog = this.builder.create();
        }
        this.alertDialog.show();
    }

    public void dismiss() {
        if (this.alertDialog != null) {
            this.alertDialog.dismiss();
        }
    }

    private void init(final Context context) {
        this.fingerAuth = new FingerAuth(context);
        this.fingerAuth.setOnFingerAuthListener(new FingerAuth.OnFingerAuthListener(){

            @Override
            public void onFailure() {
                FingerAuthDialog.this.imageView.setImageDrawable(ResourcesCompat.getDrawable((Resources)context.getResources(), (int)R.drawable.ic_fingerprint_error, null));
                FingerAuthDialog.this.textView.setText((CharSequence)context.getResources().getString(R.string.fingerauth_dialog_not_recognized));
                FingerAuthDialog.this.textView.setTextColor(context.getResources().getColor(R.color.fingerauth_dialog_color_error));
                FingerAuthDialog.this.onFingerAuthListener.onFailure();
            }

            @Override
            public void onError() {
                FingerAuthDialog.this.onFingerAuthListener.onError();
                FingerAuthDialog.this.dismiss();
            }

            @Override
            public void onSuccess() {
                FingerAuthDialog.this.imageView.setImageDrawable(ResourcesCompat.getDrawable((Resources)context.getResources(), (int)R.drawable.ic_fingerprint_success, null));
                FingerAuthDialog.this.textView.setText((CharSequence)context.getResources().getString(R.string.fingerauth_dialog_success));
                FingerAuthDialog.this.textView.setTextColor(context.getResources().getColor(R.color.fingerauth_dialog_color_accent));
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        FingerAuthDialog.this.onFingerAuthListener.onSuccess();
                        FingerAuthDialog.this.dismiss();
                    }
                }, (long)FingerAuthDialog.this.successDelay);
            }
        });
    }

    static {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
    }
}

