/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.managers;

import com.wasteofplastic.askyblock.ASkyBlock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public final class PermissionsManager {
    private SimpleClans plugin;
    private static Permission permission = null;
    private static Economy economy = null;
    private static Chat chat = null;
    private static ASkyBlock skyblock;
    private HashMap<String, List<String>> permissions = new HashMap();
    private HashMap<Player, PermissionAttachment> permAttaches = new HashMap();

    public PermissionsManager() {
        this.plugin = SimpleClans.getInstance();
        try {
            Class.forName("net.milkbowl.vault.permission.Permission");
            this.setupChat();
            this.setupEconomy();
            this.setupPermissions();
        }
        catch (ClassNotFoundException e) {
            SimpleClans.log("[SimpleClans] Vault not found. No economy or extended Permissions support.", new Object[0]);
        }
        this.detectSkyBlock();
    }

    private void detectSkyBlock() {
        Plugin test;
        if (skyblock == null && (test = this.plugin.getServer().getPluginManager().getPlugin("ASkyBlock")) != null) {
            skyblock = (ASkyBlock)test;
        }
    }

    public boolean hasEconomy() {
        return economy != null && economy.isEnabled();
    }

    public void loadPermissions() {
        SimpleClans.getInstance().getSettingsManager().load();
        this.permissions.clear();
        for (Clan clan : this.plugin.getClanManager().getClans()) {
            this.permissions.put(clan.getTag(), SimpleClans.getInstance().getConfig().getStringList("permissions." + clan.getTag()));
        }
    }

    public void savePermissions() {
        for (Clan clan : this.plugin.getClanManager().getClans()) {
            if (!this.permissions.containsKey(clan.getTag())) continue;
            SimpleClans.getInstance().getSettingsManager().getConfig().set("permissions." + clan.getTag(), this.getPermissions(clan));
        }
        SimpleClans.getInstance().getSettingsManager().save();
    }

    public void updateClanPermissions(Clan clan) {
        for (ClanPlayer cp : clan.getMembers()) {
            this.addPlayerPermissions(cp);
        }
    }

    public void addPlayerPermissions(ClanPlayer cp) {
        if (cp != null && cp.toPlayer() != null) {
            Player player = cp.toPlayer();
            if (this.permissions.containsKey(cp.getClan().getTag())) {
                if (!this.permAttaches.containsKey(cp.toPlayer())) {
                    this.permAttaches.put(cp.toPlayer(), cp.toPlayer().addAttachment((Plugin)SimpleClans.getInstance()));
                }
                for (String perm : this.getPermissions(cp.getClan())) {
                    this.permAttaches.get(cp.toPlayer()).setPermission(perm, true);
                }
                if (this.plugin.getSettingsManager().isAutoGroupGroupName()) {
                    this.permAttaches.get(cp.toPlayer()).setPermission("group." + cp.getClan().getTag(), true);
                }
                player.recalculatePermissions();
            }
        }
    }

    public void removeClanPermissions(Clan clan) {
        for (ClanPlayer cp : clan.getMembers()) {
            this.removeClanPlayerPermissions(cp);
        }
    }

    public void removeClanPlayerPermissions(ClanPlayer cp) {
        Player player;
        if (cp != null && cp.getClan() != null && cp.toPlayer() != null && (player = cp.toPlayer()).isOnline() && this.permissions.containsKey(cp.getClan().getTag()) && this.permAttaches.containsKey(player)) {
            this.permAttaches.get(player).remove();
            this.permAttaches.remove(player);
        }
    }

    public List<String> getPermissions(Clan clan) {
        return this.permissions.get(clan.getTag());
    }

    public Map<Player, PermissionAttachment> getPermAttaches() {
        return this.permAttaches;
    }

    public boolean playerChargeMoney(Player player, double money) {
        return economy.withdrawPlayer(player.getName(), money).transactionSuccess();
    }

    public boolean playerGrantMoney(Player player, double money) {
        return economy.depositPlayer(player.getName(), money).transactionSuccess();
    }

    public boolean playerGrantMoney(String player, double money) {
        return economy.depositPlayer(player, money).transactionSuccess();
    }

    public boolean playerHasMoney(Player player, double money) {
        return economy.has(player.getName(), money);
    }

    public double playerGetMoney(Player player) {
        return economy.getBalance(player.getName());
    }

    public boolean has(Player player, String perm) {
        if (player == null) {
            return false;
        }
        if (permission != null) {
            return permission.has(player, perm);
        }
        return player.hasPermission(perm);
    }

    public void addClanPermissions(ClanPlayer cp) {
        if (!this.plugin.getSettingsManager().isEnableAutoGroups()) {
            return;
        }
        if (permission != null && cp != null && cp.toPlayer() != null) {
            if (cp.getClan() != null) {
                if (!permission.playerInGroup(cp.toPlayer(), "clan." + cp.getTag())) {
                    permission.playerAddGroup(cp.toPlayer(), "clan." + cp.getTag());
                }
                if (cp.isLeader()) {
                    if (!permission.playerInGroup(cp.toPlayer(), "sc.leader")) {
                        permission.playerAddGroup(cp.toPlayer(), "sc.leader");
                    }
                    permission.playerRemoveGroup(cp.toPlayer(), "sc.untrusted");
                    permission.playerRemoveGroup(cp.toPlayer(), "sc.trusted");
                    return;
                }
                if (cp.isTrusted()) {
                    if (!permission.playerInGroup(cp.toPlayer(), "sc.trusted")) {
                        permission.playerAddGroup(cp.toPlayer(), "sc.trusted");
                    }
                    permission.playerRemoveGroup(cp.toPlayer(), "sc.untrusted");
                    permission.playerRemoveGroup(cp.toPlayer(), "sc.leader");
                    return;
                }
                if (!permission.playerInGroup(cp.toPlayer(), "sc.untrusted")) {
                    permission.playerAddGroup(cp.toPlayer(), "sc.untrusted");
                }
                permission.playerRemoveGroup(cp.toPlayer(), "sc.trusted");
                permission.playerRemoveGroup(cp.toPlayer(), "sc.leader");
            } else {
                permission.playerRemoveGroup(cp.toPlayer(), "sc.untrusted");
                permission.playerRemoveGroup(cp.toPlayer(), "sc.trusted");
                permission.playerRemoveGroup(cp.toPlayer(), "sc.leader");
            }
        }
    }

    public void removeClanPermissions(ClanPlayer cp) {
        if (!this.plugin.getSettingsManager().isEnableAutoGroups()) {
            return;
        }
        if (permission != null && cp.toPlayer() != null) {
            permission.playerRemoveGroup(cp.toPlayer(), "clan." + cp.getTag());
            permission.playerRemoveGroup(cp.toPlayer(), "sc.untrusted");
            permission.playerRemoveGroup(cp.toPlayer(), "sc.trusted");
            permission.playerRemoveGroup(cp.toPlayer(), "sc.leader");
        }
    }

    private Boolean setupPermissions() {
        RegisteredServiceProvider permissionProvider = this.plugin.getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider != null) {
            permission = (Permission)permissionProvider.getProvider();
        }
        return permission != null;
    }

    private Boolean setupChat() {
        RegisteredServiceProvider chatProvider = this.plugin.getServer().getServicesManager().getRegistration(Chat.class);
        if (chatProvider != null) {
            chat = (Chat)chatProvider.getProvider();
        }
        return chat != null;
    }

    private Boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            economy = (Economy)economyProvider.getProvider();
        }
        return economy != null;
    }

    public String getPrefix(Player p) {
        String out = "";
        try {
            if (chat != null) {
                out = chat.getPlayerPrefix(p);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (permission != null && chat != null) {
            try {
                String group;
                String world = p.getWorld().getName();
                String name = p.getName();
                String prefix = chat.getPlayerPrefix(name, world);
                if ((prefix == null || prefix.isEmpty()) && (prefix = chat.getGroupPrefix(world, group = permission.getPrimaryGroup(world, name))) == null) {
                    prefix = "";
                }
                out = prefix.replace("&", "\u00a7").replace(String.valueOf('\u00c2'), "");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return out;
    }

    public String getSuffix(Player p) {
        try {
            if (chat != null) {
                return chat.getPlayerSuffix(p);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (permission != null && chat != null) {
            try {
                String group;
                String world = p.getWorld().getName();
                String name = p.getName();
                String suffix = chat.getPlayerSuffix(world, name);
                if ((suffix == null || suffix.isEmpty()) && (suffix = chat.getPlayerSuffix(world, group = permission.getPrimaryGroup(world, name))) == null) {
                    suffix = "";
                }
                return suffix.replace("&", "\u00a7").replace(String.valueOf('\u00c2'), "");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                return "";
            }
        }
        return "";
    }
}

