/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.commands;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.List;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ListCommand {
    public void execute(Player player, String[] arg) {
        SimpleClans plugin = SimpleClans.getInstance();
        String headColor = plugin.getSettingsManager().getPageHeadingsColor();
        String subColor = plugin.getSettingsManager().getPageSubTitleColor();
        DecimalFormat formatter = new DecimalFormat("#.#");
        if (!plugin.getPermissionsManager().has(player, "simpleclans.anyone.list")) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
            return;
        }
        if (arg.length != 0) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + MessageFormat.format(plugin.getLang("usage.list"), plugin.getSettingsManager().getCommandClan()));
            return;
        }
        List<Clan> clans = plugin.getClanManager().getClans();
        plugin.getClanManager().sortClansByKDR(clans);
        if (clans.isEmpty()) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("no.clans.have.been.created"));
            return;
        }
        ChatBlock chatBlock = new ChatBlock();
        ChatBlock.sendBlank((CommandSender)player);
        ChatBlock.saySingle((CommandSender)player, plugin.getSettingsManager().getServerName() + subColor + " " + plugin.getLang("clans.lower") + " " + headColor + Helper.generatePageSeparator(plugin.getSettingsManager().getPageSep()));
        ChatBlock.sendBlank((CommandSender)player);
        ChatBlock.sendMessage((CommandSender)player, headColor + plugin.getLang("total.clans") + " " + subColor + clans.size());
        ChatBlock.sendBlank((CommandSender)player);
        chatBlock.setAlignment("c", "l", "c", "c");
        chatBlock.setFlexibility(false, true, false, false);
        chatBlock.addRow("  " + headColor + plugin.getLang("rank"), plugin.getLang("name"), plugin.getLang("kdr"), plugin.getLang("members"));
        int rank = 1;
        for (Clan clan : clans) {
            if (!plugin.getSettingsManager().isShowUnverifiedOnList() && !clan.isVerified()) continue;
            String tag = plugin.getSettingsManager().getClanChatBracketColor() + plugin.getSettingsManager().getClanChatTagBracketLeft() + plugin.getSettingsManager().getTagDefaultColor() + clan.getColorTag() + plugin.getSettingsManager().getClanChatBracketColor() + plugin.getSettingsManager().getClanChatTagBracketRight();
            String name = (clan.isVerified() ? plugin.getSettingsManager().getPageClanNameColor() : ChatColor.GRAY) + clan.getName();
            String fullname = tag + " " + name;
            String size = ChatColor.WHITE + "" + clan.getSize();
            String kdr = clan.isVerified() ? ChatColor.YELLOW + "" + formatter.format(clan.getTotalKDR()) : "";
            chatBlock.addRow("  " + rank, fullname, kdr, size);
            ++rank;
        }
        boolean more = chatBlock.sendBlock((CommandSender)player, plugin.getSettingsManager().getPageSize());
        if (more) {
            plugin.getStorageManager().addChatBlock((CommandSender)player, chatBlock);
            ChatBlock.sendBlank((CommandSender)player);
            ChatBlock.sendMessage((CommandSender)player, headColor + MessageFormat.format(plugin.getLang("view.next.page"), plugin.getSettingsManager().getCommandMore()));
        }
        ChatBlock.sendBlank((CommandSender)player);
    }
}

