/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.commands;

import java.text.MessageFormat;
import java.util.UUID;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.uuid.UUIDMigration;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DemoteCommand {
    public void execute(Player player, String[] arg) {
        boolean allOtherLeadersOnline;
        UUID PlayerUniqueId;
        SimpleClans plugin = SimpleClans.getInstance();
        if (!plugin.getPermissionsManager().has(player, "simpleclans.leader.demote")) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
            return;
        }
        ClanPlayer cp = plugin.getClanManager().getClanPlayer(player);
        if (cp == null) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("not.a.member.of.any.clan"));
            return;
        }
        Clan clan = cp.getClan();
        if (!clan.isLeader(player)) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("no.leader.permissions"));
            return;
        }
        if (arg.length != 1) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + MessageFormat.format(plugin.getLang("usage.demote.leader"), plugin.getSettingsManager().getCommandClan()));
            return;
        }
        String demotedName = arg[0];
        if (demotedName == null) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("no.player.matched"));
            return;
        }
        if (SimpleClans.getInstance().hasUUID()) {
            PlayerUniqueId = UUIDMigration.getForcedPlayerUUID(demotedName);
            if (PlayerUniqueId == null) {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("no.player.matched"));
                return;
            }
            allOtherLeadersOnline = clan.allOtherLeadersOnline(PlayerUniqueId);
        } else {
            allOtherLeadersOnline = clan.allOtherLeadersOnline(demotedName);
        }
        if (!allOtherLeadersOnline) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("leaders.must.be.online.to.vote.on.demotion"));
            return;
        }
        if (SimpleClans.getInstance().hasUUID()) {
            PlayerUniqueId = UUIDMigration.getForcedPlayerUUID(demotedName);
            if (!clan.isLeader(PlayerUniqueId)) {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("player.is.not.a.leader.of.your.clan"));
                return;
            }
            if (clan.getLeaders().size() != 1 && plugin.getSettingsManager().isConfirmationForDemote()) {
                plugin.getRequestManager().addDemoteRequest(cp, demotedName, clan);
                ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + plugin.getLang("demotion.vote.has.been.requested.from.all.leaders"));
                return;
            }
            clan.addBb(player.getName(), ChatColor.AQUA + MessageFormat.format(plugin.getLang("demoted.back.to.member"), Helper.capitalize(demotedName)));
            clan.demote(PlayerUniqueId);
        } else {
            if (!clan.isLeader(demotedName)) {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("player.is.not.a.leader.of.your.clan"));
                return;
            }
            if (clan.getLeaders().size() != 1 && plugin.getSettingsManager().isConfirmationForDemote()) {
                plugin.getRequestManager().addDemoteRequest(cp, demotedName, clan);
                ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + plugin.getLang("demotion.vote.has.been.requested.from.all.leaders"));
                return;
            }
            clan.addBb(player.getName(), ChatColor.AQUA + MessageFormat.format(plugin.getLang("demoted.back.to.member"), Helper.capitalize(demotedName)));
            clan.demote(demotedName);
        }
    }
}

