/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans;

import java.util.UUID;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class TeleportState {
    private UUID playerUniqueId;
    private String playerName;
    private Location playerLocation;
    private Location destination;
    private int counter;
    private String clanName;
    private boolean processing;

    public TeleportState(Player player, Location dest, String clanName) {
        this.destination = dest;
        this.playerLocation = player.getLocation();
        this.playerName = player.getName();
        this.clanName = clanName;
        this.counter = SimpleClans.getInstance().getSettingsManager().getWaitSecs();
        this.playerUniqueId = player.getUniqueId();
    }

    public Location getLocation() {
        return this.playerLocation;
    }

    public boolean isTeleportTime() {
        if (this.counter > 1) {
            --this.counter;
            return false;
        }
        return true;
    }

    public Player getPlayer() {
        if (SimpleClans.getInstance().hasUUID()) {
            return SimpleClans.getInstance().getServer().getPlayer(this.playerUniqueId);
        }
        return SimpleClans.getInstance().getServer().getPlayer(this.playerName);
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public String getClanName() {
        return this.clanName;
    }

    public Location getDestination() {
        return this.destination;
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public void setProcessing(boolean processing) {
        this.processing = processing;
    }

    public UUID getUniqueId() {
        return this.playerUniqueId;
    }
}

