/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import net.sacredlabyrinth.phaed.simpleclans.StringSimplifier;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class ChatBlock {
    private static final int lineLength = 319;
    private ArrayList<Boolean> columnFlexes = new ArrayList();
    private ArrayList<Integer> columnSizes = new ArrayList();
    private ArrayList<String> columnAlignments = new ArrayList();
    private LinkedList<String[]> rows = new LinkedList();
    private String color = "";
    public static final Logger log = Logger.getLogger("Minecraft");

    public void setAlignment(String ... columnAlignment) {
        this.columnAlignments.addAll(Arrays.asList(columnAlignment));
    }

    public void setFlexibility(boolean ... columnFlex) {
        for (boolean flex : columnFlex) {
            this.columnFlexes.add(flex);
        }
    }

    public void setColumnSizes(String prefix, double ... columnPercentages) {
        int ll = 319;
        if (prefix != null) {
            ll = 319 - (int)ChatBlock.msgLength(prefix);
        }
        for (double percentage : columnPercentages) {
            this.columnSizes.add((int)Math.floor(percentage / 100.0 * (double)ll));
        }
    }

    public boolean hasContent() {
        return !this.rows.isEmpty();
    }

    public void addRow(String ... contents) {
        this.rows.add(contents);
    }

    public int size() {
        return this.rows.size();
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public void clear() {
        this.rows.clear();
    }

    public boolean sendBlock(CommandSender player) {
        return this.sendBlock(player, null, 0);
    }

    public boolean sendBlock(CommandSender player, String prefix) {
        return this.sendBlock(player, prefix, 0);
    }

    public boolean sendBlock(CommandSender player, int amount) {
        return this.sendBlock(player, null, amount);
    }

    boolean sendBlock(CommandSender player, String prefix, int amount) {
        if (player == null) {
            return false;
        }
        if (this.rows.isEmpty()) {
            return false;
        }
        if (amount == 0) {
            amount = this.rows.size();
        }
        boolean prefix_used = prefix == null;
        String empty_prefix = ChatBlock.makeEmpty(prefix);
        if (this.columnSizes.isEmpty()) {
            int colCount = this.rows.get(0).length;
            if (colCount > 1) {
                for (int i = 0; i < colCount; ++i) {
                    this.columnSizes.add(this.getMaxWidth(i) + 4);
                }
            } else {
                this.columnSizes.add(319);
            }
        }
        for (int i = 0; i < amount; ++i) {
            if (this.rows.isEmpty()) continue;
            ArrayList<String> measuredCols = new ArrayList<String>();
            String[] row = this.rows.pollFirst();
            for (int sid = 0; sid < row.length; ++sid) {
                String align;
                String col = "";
                String section = row[sid];
                double colsize = this.columnSizes.size() >= sid + 1 ? (double)this.columnSizes.get(sid).intValue() : 0.0;
                String string = align = this.columnAlignments.size() >= sid + 1 ? this.columnAlignments.get(sid) : "l";
                if (align.equalsIgnoreCase("r")) {
                    if (ChatBlock.msgLength(section) > colsize) {
                        col = ChatBlock.cropLeftToFit(section, colsize);
                    } else if (ChatBlock.msgLength(section) < colsize) {
                        col = ChatBlock.paddLeftToFit(section, colsize);
                    }
                } else if (align.equalsIgnoreCase("l")) {
                    if (ChatBlock.msgLength(section) > colsize) {
                        col = ChatBlock.cropRightToFit(section, colsize);
                    } else if (ChatBlock.msgLength(section) < colsize) {
                        col = ChatBlock.paddRightToFit(section, colsize);
                    }
                } else if (align.equalsIgnoreCase("c")) {
                    if (ChatBlock.msgLength(section) > colsize) {
                        col = ChatBlock.cropRightToFit(section, colsize);
                    } else if (ChatBlock.msgLength(section) < colsize) {
                        col = ChatBlock.centerInLineOf(section, colsize);
                    }
                }
                measuredCols.add(col);
            }
            block3: for (int availableSpacing = 12; this.calculatedRowSize(measuredCols) < 319 && availableSpacing > 0; availableSpacing -= 4) {
                for (int j = 0; j < measuredCols.size(); ++j) {
                    String col = (String)measuredCols.get(j);
                    measuredCols.set(j, col + " ");
                    if (this.calculatedRowSize(measuredCols) >= 319) continue block3;
                }
            }
            if (this.columnFlexes.size() == measuredCols.size()) {
                while (this.calculatedRowSize(measuredCols) > 319) {
                    boolean didFlex = false;
                    for (int j = 0; j < measuredCols.size(); ++j) {
                        String col;
                        boolean flex = this.columnFlexes.get(j);
                        if (flex && (col = (String)measuredCols.get(j)).length() > 0) {
                            measuredCols.set(j, col.substring(0, col.length() - 1));
                            didFlex = true;
                        }
                        if (this.calculatedRowSize(measuredCols) <= 319) break;
                    }
                    if (didFlex) continue;
                    break;
                }
            }
            String finalString = "";
            for (String measured : measuredCols) {
                finalString = finalString + measured;
            }
            String msg = ChatBlock.cropRightToFit((prefix_used ? empty_prefix : prefix + " ") + finalString, 319.0);
            if (this.color.length() > 0) {
                msg = this.color + msg;
            }
            player.sendMessage(msg);
            prefix_used = true;
        }
        return !this.rows.isEmpty();
    }

    private int calculatedRowSize(List<String> cols) {
        int out = 0;
        for (String col : cols) {
            out = (int)((double)out + ChatBlock.msgLength(col));
        }
        return out;
    }

    int getMaxWidth(int col) {
        double maxWidth = 0.0;
        for (String[] row : this.rows) {
            maxWidth = Math.max(maxWidth, ChatBlock.msgLength(row[col]));
        }
        return (int)maxWidth;
    }

    public static String centerInLine(String msg) {
        return ChatBlock.centerInLineOf(msg, 319.0);
    }

    private static String centerInLineOf(String msg, double lineLength) {
        double length = ChatBlock.msgLength(msg);
        double diff = lineLength - length;
        if (diff < 0.0) {
            return msg;
        }
        double sideSpace = diff / 2.0;
        msg = ChatBlock.paddLeftToFit(msg, lineLength - Math.floor(sideSpace));
        msg = ChatBlock.paddRightToFit(msg, lineLength);
        return msg;
    }

    public static String makeEmpty(String str) {
        if (str == null) {
            return "";
        }
        return ChatBlock.paddLeftToFit("", ChatBlock.msgLength(str));
    }

    private static String cropRightToFit(String msg, double length) {
        if (msg == null || msg.length() == 0 || length == 0.0) {
            return "";
        }
        while (ChatBlock.msgLength(msg) > length) {
            msg = msg.substring(0, msg.length() - 2);
        }
        return msg;
    }

    private static String cropLeftToFit(String msg, double length) {
        if (msg == null || msg.length() == 0 || length == 0.0) {
            return "";
        }
        while (ChatBlock.msgLength(msg) >= length) {
            msg = msg.substring(1);
        }
        return msg;
    }

    private static String paddLeftToFit(String msg, double length) {
        if (ChatBlock.msgLength(msg) >= length) {
            return msg;
        }
        while (ChatBlock.msgLength(msg) < length) {
            msg = " " + msg;
        }
        return msg;
    }

    private static String paddRightToFit(String msg, double length) {
        if (ChatBlock.msgLength(msg) >= length) {
            return msg;
        }
        while (ChatBlock.msgLength(msg) < length) {
            msg = msg + " ";
        }
        return msg;
    }

    private static double msgLength(String str) {
        double length = 0.0;
        str = ChatColor.stripColor((String)str);
        for (int x = 0; x < str.length(); ++x) {
            int len = ChatBlock.charLength(str.charAt(x));
            if (len > 0) {
                length += (double)len;
                continue;
            }
            ++x;
        }
        return length;
    }

    private static int charLength(char x) {
        String normalized = StringSimplifier.simplifiedString(x + "");
        if ("i.:,;|!".contains(normalized)) {
            return 2;
        }
        if ("l'".contains(normalized)) {
            return 3;
        }
        if ("tI[]".contains(normalized)) {
            return 4;
        }
        if ("fk{}<>\"*()".contains(normalized)) {
            return 5;
        }
        if ("abcdeghjmnopqrsuvwxyzABCDEFGHJKLMNOPQRSTUVWXYZ1234567890\\/#?$%-=_+&^".contains(normalized)) {
            return 6;
        }
        if ("@~".contains(normalized)) {
            return 7;
        }
        if (normalized.equals(" ")) {
            return 4;
        }
        return 7;
    }

    private static String[] wordWrap(String msg) {
        ArrayList<String> split = new ArrayList<String>();
        split.addAll(Arrays.asList(msg.split(" ")));
        ArrayList<String> out = new ArrayList<String>();
        while (!split.isEmpty()) {
            int len = 0;
            ArrayList<String> words = new ArrayList<String>();
            while (!split.isEmpty() && split.get(0) != null && len <= 319) {
                double wordLength = ChatBlock.msgLength((String)split.get(0)) + 4.0;
                if (wordLength > 319.0) {
                    String[] tempArray = ChatBlock.wordCut(len, (String)split.remove(0));
                    words.add(tempArray[0]);
                    split.add(tempArray[1]);
                }
                if ((len = (int)((double)len + wordLength)) >= 319) continue;
                words.add((String)split.remove(0));
            }
            String merged = ChatBlock.combineSplit(words.toArray(new String[words.size()]));
            out.add(merged);
        }
        return out.toArray(new String[out.size()]);
    }

    private static String combineSplit(String[] string) {
        StringBuilder builder = new StringBuilder();
        for (String aString : string) {
            builder.append(aString);
            builder.append(" ");
        }
        builder.deleteCharAt(builder.length() - " ".length());
        return builder.toString();
    }

    private static String[] wordCut(int lengthBefore, String str) {
        int x;
        int length = lengthBefore;
        String[] output = new String[2];
        for (x = 0; length < 319 && x < str.length(); ++x) {
            int len = ChatBlock.charLength(str.charAt(x));
            if (len > 0) {
                length += len;
                continue;
            }
            ++x;
        }
        if (x > str.length()) {
            x = str.length();
        }
        output[0] = str.substring(0, x);
        output[1] = str.substring(x);
        return output;
    }

    public static void saySingle(CommandSender receiver, String msg) {
        if (receiver == null) {
            return;
        }
        receiver.sendMessage(ChatBlock.colorize(new String[]{ChatBlock.cropRightToFit(msg, 319.0)})[0]);
    }

    public static void sendMessage(CommandSender receiver, String msg) {
        String[] message;
        if (receiver == null) {
            return;
        }
        for (String out : message = ChatBlock.colorize(ChatBlock.wordWrap(msg))) {
            receiver.sendMessage(out);
        }
    }

    public void startColor(String color) {
        this.color = color;
    }

    public static void sendBlank(CommandSender receiver) {
        if (receiver == null) {
            return;
        }
        receiver.sendMessage(" ");
    }

    public static String[] say(String message) {
        return ChatBlock.colorize(ChatBlock.wordWrap(message));
    }

    private static String[] colorize(String[] message) {
        try {
            return ChatBlock.colorizeBase(message);
        }
        catch (Exception ex) {
            return message;
        }
    }

    public static String colorize(String message) {
        return ChatBlock.colorizeBase(new String[]{message})[0];
    }

    private static String[] colorizeBase(String[] message) {
        if (message != null && message[0] != null && !message[0].isEmpty()) {
            String prevColor = "";
            String lastColor = "";
            int counter = 0;
            for (String msg : message) {
                for (int x = 0; x < msg.length(); ++x) {
                    if (msg.codePointAt(x) != 167) continue;
                    ++x;
                    try {
                        lastColor = ChatColor.getByChar((char)msg.charAt(x)) + "";
                        continue;
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                message[counter] = prevColor + msg;
                prevColor = lastColor;
                ++counter;
            }
        }
        return message;
    }
}

