/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.url.data;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Base64;
import org.apache.http.entity.ContentType;

public class DataUrlConnection
extends URLConnection {
    public DataUrlConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() {
    }

    @Override
    public InputStream getInputStream() {
        byte[] bytes;
        String url = this.url.toExternalForm();
        String data = url.substring(url.lastIndexOf(",") + 1);
        String fullContentType = this.getFullContentType();
        if (fullContentType.endsWith(";base64")) {
            return new ByteArrayInputStream(Base64.getDecoder().decode(data));
        }
        ContentType contentType = ContentType.parse((String)fullContentType);
        Charset charset = contentType.getCharset();
        if (charset == null) {
            charset = Charset.forName("UTF-8");
        }
        if ((bytes = charset.encode(data).array())[bytes.length - 1] == 0) {
            bytes = Arrays.copyOf(bytes, bytes.length - 1);
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public String getContentType() {
        return this.getFullContentType().replace(";base64", "");
    }

    public String getFullContentType() {
        String contentType;
        String url = this.url.toExternalForm().substring("data:".length());
        int endIndex = url.indexOf(44);
        if (endIndex >= 0 && !(contentType = url.substring(0, endIndex)).isEmpty()) {
            return contentType;
        }
        return "text/plain;charset=US-ASCII";
    }
}

