/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.fileloader;

import com.google.common.collect.HashMultimap;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.mapfish.print.servlet.fileloader.ConfigFileLoaderPlugin;
import org.springframework.beans.factory.annotation.Autowired;

public final class ConfigFileLoaderManager
implements ConfigFileLoaderPlugin {
    @Autowired
    private List<ConfigFileLoaderPlugin> loaderPlugins;

    private Iterable<ConfigFileLoaderPlugin> getLoaderPlugins() {
        return this.loaderPlugins.stream().filter(input -> !(input instanceof ConfigFileLoaderManager)).collect(Collectors.toList());
    }

    @PostConstruct
    public void checkUniqueSchemes() {
        HashMultimap schemeToPluginMap = HashMultimap.create();
        for (ConfigFileLoaderPlugin plugin : this.getLoaderPlugins()) {
            schemeToPluginMap.put((Object)plugin.getUriScheme(), (Object)plugin);
        }
        StringBuilder violations = new StringBuilder();
        for (String scheme : schemeToPluginMap.keySet()) {
            Collection plugins = schemeToPluginMap.get((Object)scheme);
            if (plugins.size() <= 1) continue;
            violations.append("\n\n* ").append("There are  has multiple ").append(ConfigFileLoaderPlugin.class.getSimpleName()).append(" plugins that support the scheme: '").append(scheme).append('\'').append(":\n\t").append(plugins);
        }
        if (violations.length() > 0) {
            throw new IllegalStateException(violations.toString());
        }
    }

    @Override
    public Optional<File> toFile(URI fileUri) {
        for (ConfigFileLoaderPlugin configFileLoaderPlugin : this.getLoaderPlugins()) {
            Optional<File> fileOptional = configFileLoaderPlugin.toFile(fileUri);
            if (!fileOptional.isPresent()) continue;
            return fileOptional;
        }
        return Optional.empty();
    }

    @Override
    public String getUriScheme() {
        throw new UnsupportedOperationException("This method should not be called on the manager since it supports all schemas available in the plugins");
    }

    public Set<String> getSupportedUriSchemes() {
        HashSet<String> schemes = new HashSet<String>();
        for (ConfigFileLoaderPlugin loaderPlugin : this.getLoaderPlugins()) {
            schemes.add(loaderPlugin.getUriScheme());
        }
        return schemes;
    }

    @Override
    public Optional<Long> lastModified(URI fileURI) {
        for (ConfigFileLoaderPlugin plugin : this.getLoaderPlugins()) {
            if (!plugin.isAccessible(fileURI)) continue;
            return plugin.lastModified(fileURI);
        }
        throw new NoSuchElementException("No file found with uri: " + fileURI);
    }

    @Override
    public boolean isAccessible(URI fileURI) {
        for (ConfigFileLoaderPlugin plugin : this.getLoaderPlugins()) {
            if (!plugin.isAccessible(fileURI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] loadFile(URI fileURI) throws IOException {
        for (ConfigFileLoaderPlugin plugin : this.getLoaderPlugins()) {
            if (!plugin.isAccessible(fileURI)) continue;
            return plugin.loadFile(fileURI);
        }
        throw new NoSuchElementException("No file found with uri: " + fileURI);
    }

    @Override
    public boolean isAccessible(URI configFileUri, String pathToSubResource) throws IOException {
        for (ConfigFileLoaderPlugin plugin : this.getLoaderPlugins()) {
            if (!plugin.isAccessible(configFileUri, pathToSubResource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] loadFile(URI configFileUri, String pathToSubResource) throws IOException {
        for (ConfigFileLoaderPlugin plugin : this.getLoaderPlugins()) {
            if (!plugin.isAccessible(configFileUri, pathToSubResource)) continue;
            return plugin.loadFile(configFileUri, pathToSubResource);
        }
        throw new NoSuchElementException("No resource found : " + pathToSubResource + " for configuration file: " + configFileUri);
    }

    @Override
    public Optional<File> toFile(URI configFileUri, String pathToSubResource) throws IOException {
        for (ConfigFileLoaderPlugin plugin : this.getLoaderPlugins()) {
            if (!plugin.isAccessible(configFileUri, pathToSubResource)) continue;
            return plugin.toFile(configFileUri, pathToSubResource);
        }
        throw new NoSuchElementException("No resource found : " + pathToSubResource + " for configuration file: " + configFileUri);
    }
}

