/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.fileloader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.mapfish.print.PrintException;
import org.mapfish.print.servlet.fileloader.ConfigFileLoaderPlugin;
import org.mapfish.print.servlet.fileloader.FileConfigFileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClasspathConfigFileLoader
implements ConfigFileLoaderPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathConfigFileLoader.class);
    public static final String PREFIX = "classpath";
    public static final int PREFIX_LENGTH = "classpath://".length();

    @Override
    public Optional<File> toFile(URI fileUri) {
        Optional<URL> urlOptional = this.loadResources(fileUri);
        if (urlOptional.isPresent() && urlOptional.get().getProtocol().equalsIgnoreCase("file")) {
            try {
                return Optional.of(new File(urlOptional.get().toURI()));
            }
            catch (URISyntaxException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public String getUriScheme() {
        return PREFIX;
    }

    @Override
    public Optional<Long> lastModified(URI fileURI) {
        Optional<URL> resources = this.loadResources(fileURI);
        if (resources.isPresent()) {
            URL url = resources.get();
            if (url.getProtocol().equalsIgnoreCase("file")) {
                try {
                    return Optional.of(new File(url.toURI()).lastModified());
                }
                catch (URISyntaxException e) {
                    throw new PrintException("Failed to create URI for " + url, e);
                }
            }
            return Optional.empty();
        }
        throw new NoSuchElementException(fileURI + " does not exist");
    }

    @Override
    public boolean isAccessible(URI fileURI) {
        Optional<URL> resources = this.loadResources(fileURI);
        return resources.isPresent();
    }

    @Override
    public byte[] loadFile(URI fileURI) throws IOException {
        Optional<URL> resources = this.loadResources(fileURI);
        if (resources.isPresent()) {
            return Files.readAllBytes(FileSystems.getDefault().getPath(resources.get().getPath(), new String[0]));
        }
        throw new NoSuchElementException(fileURI + " does not exist");
    }

    @Override
    public Optional<File> toFile(URI configFileUri, String pathToSubResource) {
        Optional<URL> urlOptional = this.resolveChild(configFileUri, pathToSubResource);
        if (urlOptional.isPresent() && urlOptional.get().getProtocol().equalsIgnoreCase("file")) {
            try {
                return Optional.of(new File(urlOptional.get().toURI()));
            }
            catch (URISyntaxException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean isAccessible(URI configFileUri, String pathToSubResource) {
        try {
            Optional<URL> child = this.resolveChild(configFileUri, pathToSubResource);
            return child.isPresent();
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            return false;
        }
    }

    @Override
    public byte[] loadFile(URI configFileUri, String pathToSubResource) throws IOException {
        Optional<URL> child = this.resolveChild(configFileUri, pathToSubResource);
        if (child.isPresent()) {
            return Files.readAllBytes(FileSystems.getDefault().getPath(child.get().getPath(), new String[0]));
        }
        throw new NoSuchElementException("No file is found for parameters: '" + configFileUri + "' and subresource: '" + pathToSubResource + "'");
    }

    private Optional<URL> resolveChild(URI configFileUri, String pathToSubResource) {
        Optional<URL> found;
        Optional<URL> urlOptional = this.loadResources(configFileUri);
        if (!urlOptional.isPresent()) {
            throw new NoSuchElementException("Configuration file '" + configFileUri + "' does not exist");
        }
        String configUriAsString = configFileUri.toString();
        String configFileName = configUriAsString.substring(configUriAsString.lastIndexOf(47) + 1);
        String configFileDir = urlOptional.get().toString();
        configFileDir = configFileDir.substring(0, configFileDir.indexOf(configFileName));
        if (pathToSubResource.startsWith(PREFIX) && (found = this.resolveChildAsUri(configFileUri, pathToSubResource, configFileDir)).isPresent()) {
            return found;
        }
        try {
            if (pathToSubResource.contains(":/")) {
                URI uri = new URI(pathToSubResource);
                throw new IllegalArgumentException("Only uris with prefix classpath are supported.  Found: " + uri);
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        String subResourceRelativeToConfigFileDir = configUriAsString.substring(0, configUriAsString.indexOf(configFileName)) + pathToSubResource;
        return this.resolveChildAsUri(configFileUri, subResourceRelativeToConfigFileDir, configFileDir);
    }

    private Optional<URL> resolveChildAsUri(URI configFileUri, String pathToSubResource, String configFileDir) {
        try {
            Optional<URL> subResource = this.loadResources(new URI(pathToSubResource));
            if (subResource.isPresent()) {
                if (!subResource.get().toString().startsWith(configFileDir)) {
                    throw new IllegalArgumentException("'" + pathToSubResource + "' is not a child of '" + configFileUri + "'");
                }
                return Optional.of(subResource.get());
            }
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    private Optional<URL> loadResources(URI fileURI) {
        if (fileURI == null) {
            return Optional.empty();
        }
        if (fileURI.getScheme() != null && fileURI.getScheme().equals("file")) {
            File file;
            try {
                file = new File(fileURI);
            }
            catch (IllegalArgumentException e) {
                file = new File(fileURI.toString().substring("file://".length()));
            }
            if (file.exists()) {
                try {
                    return Optional.of(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new PrintException("Failed to create URL from " + file.toURI(), e);
                }
            }
            return Optional.empty();
        }
        if (!fileURI.toString().startsWith(PREFIX)) {
            return Optional.empty();
        }
        String path = fileURI.toString().substring(PREFIX_LENGTH);
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        try {
            Enumeration<URL> resources = FileConfigFileLoader.class.getClassLoader().getResources(path);
            if (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                return Optional.of(resource);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to find resources on the path: {}", (Object)fileURI);
        }
        return Optional.empty();
    }
}

