/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.sentry.Sentry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfree.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.mapfish.print.Constants;
import org.mapfish.print.FontTools;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.MapPrinterFactory;
import org.mapfish.print.PrintException;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.processor.http.matcher.UriMatchers;
import org.mapfish.print.servlet.BaseMapServlet;
import org.mapfish.print.servlet.BooleanHandleReportLoadResult;
import org.mapfish.print.servlet.HandleReportLoadResult;
import org.mapfish.print.servlet.NoSuchAppException;
import org.mapfish.print.servlet.ServletInfo;
import org.mapfish.print.servlet.VoidHandleReportLoadResult;
import org.mapfish.print.servlet.job.JobManager;
import org.mapfish.print.servlet.job.NoSuchReferenceException;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.impl.PrintJobEntryImpl;
import org.mapfish.print.servlet.job.loader.ReportLoader;
import org.mapfish.print.url.data.Handler;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class MapPrinterServlet
extends BaseMapServlet {
    public static final String CAPABILITIES_URL = "/capabilities.json";
    public static final String LIST_APPS_URL = "/apps.json";
    public static final String EXAMPLE_REQUEST_URL = "/exampleRequest.json";
    private static final String BUILDREPORT = "buildreport";
    public static final String CREATE_AND_GET_URL = "/buildreport";
    private static final String STATUS = "status";
    public static final String STATUS_URL = "/status";
    private static final String CANCEL = "cancel";
    public static final String CANCEL_URL = "/cancel";
    private static final String REPORT = "report";
    public static final String REPORT_URL = "/report";
    public static final String FONTS_URL = "/fonts";
    public static final String JSON_ERROR = "error";
    public static final String JSON_APP = "app";
    public static final String JSON_DONE = "done";
    public static final String JSON_STATUS = "status";
    public static final String JSON_ELAPSED_TIME = "elapsedTime";
    public static final String JSON_WAITING_TIME = "waitingTime";
    public static final String JSON_PRINT_JOB_REF = "ref";
    public static final String JSON_STATUS_LINK = "statusURL";
    public static final String JSON_DOWNLOAD_LINK = "downloadURL";
    public static final String JSON_OUTPUT_FORMAT = "outputFormat";
    public static final String JSON_ATTRIBUTES = "attributes";
    public static final String JSON_REQUEST_HEADERS = "requestHeaders";
    public static final String JSON_OUTPUT_JASPERREPORT_FONTS = "jasperreportFonts";
    public static final String JSON_OUTPUT_FONTS = "fonts";
    public static final String JSON_OUTPUT_FONT_FAMILY = "family";
    public static final String JSON_OUTPUT_FONTCONFIG = "fontconfig";
    public static final String JSON_OUTPUT_FONTCONFIG_FAMILIES = "families";
    public static final String JSON_OUTPUT_FONTCONFIG_NAME = "name";
    public static final String JSON_OUTPUT_FONTCONFIG_STYLES = "styles";
    public static final String JSON_OUTPUT_FONTCONFIG_WEIGHT = "weight";
    private static final Logger LOGGER = LoggerFactory.getLogger(MapPrinterServlet.class);
    private static final int JSON_INDENT_FACTOR = 4;
    private static final List<String> REQUEST_ID_HEADERS = Arrays.asList("X-Request-ID", "X-Correlation-ID", "Request-ID", "X-Varnish", "X-Amzn-Trace-Id");
    private static final String NO_APP_ID = "NoAppId";
    private final JobManager jobManager;
    private final List<ReportLoader> reportLoaders;
    private final MapPrinterFactory printerFactory;
    private final ApplicationContext context;
    private final ServletInfo servletInfo;
    private final MapPrinterFactory mapPrinterFactory;
    private final Timer buildReportTimer;
    private final Timer reportTimer;
    private final Timer statusTimer;
    private final Timer cancelTimer;
    private final Timer getReportTimer;
    private final Counter noAppIdCounter;
    private final Counter withAppIdCounter;
    private long maxCreateAndGetWaitTimeInSeconds = 600L;

    @Autowired
    public MapPrinterServlet(JobManager jobManager, List<ReportLoader> reportLoaders, MapPrinterFactory printerFactory, ApplicationContext context, ServletInfo servletInfo, MapPrinterFactory mapPrinterFactory, MetricRegistry metricRegistry) {
        this.jobManager = jobManager;
        this.reportLoaders = reportLoaders;
        this.printerFactory = printerFactory;
        this.context = context;
        this.servletInfo = servletInfo;
        this.mapPrinterFactory = mapPrinterFactory;
        this.buildReportTimer = metricRegistry.timer(MetricRegistry.name((String)MapPrinterServlet.class.getSimpleName(), (String[])new String[]{BUILDREPORT}));
        this.reportTimer = metricRegistry.timer(MetricRegistry.name((String)MapPrinterServlet.class.getSimpleName(), (String[])new String[]{"generate", REPORT}));
        this.statusTimer = metricRegistry.timer(MetricRegistry.name((String)MapPrinterServlet.class.getSimpleName(), (String[])new String[]{"status", REPORT}));
        this.cancelTimer = metricRegistry.timer(MetricRegistry.name((String)MapPrinterServlet.class.getSimpleName(), (String[])new String[]{CANCEL, REPORT}));
        this.getReportTimer = metricRegistry.timer(MetricRegistry.name((String)MapPrinterServlet.class.getSimpleName(), (String[])new String[]{"download", REPORT}));
        this.noAppIdCounter = metricRegistry.counter(MetricRegistry.name((String)MapPrinterServlet.class.getSimpleName(), (String[])new String[]{NO_APP_ID}));
        this.withAppIdCounter = metricRegistry.counter(MetricRegistry.name((String)MapPrinterServlet.class.getSimpleName(), (String[])new String[]{"withAppId"}));
        boolean enableSentry = System.getProperties().contains("sentry.dsn");
        enableSentry |= System.getenv().containsKey("SENTRY_URL");
        if (enableSentry |= System.getenv().containsKey("SENTRY_DSN")) {
            Sentry.init(options -> {
                options.setEnableExternalConfiguration(true);
                options.setBeforeSend((event, hint) -> {
                    LOGGER.info("Sentry event, logger: {}, message: {}", (Object)event.getLogger(), event.getMessage() != null ? event.getMessage().getMessage() : null);
                    if (Objects.equals(event.getLogger(), "org.hibernate.engine.jdbc.spi.SqlExceptionHelper") && event.getMessage() != null && (Objects.equals(event.getMessage().getMessage(), "ERROR: could not obtain lock on row in relation \"print_job_statuses\"") || Objects.equals(event.getMessage().getMessage(), "SQL Error: 0, SQLState: 55P03"))) {
                        return null;
                    }
                    return event;
                });
            });
        }
    }

    private static PJsonObject parseJson(String requestDataRaw, HttpServletResponse httpServletResponse) {
        try {
            if (requestDataRaw == null) {
                MapPrinterServlet.error(httpServletResponse, "Missing post data.  The post payload must either be a form post with a spec parameter or must be a raw json post with the request.", HttpStatus.INTERNAL_SERVER_ERROR);
                return null;
            }
            String requestData = requestDataRaw;
            if (!requestData.startsWith("spec=") && !requestData.startsWith("{")) {
                try {
                    requestData = URLDecoder.decode(requestData, Constants.DEFAULT_ENCODING);
                }
                catch (UnsupportedEncodingException e) {
                    throw MapPrinterServlet.createPrintException(e, requestData);
                }
            }
            if (requestData.startsWith("spec=")) {
                requestData = requestData.substring("spec=".length());
            }
            try {
                return MapPrinter.parseSpec(requestData);
            }
            catch (RuntimeException e) {
                try {
                    return MapPrinter.parseSpec(URLDecoder.decode(requestData, Constants.DEFAULT_ENCODING));
                }
                catch (UnsupportedEncodingException uee) {
                    throw MapPrinterServlet.createPrintException(uee, requestData);
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.warn("Error parsing request data: {}", (Object)requestDataRaw);
            throw e;
        }
    }

    private static PrintException createPrintException(UnsupportedEncodingException e, String requestData) {
        String message = String.format("Failed to decode %s using %s", requestData, Constants.DEFAULT_ENCODING);
        return new PrintException(message, e);
    }

    private static String maybeAddRequestId(String ref, HttpServletRequest request) {
        Optional<String> headerName = REQUEST_ID_HEADERS.stream().filter(h -> request.getHeader(h) != null).findFirst();
        return headerName.map(s -> ref + "@" + request.getHeader(s).replaceAll("[^a-zA-Z0-9._:-]", "_")).orElse(ref);
    }

    @RequestMapping(value={"/{appId}/status/{referenceId:\\S+}.json"}, method={RequestMethod.GET})
    public final void getStatusSpecificAppId(@Nonnull @PathVariable String appId, @Nonnull @PathVariable String referenceId, HttpServletRequest statusRequest, HttpServletResponse statusResponse) {
        this.withAppIdCounter.inc();
        try (Timer.Context ignored = this.statusTimer.time();){
            this.getStatus(appId, referenceId, statusRequest, statusResponse);
        }
    }

    @RequestMapping(value={"/status/{referenceId:\\S+}.json"}, method={RequestMethod.GET})
    public final void getStatusPath(@Nonnull @PathVariable String referenceId, HttpServletRequest statusRequest, HttpServletResponse statusResponse) {
        this.noAppIdCounter.inc();
        try (Timer.Context ignored = this.statusTimer.time();){
            this.getStatus("default", referenceId, statusRequest, statusResponse);
        }
    }

    private void getStatus(@Nonnull String applicationId, @Nonnull String referenceId, HttpServletRequest statusRequest, HttpServletResponse statusResponse) {
        MDC.put((String)"application_id", (String)applicationId);
        MDC.put((String)"job_id", (String)referenceId);
        MapPrinterServlet.setNoCache(statusResponse);
        try {
            PrintJobStatus status = this.jobManager.getStatus(referenceId);
            this.setContentType(statusResponse);
            try (PrintWriter writer = statusResponse.getWriter();){
                JSONWriter json = new JSONWriter((Appendable)writer);
                json.object();
                json.key(JSON_DONE).value(status.isDone());
                json.key("status").value((Object)status.getStatus().toString().toLowerCase());
                json.key(JSON_ELAPSED_TIME).value(status.getElapsedTime());
                json.key(JSON_WAITING_TIME).value(status.getWaitingTime());
                if (!StringUtils.isEmpty((CharSequence)status.getError())) {
                    json.key(JSON_ERROR).value((Object)status.getError());
                }
                this.addDownloadLinkToJson(statusRequest, referenceId, json);
                json.endObject();
            }
        }
        catch (IOException e) {
            throw new PrintException("Failed to get writer from " + statusResponse, e);
        }
        catch (NoSuchReferenceException e) {
            MapPrinterServlet.error(statusResponse, e.getMessage(), HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/{appId}/cancel/{referenceId:\\S+}"}, method={RequestMethod.DELETE})
    public final void cancelSpecificAppId(@Nonnull @PathVariable String appId, @Nonnull @PathVariable String referenceId, HttpServletResponse statusResponse) {
        this.withAppIdCounter.inc();
        try (Timer.Context ignored = this.cancelTimer.time();){
            this.cancel(appId, referenceId, statusResponse);
        }
    }

    @RequestMapping(value={"/cancel/{referenceId:\\S+}"}, method={RequestMethod.DELETE})
    public final void cancelPath(@Nonnull @PathVariable String referenceId, HttpServletResponse statusResponse) {
        this.noAppIdCounter.inc();
        try (Timer.Context ignored = this.cancelTimer.time();){
            this.cancel("default", referenceId, statusResponse);
        }
    }

    private void cancel(@Nonnull String applicationId, @Nonnull String referenceId, HttpServletResponse statusResponse) {
        MDC.put((String)"application_id", (String)applicationId);
        MDC.put((String)"job_id", (String)referenceId);
        MapPrinterServlet.setNoCache(statusResponse);
        try {
            this.jobManager.cancel(referenceId);
        }
        catch (NoSuchReferenceException e) {
            MapPrinterServlet.error(statusResponse, e.getMessage(), HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/{appId}/report.{format:\\w+}"}, method={RequestMethod.POST})
    public final void createReport(@Nonnull @PathVariable String appId, @PathVariable String format, @RequestBody String requestData, HttpServletRequest createReportRequest, HttpServletResponse createReportResponse) throws NoSuchAppException {
        this.withAppIdCounter.inc();
        try (Timer.Context ignored = this.reportTimer.time();){
            MapPrinterServlet.setNoCache(createReportResponse);
            this.doCreateReport(appId, format, requestData, createReportRequest, createReportResponse);
        }
    }

    private void doCreateReport(String appId, String format, String requestData, HttpServletRequest createReportRequest, HttpServletResponse createReportResponse) throws NoSuchAppException {
        String ref = this.createAndSubmitPrintJob(appId, format, requestData, createReportRequest, createReportResponse);
        if (ref == null) {
            MapPrinterServlet.error(createReportResponse, "Failed to create a print job", HttpStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        this.setContentType(createReportResponse);
        try (PrintWriter writer = createReportResponse.getWriter();){
            JSONWriter json = new JSONWriter((Appendable)writer);
            json.object();
            json.key(JSON_PRINT_JOB_REF).value((Object)ref);
            String statusURL = this.getBaseUrl(createReportRequest) + "/status/" + ref + ".json";
            json.key(JSON_STATUS_LINK).value((Object)statusURL);
            this.addDownloadLinkToJson(createReportRequest, ref, json);
            json.endObject();
        }
        catch (IOException | JSONException e) {
            LOGGER.warn("Error generating the JSON response", e);
        }
    }

    @RequestMapping(value={"/{appId}/report/{referenceId:\\S+}"}, method={RequestMethod.GET})
    public final void getReportSpecificAppId(@Nonnull @PathVariable String appId, @Nonnull @PathVariable String referenceId, @RequestParam(value="inline", defaultValue="false") boolean inline, HttpServletResponse getReportResponse) throws IOException, ServletException {
        this.withAppIdCounter.inc();
        try (Timer.Context ignored = this.getReportTimer.time();){
            this.getReport(appId, referenceId, inline, getReportResponse);
        }
    }

    @RequestMapping(value={"/report/{referenceId:\\S+}"}, method={RequestMethod.GET})
    public final void getReportPath(@Nonnull @PathVariable String referenceId, @RequestParam(value="inline", defaultValue="false") boolean inline, HttpServletResponse getReportResponse) throws IOException, ServletException {
        this.noAppIdCounter.inc();
        try (Timer.Context ignored = this.getReportTimer.time();){
            this.getReport("default", referenceId, inline, getReportResponse);
        }
    }

    private void getReport(@Nonnull String applicationId, @Nonnull String referenceId, boolean inline, HttpServletResponse getReportResponse) throws IOException, ServletException {
        MDC.put((String)"application_id", (String)applicationId);
        MDC.put((String)"job_id", (String)referenceId);
        MapPrinterServlet.setNoCache(getReportResponse);
        this.loadReport(referenceId, getReportResponse, new VoidHandleReportLoadResult(inline));
    }

    @RequestMapping(value={"/report.{format:\\w+}"}, method={RequestMethod.POST})
    public final void createReport(@PathVariable String format, @RequestBody String requestData, HttpServletRequest createReportRequest, HttpServletResponse createReportResponse) throws NoSuchAppException {
        this.noAppIdCounter.inc();
        try (Timer.Context ignored = this.reportTimer.time();){
            MapPrinterServlet.setNoCache(createReportResponse);
            String appId = MapPrinterServlet.getAppId(requestData, createReportResponse);
            if (appId == null) {
                return;
            }
            this.doCreateReport(appId, format, requestData, createReportRequest, createReportResponse);
        }
    }

    private static String getAppId(String requestData, HttpServletResponse createReportResponse) throws NoSuchAppException {
        PJsonObject spec = MapPrinterServlet.parseJson(requestData, createReportResponse);
        if (spec == null) {
            return null;
        }
        String appId = spec.optString(JSON_APP, "default");
        if (appId == null) {
            throw new NoSuchAppException("No app specified");
        }
        return appId;
    }

    @RequestMapping(value={"/{appId}/buildreport.{format:\\w+}"}, method={RequestMethod.POST})
    public final void createReportAndGet(@Nonnull @PathVariable String appId, @PathVariable String format, @RequestBody String requestData, @RequestParam(value="inline", defaultValue="false") boolean inline, HttpServletRequest createReportRequest, HttpServletResponse createReportResponse) throws IOException, ServletException, InterruptedException, NoSuchAppException {
        this.withAppIdCounter.inc();
        try (Timer.Context ignored = this.buildReportTimer.time();){
            MapPrinterServlet.setNoCache(createReportResponse);
            this.doCreateReportAndGet(appId, format, requestData, inline, createReportRequest, createReportResponse);
        }
    }

    private void doCreateReportAndGet(String appId, String format, String requestData, boolean inline, HttpServletRequest createReportRequest, HttpServletResponse createReportResponse) throws NoSuchAppException, InterruptedException, IOException, ServletException {
        String ref = this.createAndSubmitPrintJob(appId, format, requestData, createReportRequest, createReportResponse);
        if (ref == null) {
            MapPrinterServlet.error(createReportResponse, "Failed to create a print job", HttpStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        BooleanHandleReportLoadResult handler = new BooleanHandleReportLoadResult(inline);
        boolean isDone = false;
        long maxWaitTimeInMillis = TimeUnit.SECONDS.toMillis(this.maxCreateAndGetWaitTimeInSeconds);
        long startWaitTime = System.currentTimeMillis();
        while (!isDone && System.currentTimeMillis() - startWaitTime < maxWaitTimeInMillis) {
            TimeUnit.SECONDS.sleep(1L);
            isDone = this.loadReport(ref, createReportResponse, handler);
        }
    }

    @RequestMapping(value={"/buildreport.{format:\\w+}"}, method={RequestMethod.POST})
    public final void createReportAndGetNoAppId(@PathVariable String format, @RequestBody String requestData, @RequestParam(value="inline", defaultValue="false") boolean inline, HttpServletRequest createReportRequest, HttpServletResponse createReportResponse) throws IOException, ServletException, InterruptedException, NoSuchAppException {
        this.noAppIdCounter.inc();
        try (Timer.Context ignored = this.buildReportTimer.time();){
            MapPrinterServlet.setNoCache(createReportResponse);
            String appId = MapPrinterServlet.getAppId(requestData, createReportResponse);
            if (appId == null) {
                return;
            }
            this.doCreateReportAndGet(appId, format, requestData, inline, createReportRequest, createReportResponse);
        }
    }

    @RequestMapping(value={"/apps.json"}, method={RequestMethod.GET})
    public final void listAppIds(HttpServletResponse listAppsResponse) throws ServletException, IOException {
        MDC.remove((String)"application_id");
        MDC.remove((String)"job_id");
        this.setCache(listAppsResponse);
        Set<String> appIds = this.printerFactory.getAppIds();
        this.setContentType(listAppsResponse);
        try (PrintWriter writer = listAppsResponse.getWriter();){
            JSONWriter json = new JSONWriter((Appendable)writer);
            try {
                json.array();
                for (String appId : appIds) {
                    json.value((Object)appId);
                }
                json.endArray();
            }
            catch (JSONException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    @RequestMapping(value={"/capabilities.json"}, method={RequestMethod.GET})
    public final void getCapabilities(@RequestParam(value="pretty", defaultValue="false") boolean pretty, HttpServletRequest request, HttpServletResponse capabilitiesResponse) throws ServletException, IOException {
        this.getCapabilities("default", pretty, request, capabilitiesResponse);
    }

    @RequestMapping(value={"/{appId}/capabilities.json"}, method={RequestMethod.GET})
    public final void getCapabilities(@Nonnull @PathVariable String appId, @RequestParam(value="pretty", defaultValue="false") boolean pretty, HttpServletRequest request, HttpServletResponse capabilitiesResponse) throws ServletException, IOException {
        MapPrinter printer;
        MDC.remove((String)"application_id");
        MDC.remove((String)"job_id");
        this.setCache(capabilitiesResponse);
        try {
            printer = this.printerFactory.create(appId);
            if (!this.checkReferer(request, printer)) {
                MapPrinterServlet.error(capabilitiesResponse, "Invalid referrer", HttpStatus.FORBIDDEN);
                return;
            }
        }
        catch (NoSuchAppException e) {
            MapPrinterServlet.error(capabilitiesResponse, e.getMessage(), HttpStatus.NOT_FOUND);
            return;
        }
        this.setContentType(capabilitiesResponse);
        ByteArrayOutputStream prettyPrintBuffer = new ByteArrayOutputStream();
        try (Writer writer = pretty ? new OutputStreamWriter((OutputStream)prettyPrintBuffer, Constants.DEFAULT_CHARSET) : capabilitiesResponse.getWriter();){
            JSONWriter json = new JSONWriter((Appendable)writer);
            try {
                json.object();
                json.key(JSON_APP).value((Object)appId);
                printer.printClientConfig(json);
                json.key("formats");
                Set<String> formats = printer.getOutputFormatsNames();
                json.array();
                for (String format : formats) {
                    json.value((Object)format);
                }
                json.endArray();
                json.endObject();
            }
            catch (JSONException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (pretty) {
            JSONObject jsonObject = new JSONObject(prettyPrintBuffer.toString(Constants.DEFAULT_CHARSET));
            capabilitiesResponse.getWriter().print(jsonObject.toString(4));
        }
    }

    @RequestMapping(value={"/exampleRequest.json"}, method={RequestMethod.GET})
    public final void getExampleRequest(HttpServletRequest request, HttpServletResponse getExampleResponse) throws IOException {
        this.getExampleRequest("default", request, getExampleResponse);
    }

    @RequestMapping(value={"{appId}/exampleRequest.json"}, method={RequestMethod.GET})
    public final void getExampleRequest(@Nonnull @PathVariable String appId, HttpServletRequest request, HttpServletResponse getExampleResponse) throws IOException {
        MDC.remove((String)"application_id");
        MDC.remove((String)"job_id");
        this.setCache(getExampleResponse);
        try {
            String result;
            MapPrinter mapPrinter = this.printerFactory.create(appId);
            if (!this.checkReferer(request, mapPrinter)) {
                MapPrinterServlet.error(getExampleResponse, "Invalid referrer", HttpStatus.FORBIDDEN);
                return;
            }
            String requestDataPrefix = "requestData";
            File[] children = mapPrinter.getConfiguration().getDirectory().listFiles((dir, name) -> name.startsWith("requestData") && name.endsWith(".json"));
            if (children == null) {
                MapPrinterServlet.error(getExampleResponse, "Cannot find the config directory", HttpStatus.NOT_FOUND);
                return;
            }
            JSONObject allExamples = new JSONObject();
            for (File child : children) {
                if (!child.isFile()) continue;
                String requestData = Files.readString(child.toPath(), Constants.DEFAULT_CHARSET);
                try {
                    JSONObject jsonObject = new JSONObject(requestData);
                    jsonObject.remove(JSON_OUTPUT_FORMAT);
                    jsonObject.remove(JSON_APP);
                    requestData = jsonObject.toString(4);
                    this.setContentType(getExampleResponse);
                }
                catch (JSONException jsonObject) {
                    // empty catch block
                }
                String name2 = child.getName();
                name2 = name2.substring("requestData".length());
                if (name2.startsWith("-")) {
                    name2 = name2.substring(1);
                }
                name2 = FilenameUtils.removeExtension((String)name2);
                if ((name2 = name2.trim()).isEmpty()) {
                    name2 = FilenameUtils.removeExtension((String)child.getName());
                }
                try {
                    allExamples.put(name2, (Object)requestData);
                }
                catch (JSONException e) {
                    Log.error((Object)"Error translating object to json", (Exception)((Object)e));
                    MapPrinterServlet.error(getExampleResponse, "Error translating object to json: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
                    return;
                }
            }
            try {
                result = allExamples.toString(4);
            }
            catch (JSONException e) {
                Log.error((Object)"Error translating object to json", (Exception)((Object)e));
                MapPrinterServlet.error(getExampleResponse, "Error translating object to json: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
                return;
            }
            try (PrintWriter writer = getExampleResponse.getWriter();){
                writer.append(result);
            }
        }
        catch (NoSuchAppException e) {
            MapPrinterServlet.error(getExampleResponse, "No print app identified by: " + appId, HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/fonts"})
    public final void listAvailableFonts(HttpServletResponse response) {
        MDC.remove((String)"application_id");
        MDC.remove((String)"job_id");
        this.setContentType(response);
        try (PrintWriter writer = response.getWriter();){
            JSONWriter json = new JSONWriter((Appendable)writer);
            json.object();
            json.key(JSON_OUTPUT_JASPERREPORT_FONTS);
            json.array();
            List families = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(FontFamily.class);
            for (FontFamily fontFamily : families) {
                json.value((Object)fontFamily.getName());
            }
            json.endArray();
            json.key(JSON_OUTPUT_FONTS);
            json.array();
            for (String string : FontTools.FONT_FAMILIES) {
                json.object();
                json.key(JSON_OUTPUT_FONT_FAMILY).value((Object)string);
                json.key(JSON_OUTPUT_FONTCONFIG);
                json.array();
                for (FontTools.FontConfigDescription description : FontTools.listFontConfigFonts(string)) {
                    json.object();
                    if (description.family != null) {
                        json.key(JSON_OUTPUT_FONTCONFIG_FAMILIES);
                        json.array();
                        for (String fam : description.family) {
                            json.value((Object)fam);
                        }
                        json.endArray();
                    }
                    if (description.name != null) {
                        json.key(JSON_OUTPUT_FONTCONFIG_NAME).value((Object)description.name);
                    }
                    if (description.style != null) {
                        json.key(JSON_OUTPUT_FONTCONFIG_STYLES);
                        json.array();
                        for (String style : description.style) {
                            json.value((Object)style);
                        }
                        json.endArray();
                    }
                    if (description.weight != 0) {
                        json.key(JSON_OUTPUT_FONTCONFIG_WEIGHT).value((long)description.weight);
                    }
                    json.endObject();
                }
                json.endArray();
                json.endObject();
            }
            json.endArray();
            json.endObject();
        }
        catch (IOException e) {
            throw new PrintException("Failed to get writer from " + response, e);
        }
    }

    public final void setMaxCreateAndGetWaitTimeInSeconds(long maxCreateAndGetWaitTimeInSeconds) {
        this.maxCreateAndGetWaitTimeInSeconds = maxCreateAndGetWaitTimeInSeconds;
    }

    private void addDownloadLinkToJson(HttpServletRequest httpServletRequest, String ref, JSONWriter json) {
        String downloadURL = this.getBaseUrl(httpServletRequest) + "/report/" + ref;
        json.key(JSON_DOWNLOAD_LINK).value((Object)downloadURL);
    }

    protected final JSONObject getHeaders(HttpServletRequest httpServletRequest) {
        Enumeration headersName = httpServletRequest.getHeaderNames();
        JSONObject headers = new JSONObject();
        while (headersName.hasMoreElements()) {
            String name = headersName.nextElement().toString();
            Enumeration e = httpServletRequest.getHeaders(name);
            while (e.hasMoreElements()) {
                headers.append(name, e.nextElement());
            }
        }
        JSONObject requestHeadersAttribute = new JSONObject();
        requestHeadersAttribute.put(JSON_REQUEST_HEADERS, (Object)headers);
        return requestHeadersAttribute;
    }

    private String createAndSubmitPrintJob(@Nonnull String appId, String format, String requestDataRaw, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws NoSuchAppException {
        PJsonObject specJson = MapPrinterServlet.parseJson(requestDataRaw, httpServletResponse);
        if (specJson == null) {
            return null;
        }
        String ref = MapPrinterServlet.maybeAddRequestId(UUID.randomUUID() + "@" + this.servletInfo.getServletId(), httpServletRequest);
        MDC.put((String)"application_id", (String)appId);
        MDC.put((String)"job_id", (String)ref);
        LOGGER.debug("{} created Ref:{} for {}", new Object[]{httpServletRequest.getRequestURI(), ref, specJson});
        specJson.getInternalObj().remove(JSON_OUTPUT_FORMAT);
        specJson.getInternalObj().put(JSON_OUTPUT_FORMAT, (Object)format);
        specJson.getInternalObj().remove(JSON_APP);
        specJson.getInternalObj().put(JSON_APP, (Object)appId);
        JSONObject requestHeaders = this.getHeaders(httpServletRequest);
        if (!requestHeaders.isEmpty()) {
            specJson.getInternalObj().getJSONObject(JSON_ATTRIBUTES).put(JSON_REQUEST_HEADERS, (Object)requestHeaders);
        }
        String templateName = specJson.getString("layout");
        MapPrinter mapPrinter = this.mapPrinterFactory.create(appId);
        this.checkReferer(httpServletRequest, mapPrinter);
        Template template = mapPrinter.getConfiguration().getTemplate(templateName);
        if (template == null) {
            return null;
        }
        PrintJobEntryImpl jobEntry = new PrintJobEntryImpl(ref, specJson, System.currentTimeMillis());
        jobEntry.configureAccess(template, this.context);
        try {
            this.jobManager.submit(jobEntry);
        }
        catch (RuntimeException exc) {
            LOGGER.error("Error when creating job on {}: {}", new Object[]{appId, specJson, exc});
            return null;
        }
        return ref;
    }

    private boolean checkReferer(HttpServletRequest request, MapPrinter mapPrinter) {
        Configuration config = mapPrinter.getConfiguration();
        UriMatchers allowedReferers = config.getAllowedReferersImpl();
        if (allowedReferers == null) {
            return true;
        }
        String referrer = request.getHeader("referer");
        if (referrer == null) {
            referrer = "http://localhost/";
        }
        try {
            return allowedReferers.matches(new URI(referrer), HttpMethod.resolve((String)request.getMethod()));
        }
        catch (MalformedURLException | SocketException | URISyntaxException | UnknownHostException e) {
            LOGGER.error("Referrer {} invalid", (Object)referrer, (Object)e);
            return false;
        }
    }

    private <R> R loadReport(String referenceId, HttpServletResponse httpServletResponse, HandleReportLoadResult<R> handler) throws IOException, ServletException {
        PrintJobStatus metadata;
        try {
            metadata = this.jobManager.getStatus(referenceId);
        }
        catch (NoSuchReferenceException e) {
            return handler.unknownReference(httpServletResponse, referenceId);
        }
        if (!metadata.isDone()) {
            return handler.printJobPending(httpServletResponse, referenceId);
        }
        if (metadata.getResult() != null) {
            URI pdfURI = metadata.getResult().getReportURI();
            ReportLoader loader = null;
            for (ReportLoader reportLoader : this.reportLoaders) {
                if (!reportLoader.accepts(pdfURI)) continue;
                loader = reportLoader;
                break;
            }
            if (loader == null) {
                return handler.unsupportedLoader(httpServletResponse, referenceId);
            }
            return handler.successfulPrint(metadata, httpServletResponse, pdfURI, loader);
        }
        return handler.failedPrint(metadata, httpServletResponse);
    }

    private void setContentType(HttpServletResponse statusResponse) {
        statusResponse.setContentType("application/json; charset=utf-8");
    }

    static {
        Handler.configureProtocolHandler();
    }
}

