/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.loader.ReportLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class HandleReportLoadResult<R> {
    private static final int FILENAME_MAX_LENGTH = 1000;
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{(\\S{1,1000})}");
    private static final Logger LOGGER = LoggerFactory.getLogger(HandleReportLoadResult.class);

    HandleReportLoadResult() {
    }

    abstract R unknownReference(HttpServletResponse var1, String var2);

    abstract R unsupportedLoader(HttpServletResponse var1, String var2);

    abstract R successfulPrint(PrintJobStatus var1, HttpServletResponse var2, URI var3, ReportLoader var4) throws IOException, ServletException;

    abstract R failedPrint(PrintJobStatus var1, HttpServletResponse var2);

    abstract R printJobPending(HttpServletResponse var1, String var2);

    protected final void sendReportFile(PrintJobStatus metadata, HttpServletResponse httpServletResponse, ReportLoader reportLoader, URI reportURI, boolean inline) throws IOException {
        try (ServletOutputStream response = httpServletResponse.getOutputStream();){
            httpServletResponse.setContentType(metadata.getResult().getMimeType());
            if (!inline) {
                Object fileName = metadata.getResult().getFileName();
                Matcher matcher = HandleReportLoadResult.getFileNameMatcher((String)fileName);
                while (matcher.find()) {
                    String variable = matcher.group(1);
                    String replacement = this.findReplacement(variable, metadata.getCompletionDate());
                    fileName = ((String)fileName).replace("${" + variable + "}", replacement);
                    matcher = HandleReportLoadResult.getFileNameMatcher((String)fileName);
                }
                fileName = (String)fileName + "." + metadata.getResult().getFileExtension();
                httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + this.cleanUpName((String)fileName));
            }
            reportLoader.loadReport(reportURI, (OutputStream)response);
        }
    }

    private static Matcher getFileNameMatcher(String fileName) {
        if (fileName.length() > 1000) {
            throw new IllegalArgumentException("File name is too long");
        }
        return VARIABLE_PATTERN.matcher(fileName);
    }

    private String findReplacement(String variableName, Date date) {
        if (variableName.equalsIgnoreCase("date")) {
            return this.cleanUpName(DateFormat.getDateInstance().format(date));
        }
        if (variableName.equalsIgnoreCase("datetime")) {
            return this.cleanUpName(DateFormat.getDateTimeInstance().format(date));
        }
        if (variableName.equalsIgnoreCase("time")) {
            return this.cleanUpName(DateFormat.getTimeInstance().format(date));
        }
        try {
            return new SimpleDateFormat(variableName).format(date);
        }
        catch (RuntimeException e) {
            LOGGER.error("Unable to format timestamp according to pattern: {}", (Object)variableName, (Object)e);
            return "${" + variableName + "}";
        }
    }

    private String cleanUpName(String original) {
        return original.replace(",", "").replaceAll("\\s+", "_").replaceAll("[^a-zA-Z0-9-_.:+]", "_");
    }
}

