/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.jasper;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;

public class DateFormatProcessor
extends AbstractProcessor<Input, Output> {
    private String pattern;

    protected DateFormatProcessor() {
        super(Output.class);
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        if (this.pattern == null) {
            validationErrors.add(new ConfigurationException("'pattern' is mandatory"));
        }
    }

    @Override
    @Nullable
    public Input createInputParameter() {
        return new Input();
    }

    @Override
    @Nullable
    public Output execute(Input values, Processor.ExecutionContext context) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.pattern, values.REPORT_LOCALE);
        if (values.timezone != null) {
            dateFormat.setTimeZone(TimeZone.getTimeZone(values.timezone));
        }
        return new Output(dateFormat);
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public static final class Output {
        public final DateFormat dateFormat;

        public Output(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }
    }

    public static final class Input {
        @HasDefaultValue
        public String timezone;
        public Locale REPORT_LOCALE;
    }
}

