/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http.matcher;

import java.net.MalformedURLException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthScope;
import org.springframework.http.HttpMethod;

public final class MatchInfo {
    public static final String ANY_SCHEME = null;
    public static final String ANY_HOST = null;
    public static final String ANY_REALM = null;
    public static final String ANY_PATH = null;
    public static final String ANY_FRAGMENT = null;
    public static final String ANY_QUERY = null;
    public static final HttpMethod ANY_METHOD = null;
    public static final int ANY_PORT = -1;
    private final String scheme;
    private final String host;
    private final int port;
    private final String path;
    private final String fragment;
    private final String query;
    private final String realm;
    private final HttpMethod method;

    private MatchInfo(String scheme, String host, int port, String realm) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = ANY_PATH;
        this.query = ANY_QUERY;
        this.fragment = ANY_FRAGMENT;
        this.realm = realm;
        this.method = ANY_METHOD;
    }

    private MatchInfo(URI uri, int port, HttpMethod method) {
        this.scheme = uri.getScheme();
        this.host = uri.getHost();
        this.port = port;
        this.path = uri.getPath();
        this.query = uri.getQuery();
        this.fragment = uri.getFragment();
        this.realm = ANY_REALM;
        this.method = method;
    }

    public static MatchInfo fromUri(URI uri, HttpMethod method) {
        int newPort = uri.getPort();
        if (newPort < 0) {
            try {
                newPort = uri.toURL().getDefaultPort();
            }
            catch (IllegalArgumentException | MalformedURLException e) {
                newPort = -1;
            }
        }
        return new MatchInfo(uri, newPort, method);
    }

    public static MatchInfo fromAuthScope(AuthScope authscope) {
        String newScheme = StringUtils.equals((CharSequence)authscope.getScheme(), (CharSequence)AuthScope.ANY_SCHEME) ? ANY_SCHEME : authscope.getScheme();
        String newHost = StringUtils.equals((CharSequence)authscope.getHost(), (CharSequence)AuthScope.ANY_HOST) ? ANY_HOST : authscope.getHost();
        int newPort = authscope.getPort() == -1 ? -1 : authscope.getPort();
        String newRealm = StringUtils.equals((CharSequence)authscope.getRealm(), (CharSequence)AuthScope.ANY_REALM) ? ANY_REALM : authscope.getRealm();
        return new MatchInfo(newScheme, newHost, newPort, newRealm);
    }

    private static String valOrAny(String val) {
        return val != null ? val : "*";
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRealm() {
        return this.realm;
    }

    public String toString() {
        Object result = String.format("%s://%s:%s/%s", MatchInfo.valOrAny(this.scheme), MatchInfo.valOrAny(this.host), this.port != -1 ? Integer.toString(this.port) : "*", MatchInfo.valOrAny(this.path));
        if (this.method != ANY_METHOD) {
            result = this.method + " " + (String)result;
        }
        if (this.query != ANY_QUERY) {
            result = (String)result + "?" + this.query;
        }
        if (this.fragment != ANY_FRAGMENT) {
            result = (String)result + "#" + this.fragment;
        }
        return result;
    }
}

