/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.locationtech.jts.util.Assert;
import org.mapfish.print.PrintException;
import org.mapfish.print.output.Values;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorDependencyGraph;
import org.mapfish.print.processor.ProcessorExecutionContext;
import org.mapfish.print.processor.ProcessorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessorGraphNode<IN, OUT> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorGraphNode.class);
    private final Processor<IN, OUT> processor;
    private final Set<ProcessorGraphNode<?, ?>> dependencies = new HashSet();
    private final Set<ProcessorGraphNode> requirements = new HashSet<ProcessorGraphNode>();
    private final MetricRegistry metricRegistry;

    public ProcessorGraphNode(@Nonnull Processor<IN, OUT> processor, @Nonnull MetricRegistry metricRegistry) {
        this.processor = processor;
        this.metricRegistry = metricRegistry;
    }

    public Processor<?, ?> getProcessor() {
        return this.processor;
    }

    public void addDependency(ProcessorGraphNode node) {
        Assert.isTrue((node != this ? 1 : 0) != 0, (String)"A processor can't depends on himself");
        this.dependencies.add(node);
        node.addRequirement(this);
    }

    private void addRequirement(ProcessorGraphNode node) {
        this.requirements.add(node);
    }

    Set<ProcessorGraphNode> getRequirements() {
        return this.requirements;
    }

    Set<ProcessorGraphNode<?, ?>> getDependencies() {
        return this.dependencies;
    }

    public Optional<ProcessorNodeForkJoinTask<IN, OUT>> createTask(@Nonnull ProcessorExecutionContext execContext) {
        if (!execContext.tryStart(this)) {
            return Optional.empty();
        }
        return Optional.of(new ProcessorNodeForkJoinTask(this, execContext));
    }

    @Nonnull
    public BiMap<String, String> getOutputMapper() {
        BiMap<String, String> outputMapper = this.processor.getOutputMapperBiMap();
        if (outputMapper == null) {
            return HashBiMap.create();
        }
        return outputMapper;
    }

    @Nonnull
    public BiMap<String, String> getInputMapper() {
        BiMap<String, String> inputMapper = this.processor.getInputMapperBiMap();
        if (inputMapper == null) {
            return HashBiMap.create();
        }
        return inputMapper;
    }

    public void toString(StringBuilder builder, int indent, String parent) {
        this.processor.toString(builder, indent, parent);
        for (ProcessorGraphNode<?, ?> dependency : this.dependencies) {
            dependency.toString(builder, indent + 1, this.processor.toString());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder, 0, "?");
        return builder.toString();
    }

    public String getName() {
        return this.processor.toString();
    }

    public Set<? extends Processor<?, ?>> getAllProcessors() {
        IdentityHashMap all = new IdentityHashMap();
        all.put(this.getProcessor(), null);
        for (ProcessorGraphNode<?, ?> dependency : this.dependencies) {
            for (Processor<?, ?> p : dependency.getAllProcessors()) {
                all.put(p, null);
            }
        }
        return all.keySet();
    }

    public static final class ProcessorNodeForkJoinTask<In, Out>
    extends RecursiveTask<Values> {
        private final ProcessorExecutionContext execContext;
        private final ProcessorGraphNode<In, Out> node;

        private ProcessorNodeForkJoinTask(ProcessorGraphNode<In, Out> node, ProcessorExecutionContext execContext) {
            this.node = node;
            this.execContext = execContext;
        }

        @Override
        protected Values compute() {
            return this.execContext.getContext().mdcContext(() -> {
                Values values = this.execContext.getValues();
                this.executeProcess(this.node.processor, values);
                this.execContext.getContext().stopIfCanceled();
                ProcessorDependencyGraph.tryExecuteNodes(this.node.dependencies, this.execContext, true);
                return values;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeProcess(Processor<In, Out> process, Values values) {
            String timerName = MetricRegistry.name((String)ProcessorGraphNode.class.getSimpleName(), (String[])new String[]{"compute", process.getClass().getSimpleName()});
            Timer.Context timerContext = this.node.metricRegistry.timer(timerName).time();
            try {
                Out output;
                In inputParameter = ProcessorUtils.populateInputParameter(process, values);
                try {
                    LOGGER.debug("Executing process: {}", process);
                    output = process.execute(inputParameter, this.execContext.getContext());
                    LOGGER.debug("Succeeded in executing process: {}", process);
                }
                catch (RuntimeException e) {
                    throw this.handleException(e, e, process, timerName);
                }
                catch (Exception e) {
                    throw this.handleException(e, null, process, timerName);
                }
                if (output != null) {
                    ProcessorUtils.writeProcessorOutputToValues(output, process, values);
                }
            }
            finally {
                this.execContext.finished(this.node);
                long processorTime = TimeUnit.MILLISECONDS.convert(timerContext.stop(), TimeUnit.NANOSECONDS);
                LOGGER.info("Time taken to run processor: '{}' was {} ms", process.getClass(), (Object)processorTime);
            }
        }

        private RuntimeException handleException(Exception cause, RuntimeException runtimeCause, Processor<In, Out> process, String timerName) {
            LOGGER.info("Error while executing process: {}", process, (Object)cause);
            this.execContext.getContext().stopIfCanceled();
            this.node.metricRegistry.counter(MetricRegistry.name((String)timerName, (String[])new String[]{"error"})).inc();
            return Objects.requireNonNullElseGet(runtimeCause, () -> new PrintException("Failed to execute process:" + process, cause));
        }
    }
}

