/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.parser.ParserUtils;
import org.mapfish.print.processor.ExecutionStats;
import org.mapfish.print.processor.Processor;
import org.slf4j.MDC;

public abstract class AbstractProcessor<IN, OUT>
implements Processor<IN, OUT> {
    private final BiMap<String, String> inputMapper = HashBiMap.create();
    private final BiMap<String, String> outputMapper = HashBiMap.create();
    private final Class<OUT> outputType;
    private String prefix;
    private String inputPrefix;
    private String outputPrefix;

    protected AbstractProcessor(Class<OUT> outputType) {
        this.outputType = outputType;
    }

    @Override
    public final Class<OUT> getOutputType() {
        return this.outputType;
    }

    @Override
    @Nonnull
    public final BiMap<String, String> getInputMapperBiMap() {
        return this.inputMapper;
    }

    public final void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public final String getInputPrefix() {
        return this.inputPrefix == null ? this.prefix : this.inputPrefix;
    }

    public final void setInputPrefix(String inputPrefix) {
        this.inputPrefix = inputPrefix;
    }

    @Override
    public final String getOutputPrefix() {
        return this.outputPrefix == null ? this.prefix : this.outputPrefix;
    }

    public final void setOutputPrefix(String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    @Override
    public void toString(StringBuilder builder, int indent, String parent) {
        int spaces = indent * 2;
        for (int i = 0; i < spaces; ++i) {
            builder.append(' ');
        }
        builder.append("\"");
        builder.append(parent.replace("\"", "\\\""));
        builder.append("\" -> \"");
        builder.append(this.toString().replace("\"", "\\\""));
        builder.append("\";\n");
    }

    public final void setInputMapper(@Nonnull Map<String, String> inputMapper) {
        this.inputMapper.putAll(inputMapper);
    }

    @Override
    @Nonnull
    public final BiMap<String, String> getOutputMapperBiMap() {
        return this.outputMapper;
    }

    public final void setOutputMapper(@Nonnull Map<String, String> outputMapper) {
        this.outputMapper.putAll(outputMapper);
    }

    @Override
    public final void validate(List<Throwable> errors, Configuration configuration) {
        Object inputParameter = this.createInputParameter();
        Set<Object> allInputAttributeNames = inputParameter != null ? ParserUtils.getAllAttributeNames(inputParameter.getClass()) : Collections.emptySet();
        for (String inputAttributeName : this.inputMapper.values()) {
            if (allInputAttributeNames.contains(inputAttributeName)) continue;
            errors.add(new ConfigurationException(inputAttributeName + " is not defined in processor '" + this + "'.  Check for typos. Options are " + allInputAttributeNames));
        }
        Set<String> allOutputAttributeNames = ParserUtils.getAllAttributeNames(this.getOutputType());
        for (String outputAttributeName : this.outputMapper.keySet()) {
            if (allOutputAttributeNames.contains(outputAttributeName)) continue;
            errors.add(new ConfigurationException(outputAttributeName + " is not defined in processor '" + this + "' as an output attribute.  Check for typos. Options are " + allOutputAttributeNames));
        }
        this.extraValidation(errors, configuration);
    }

    protected abstract void extraValidation(List<Throwable> var1, Configuration var2);

    public String toString() {
        String outPrefix;
        Object result = this.getClass().getSimpleName();
        String inPrefix = this.getInputPrefix();
        if (inPrefix != null) {
            result = (String)result + " in=" + inPrefix;
        }
        if ((outPrefix = this.getOutputPrefix()) != null) {
            result = (String)result + " out=" + outPrefix;
        }
        return result;
    }

    public static final class Context
    implements Processor.ExecutionContext {
        @Nonnull
        private final Map<String, String> mdcContext;
        private volatile boolean canceled = false;
        private final ExecutionStats stats = new ExecutionStats();

        public Context(@Nonnull Map<String, String> mdcContext) {
            this.mdcContext = mdcContext;
        }

        public void cancel() {
            this.canceled = true;
        }

        @Override
        public void stopIfCanceled() {
            if (this.canceled) {
                throw new CancellationException("task was canceled");
            }
        }

        @Override
        public ExecutionStats getStats() {
            return this.stats;
        }

        @Override
        public Map<String, String> getMDCContext() {
            return this.mdcContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T mdcContext(Supplier<T> action) {
            boolean changed;
            this.stopIfCanceled();
            Map prev = MDC.getCopyOfContextMap();
            String prevJomId = MDC.get((String)"job_id");
            String jobId = this.mdcContext == null ? null : this.mdcContext.get("job_id");
            boolean bl = changed = prevJomId == null || jobId != null && jobId.equals(prevJomId);
            if (changed) {
                MDC.setContextMap(this.mdcContext);
            }
            try {
                T t = action.get();
                return t;
            }
            finally {
                if (changed) {
                    MDC.setContextMap((Map)prev);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T mdcContextEx(Callable<T> action) throws Exception {
            boolean mdcChanged;
            this.stopIfCanceled();
            Map prev = MDC.getCopyOfContextMap();
            boolean bl = mdcChanged = !this.mdcContext.equals(prev);
            if (mdcChanged) {
                MDC.setContextMap(this.mdcContext);
            }
            try {
                T t = action.call();
                return t;
            }
            finally {
                if (mdcChanged) {
                    MDC.setContextMap((Map)prev);
                }
            }
        }
    }
}

