/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.repo.RepositoryService;
import org.locationtech.jts.util.AssertionFailedException;
import org.mapfish.print.PrintException;
import org.mapfish.print.attribute.map.MapAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.config.WorkingDirectories;
import org.mapfish.print.http.MfClientHttpRequestFactoryImpl;
import org.mapfish.print.output.MapfishPrintRepositoryService;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.output.ResourceBundleClassLoader;
import org.mapfish.print.output.Values;
import org.mapfish.print.output.ValuesLogger;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorDependencyGraph;
import org.mapfish.print.processor.http.MfClientHttpRequestFactoryProvider;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractJasperReportOutputFormat
implements OutputFormat {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJasperReportOutputFormat.class);
    @Autowired
    private ForkJoinPool forkJoinPool;
    @Autowired
    private WorkingDirectories workingDirectories;
    @Autowired
    private MfClientHttpRequestFactoryImpl httpRequestFactory;
    @Value(value="${httpRequest.fetchRetry.maxNumber}")
    private int httpRequestMaxNumberFetchRetry;
    @Value(value="${httpRequest.fetchRetry.intervalMillis}")
    private int httpRequestFetchRetryIntervalMillis;

    protected abstract void doExport(OutputStream var1, Print var2) throws JRException, IOException;

    @Override
    public final Processor.ExecutionContext print(@Nonnull Map<String, String> mdcContext, PJsonObject requestData, Configuration config, File configDir, File taskDirectory, OutputStream outputStream) throws Exception {
        Print print = this.getJasperPrint(mdcContext, requestData, config, configDir, taskDirectory);
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException();
        }
        this.doExport(outputStream, print);
        return print.executionContext;
    }

    private JasperFillManager getJasperFillManager(MfClientHttpRequestFactoryProvider httpRequestFactoryProvider) {
        JasperReportsContext ctx = this.getJasperReportsContext(httpRequestFactoryProvider);
        return JasperFillManager.getInstance((JasperReportsContext)ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    public final Print getJasperPrint(@Nonnull Map<String, String> mdcContext, PJsonObject requestData, Configuration config, File configDir, File taskDirectory) throws JRException, SQLException, ExecutionException {
        JasperPrint print;
        String templateName = requestData.getString("layout");
        Template template = config.getTemplate(templateName);
        File jasperTemplateFile = new File(configDir, template.getReportTemplate());
        File jasperTemplateBuild = this.workingDirectories.getBuildFileFor(config, jasperTemplateFile, ".jasper", LOGGER);
        Values values = new Values(mdcContext, requestData, template, taskDirectory, this.httpRequestFactory, jasperTemplateBuild.getParentFile(), this.httpRequestMaxNumberFetchRetry, this.httpRequestFetchRetryIntervalMillis);
        double maxDpi = this.maxDpi(values);
        ProcessorDependencyGraph.ProcessorGraphForkJoinTask task = template.getProcessorGraph().createTask(values);
        ForkJoinTask<Values> taskFuture = this.forkJoinPool.submit(task);
        try {
            taskFuture.get();
        }
        catch (InterruptedException exc) {
            taskFuture.cancel(true);
            Thread.currentThread().interrupt();
            throw new CancellationException();
        }
        String resourceBundle = config.getResourceBundle();
        if (resourceBundle != null) {
            values.put("REPORT_RESOURCE_BUNDLE", ResourceBundle.getBundle(resourceBundle, values.getObject("REPORT_LOCALE", Locale.class), new ResourceBundleClassLoader(configDir)));
        }
        ValuesLogger.log(templateName, template, values);
        JasperFillManager fillManager = this.getJasperFillManager(values.getObject("clientHttpRequestFactoryProvider", MfClientHttpRequestFactoryProvider.class));
        this.checkRequiredValues(config, values, template.getReportTemplate());
        for (String jdbcDriver : template.getJdbcDrivers()) {
            try {
                Class.forName(jdbcDriver);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)String.format("Unable to load JDBC driver: " + jdbcDriver + " ensure that the web application has the jar on its classpath", new Object[0]));
            }
        }
        if (template.getJdbcUrl() != null) {
            Connection connection = null;
            try {
                connection = template.getJdbcUser() != null ? DriverManager.getConnection(template.getJdbcUrl(), template.getJdbcUser(), template.getJdbcPassword()) : DriverManager.getConnection(template.getJdbcUrl());
                print = fillManager.fill(jasperTemplateBuild.getAbsolutePath(), values.asMap(), connection);
            }
            finally {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
        } else {
            JREmptyDataSource dataSource;
            if (template.getTableDataKey() != null) {
                Object dataSourceObj = values.getObject(template.getTableDataKey(), Object.class);
                if (dataSourceObj instanceof JRDataSource) {
                    dataSource = (JRDataSource)dataSourceObj;
                } else if (dataSourceObj instanceof Iterable) {
                    Iterable sourceObj = (Iterable)dataSourceObj;
                    dataSource = this.toJRDataSource(sourceObj.iterator());
                } else if (dataSourceObj instanceof Iterator) {
                    Iterator sourceObj = (Iterator)dataSourceObj;
                    dataSource = this.toJRDataSource(sourceObj);
                } else {
                    if (!dataSourceObj.getClass().isArray()) throw new AssertionError((Object)String.format("Objects of type: %s cannot be converted to a row in a JRDataSource", dataSourceObj.getClass()));
                    Object[] sourceObj = (Object[])dataSourceObj;
                    dataSource = this.toJRDataSource(Arrays.asList(sourceObj).iterator());
                }
            } else {
                dataSource = new JREmptyDataSource();
            }
            this.checkRequiredFields(config, (JRDataSource)dataSource, template.getReportTemplate());
            print = fillManager.fill(jasperTemplateBuild.getAbsolutePath(), values.asMap(), (JRDataSource)dataSource);
        }
        print.setProperty("net.sf.jasperreports.image.dpi", String.valueOf(Math.round(maxDpi)));
        return new Print(this.getJasperReportsContext(values.getObject("clientHttpRequestFactoryProvider", MfClientHttpRequestFactoryProvider.class)), print, values, maxDpi, task.getExecutionContext());
    }

    private void checkRequiredFields(Configuration configuration, JRDataSource dataSource, String reportTemplate) {
        if (dataSource instanceof JRRewindableDataSource) {
            JRRewindableDataSource source = (JRRewindableDataSource)dataSource;
            StringBuilder wrongType = new StringBuilder();
            try {
                while (source.next()) {
                    Document document = this.parseXML(configuration, reportTemplate);
                    NodeList parameters = document.getElementsByTagName("field");
                    JRDesignField field = new JRDesignField();
                    for (int i = 0; i < parameters.getLength(); ++i) {
                        Element param = (Element)parameters.item(i);
                        String name = param.getAttribute("name");
                        field.setName(name);
                        Object fieldValue = dataSource.getFieldValue((JRField)field);
                        if (fieldValue != null) {
                            String type = param.getAttribute("class");
                            Class<?> clazz = Class.forName(type);
                            if (clazz.isInstance(fieldValue)) continue;
                            wrongType.append("\t* ").append(name).append(": ").append(fieldValue.getClass().getName());
                            wrongType.append(" expected type: ").append(type).append("\n");
                            continue;
                        }
                        LOGGER.warn("The field {} in {} is not available in at least one of the rows in the datasource.  This may not be an error.", (Object)name, (Object)reportTemplate);
                    }
                }
                source.moveFirst();
            }
            catch (IOException | ClassNotFoundException | ParserConfigurationException | JRException | SAXException e) {
                throw new PrintException("Checking required fields failed", e);
            }
            StringBuilder finalError = new StringBuilder();
            this.assertNoError(reportTemplate, wrongType, finalError);
        }
    }

    private void checkRequiredValues(Configuration configuration, Values values, String reportTemplate) {
        StringBuilder missing = new StringBuilder();
        StringBuilder wrongType = new StringBuilder();
        try {
            Document document = this.parseXML(configuration, reportTemplate);
            NodeList parameters = document.getElementsByTagName("parameter");
            for (int i = 0; i < parameters.getLength(); ++i) {
                Object value;
                Element param = (Element)parameters.item(i);
                String name = param.getAttribute("name");
                if (!values.containsKey(name)) {
                    if (param.getElementsByTagName("defaultValueExpression").getLength() != 0) continue;
                    missing.append("\t* ").append(name).append("\n");
                    continue;
                }
                String type = param.getAttribute("class");
                Class<?> clazz = Class.forName(type);
                if (clazz.isInstance(value = values.getObject(name, Object.class))) continue;
                wrongType.append("\t* ").append(name).append(": ").append(value.getClass().getName());
                wrongType.append(" expected type: ").append(type).append("\n");
            }
        }
        catch (IOException | ClassNotFoundException | ParserConfigurationException | SAXException e) {
            throw new PrintException("Checking required values failed", e);
        }
        StringBuilder finalError = new StringBuilder();
        if (missing.length() > 0) {
            finalError.append("The following parameters are declared in ").append(reportTemplate).append(" but are not output values of processors or attributes.").append("\nEither remove the references or update the configuration so that all the ").append("parameters are available for the report.\n\n").append((CharSequence)missing);
        }
        this.assertNoError(reportTemplate, wrongType, finalError);
    }

    private void assertNoError(String reportTemplate, StringBuilder wrongType, StringBuilder finalError) {
        if (wrongType.length() > 0) {
            finalError.append("The following parameters are declared in ").append(reportTemplate).append(".  The class attribute in the template xml does not match the class of the actual object.").append("\nEither change the declaration in the jasper template or update the configuration so that the parameters have the correct type.\n\n").append((CharSequence)wrongType);
        }
        if (finalError.length() > 0) {
            throw new AssertionFailedException(finalError.toString());
        }
    }

    private Document parseXML(Configuration configuration, String reportTemplate) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        byte[] bytes = configuration.loadFile(reportTemplate);
        return documentBuilder.parse(new ByteArrayInputStream(bytes));
    }

    private JasperReportsContext getJasperReportsContext(MfClientHttpRequestFactoryProvider httpRequestFactoryProvider) {
        SimpleJasperReportsContext ctx = new SimpleJasperReportsContext((JasperReportsContext)DefaultJasperReportsContext.getInstance());
        ctx.setExtensions(RepositoryService.class, Collections.singletonList(new MapfishPrintRepositoryService(httpRequestFactoryProvider.get())));
        return ctx;
    }

    private JRDataSource toJRDataSource(@Nonnull Iterator iterator) {
        ArrayList<Map> rows = new ArrayList<Map>();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next instanceof Values) {
                Values values = (Values)next;
                rows.add(values.asMap());
                continue;
            }
            if (next instanceof Map) {
                Map map = (Map)next;
                rows.add(map);
                continue;
            }
            throw new AssertionError((Object)String.format("Objects of type: %s cannot be converted to a row in a JRDataSource", next.getClass()));
        }
        return new JRMapCollectionDataSource(rows);
    }

    private double maxDpi(Values values) {
        Map<String, MapAttribute.MapAttributeValues> maps = values.find(MapAttribute.MapAttributeValues.class);
        double maxDpi = 72.0;
        for (MapAttribute.MapAttributeValues attributeValues : maps.values()) {
            if (!(attributeValues.getDpi() > maxDpi)) continue;
            maxDpi = attributeValues.getDpi();
        }
        return maxDpi;
    }

    public static final class Print {
        @Nonnull
        public final JasperPrint print;
        @Nonnegative
        public final double dpi;
        @Nonnull
        public final Processor.ExecutionContext executionContext;
        @Nonnull
        public final JasperReportsContext context;
        @Nonnull
        public final Values values;

        private Print(@Nonnull JasperReportsContext context, @Nonnull JasperPrint print, @Nonnull Values values, @Nonnegative double dpi, @Nonnull Processor.ExecutionContext executionContext) {
            this.print = print;
            this.context = context;
            this.values = values;
            this.dpi = dpi;
            this.executionContext = executionContext;
        }
    }
}

